/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.choreos.services.datamodel;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.ow2.choreos.nodes.datamodel.Node;
import org.ow2.choreos.services.datamodel.DeployableServiceSpec;
import org.ow2.choreos.services.datamodel.PackageType;
import org.ow2.choreos.services.datamodel.ServiceType;

public class ServiceInstance {
    private Node node;
    private String easyEsbNodeAdminEndpoint;
    private String nativeUri;
    private Map<ServiceType, String> busUris = new HashMap<ServiceType, String>();
    private String instanceId;
    private DeployableServiceSpec serviceSpec;

    public ServiceInstance() {
    }

    public ServiceInstance(Node node) {
        this.setNode(node);
        this.setInstanceId(UUID.randomUUID().toString());
    }

    public Map<ServiceType, String> getBusUris() {
        return this.busUris;
    }

    public void setBusUris(Map<ServiceType, String> busUris) {
        this.busUris = busUris;
    }

    public DeployableServiceSpec getServiceSpec() {
        return this.serviceSpec;
    }

    public void setServiceSpec(DeployableServiceSpec serviceSpec) {
        this.serviceSpec = serviceSpec;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public String getBusUri(ServiceType type) {
        return this.busUris.get((Object)type);
    }

    public void setBusUri(ServiceType type, String uri) {
        this.busUris.put(type, uri);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setNativeUri(String uri) {
        this.nativeUri = uri;
    }

    public String getNativeUri() {
        if (this.definedNativeUri()) {
            return this.nativeUri;
        }
        return this.getDefaultnativeUri();
    }

    private boolean definedNativeUri() {
        return this.nativeUri != null && !this.nativeUri.isEmpty();
    }

    private String getDefaultnativeUri() {
        String uriContext;
        String _hostname = this.node.getHostname();
        String _ip = this.node.getIp();
        if (_hostname == null && _ip == null) {
            throw new IllegalStateException("Sorry, I don't know neither the hostname nor the IP yet");
        }
        String endpointName = this.serviceSpec.getEndpointName();
        PackageType packageType = this.serviceSpec.getPackageType();
        switch (packageType) {
            case TOMCAT: {
                uriContext = this.serviceSpec.getUUID() + "/" + endpointName;
                break;
            }
            case COMMAND_LINE: {
                uriContext = endpointName + "/";
                break;
            }
            case EASY_ESB: {
                uriContext = "services/" + endpointName + "ClientProxyEndpoint/";
                break;
            }
            default: {
                throw new IllegalStateException("Sorry, I don't know how to provide an URL to a " + (Object)((Object)packageType) + " service.");
            }
        }
        int port = this.serviceSpec.getPort();
        if (_ip != null && !_ip.isEmpty()) {
            return "http://" + _ip + ":" + port + "/" + uriContext;
        }
        return "http://" + _hostname + ":" + port + "/" + uriContext;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nativeUri == null ? 0 : this.nativeUri.hashCode());
        result = 31 * result + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        result = 31 * result + (this.serviceSpec == null ? 0 : this.serviceSpec.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceInstance other = (ServiceInstance)obj;
        if (this.nativeUri == null ? other.nativeUri != null : !this.nativeUri.equals(other.nativeUri)) {
            return false;
        }
        boolean equalsInstance = true;
        if (this.instanceId == null) {
            if (other.instanceId != null) {
                equalsInstance = false;
            }
        } else if (!this.instanceId.equals(other.instanceId)) {
            equalsInstance = false;
        }
        boolean equalsService = true;
        if (this.serviceSpec == null) {
            if (other.serviceSpec != null) {
                equalsService = false;
            }
        } else if (!this.serviceSpec.equals(other.serviceSpec)) {
            equalsService = false;
        }
        return equalsInstance && equalsService;
    }

    public String getEasyEsbNodeAdminEndpoint() {
        return this.easyEsbNodeAdminEndpoint;
    }

    public void setEasyEsbNodeAdminEndpoint(String easyEsbNodeAdminEndpoint) {
        this.easyEsbNodeAdminEndpoint = easyEsbNodeAdminEndpoint;
    }

    public String toString() {
        return "ServiceInstance [hostname=" + this.node.getHostname() + ", ip=" + this.node.getIp() + ", node=" + this.node + ", easyEsbNodeAdminEndpoint=" + this.easyEsbNodeAdminEndpoint + ", nativeUri=" + this.nativeUri + ", instanceId=" + this.instanceId + ", serviceUUID=" + this.serviceSpec.getUUID() + "]";
    }
}

