/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.jmi.ClassLoaderManager;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabException;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.MatlabLooper;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mwt.window.WindowRegistry;
import com.mathworks.services.Prefs;
import com.mathworks.services.message.MWMessage;
import com.mathworks.util.ClassLoaderBridge;
import com.mathworks.util.ClassLoaderSupplier;
import com.mathworks.util.FactoryUtilAdapter;
import com.mathworks.util.FactoryUtilSupplier;
import com.mathworks.util.FactoryUtils;
import com.mathworks.util.Log;
import com.mathworks.util.MatlabThreadException;
import com.mathworks.util.NativeJava;
import com.mathworks.util.NativeJavaSwitch;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.JOptionPane;

public class Matlab {
    public static final int EVAL = -1;
    public static final int CONSOLE_OUTPUT = 0;
    public static final int CAPTURE_OUTPUT = 1;
    public static final int STREAM_OUTPUT = 2;
    public static final int NO_OUTPUT = 4;
    public static final int CELL_EVAL = 256;
    public static final int BEEPLESS_EVAL = 512;
    public static final int DEBUG_EVAL = 1024;
    public static final int SIM_DEBUG_EVAL = 2048;
    public static final int NO_BREAKPOINT = 4096;
    public static final int RESULT = -2;
    public static final int FEVAL = -3;
    public static final int STD_OUT = -4;
    public static final int STD_ERR = -5;
    public static final int SEND = -6;
    public static final int INTERRUPT = -7;
    public static final int REGISTER_INTEREST = -8;
    public static final int UNREGISTER_INTEREST = -9;
    public static final int INTEREST_REPLY = -10;
    static final int POST_KEY = -13;
    static final int SET_WINDOW_SIZE = -14;
    static final int GET_CWD = -17;
    static final int MAX_TAB_COMPLETIONS = -18;
    static final int JAVA_SUPPORT_QUERY = -19;
    static final int KEEP_ALIVE = -20;
    private static final int LAST_MESSAGE_ID = -21;
    static final int KEEP_ALIVE_PERIOD = 5;
    public static final int DEBUG_FAMILY = 1;
    public static final int DEBUG_BP_ADD = Integer.MIN_VALUE;
    public static final int DEBUG_BP_CLEAR = 0x40000000;
    public static final int DEBUG_BP_DELETE = 0x20000000;
    public static final int DEBUG_EXIT = 0x10000000;
    public static final int DEBUG_GO = 0x8000000;
    public static final int DEBUG_STOP = 0x4000000;
    public static final int DEBUG_STOPIF = 0x2000000;
    public static final int DEBUG_UPDOWN = 0x1000000;
    public static final int DEBUG_ALL_EVENTS = 1;
    public static final int PATH_FAMILY = 2;
    public static final int PATH_CHANGE = Integer.MIN_VALUE;
    public static final int PATH_CWD_CHANGE = 0x40000000;
    public static final int PATH_ALL_EVENTS = 1;
    public static final int WORKSPACE_FAMILY = 3;
    public static final int WS_SCOPE = Integer.MIN_VALUE;
    public static final int WS_ADD = 0x40000000;
    public static final int WS_CLEAR = 0x20000000;
    public static final int WS_DELETE = 0x10000000;
    public static final int WS_ARRAY_CHANGE = 0x8000000;
    public static final int WS_ARRAY_ALL = 1;
    public static final int GENERAL_FAMILY = 5;
    public static final int GEN_CMD_TEXT = 0;
    public static final int GEN_CMD_CLC = -1;
    public static final int GEN_CMD_HOME = -2;
    public static final int GEN_CMD_PROMPT = -3;
    public static final int GEN_CMD_STATUS_TEXT = -4;
    public static final int DEBUG_STOPIF_ERROR = 1;
    public static final int DEBUG_STOPIF_WARNING = 2;
    public static final int DEBUG_STOPIF_CATCH = 4;
    public static final int DEBUG_STOPIF_NANINF = 8;
    public static final int DEBUG_STOPIF_ALLERROR = 16;
    public static final String STRING_STR = "string";
    public static final String FLAGS_STR = "flags";
    public static final String RESULT_STR = "result";
    public static final String STATUS_STR = "status";
    public static final String ARGUMENTS_STR = "arguments";
    public static final String NLHS_STR = "nlhs";
    public static final String VALUE_STR = "value";
    public static final String ANONYMOUS_STR = "anonymous";
    public static final String HANDLE_STR = "handle";
    public static final String FAMILYID_STR = "familyid";
    public static final String EVENTID_STR = "eventid";
    public static final String INTEREST_STR = "interest";
    public static final String LEVEL_STR = "level";
    public static final String LINENO_STR = "lineno";
    public static final String CMD_STR = "cmd";
    public static final String PROMPT_STR = "prompt";
    public static final String CLIENT_STR = "client";
    public static final int NO = 0;
    public static final int YES = 1;
    public static final int EXECUTION_SUCCESS = 0;
    public static final int COMPILE_ERROR = 1;
    public static final int RUNTIME_ERROR = 2;
    public static final int EXECUTION_DBQUIT = 3;
    public static final int EXECUTION_CTRLC = 4;
    public static final int STREAM_STATUS = 33;
    public static final int EXECUTION_PARK = 34;
    public static final int EXECUTION_UNPARK = 35;
    public static final int NO_PROMPT = -1;
    public static final int BASE_PROMPT = 0;
    public static final int DEBUG_PROMPT = 1;
    public static final int INPUT_PROMPT = 2;
    public static final int KEYBOARD_PROMPT = 3;
    public static final int PAUSE_PROMPT = 4;
    public static final int BANG_PROMPT = 5;
    public static final int SIMULINK_DEBUG_PROMPT = 6;
    public static final int INCOMPLETE_BLOCK_PROMPT = 7;
    public static final int MORE_PROMPT = 8;
    public static final int EMERGENCY_EXIT_PROMPT = 9;
    public static final int SIMEVENTS_DEBUG_PROMPT = 10;
    public static final int COMPLETE_CODE_BLOCK = 0;
    public static final int INCOMPLETE_CODE_BLOCK = 1;
    public static final int INVALID_CODE_BLOCK = 2;
    public static final int HG_FIGURE_CREATED = 1;
    public static final int HG_RENDERING = 2;
    public static final int HG_CALLBACK_RUNNING = 4;
    private static final int PROFILER_ON = 16;
    static final int MT_FEVAL = 0;
    static final int MT_GET = 1;
    static final int MT_SET = 2;
    static final int MT_FORM_TAB_COMPLETIONS = 5;
    static final int MT_LICENSE_CHECK = 6;
    static final int MT_LICENSE_CHECKOUT = 7;
    static final int MT_FIND_ALL_TAB_COMPLETIONS = 8;
    private static Vector<MatlabListener> sListeners = new Vector();
    public static final int COMMERCIAL = 1;
    public static final int STUDENT = 2;
    public static final int STANDALONE = 3;
    public static final int DMLWORKER = 4;
    private static boolean sMatlabAvailable;
    private static boolean sSimulinkAvailable;
    private static String sMatlabRoot;
    private static int sRuntimeVariant;
    private static int sNameLengthMax;
    private static boolean sEchoEval;
    private MatlabMCR fMatlabMCR = new MatlabMCR();
    private static MWMessage sKeepAliveMsg;
    private static Timer sKeepAliveTimer;
    private static boolean sItsAlive;
    private static MatlabLooper sDispatcher;

    public int setThreadSafetyCheckLevel(int n) {
        return this.fMatlabMCR.setThreadSafetyCheckLevel(n);
    }

    private static void initMatlab() {
        if (Matlab.isMatlabAvailable()) {
            Matlab.addListener(new MatlabQuitListener());
            FactoryUtils.setDirectorySeed((FactoryUtilSupplier)new MatlabDirSeed());
            if (PlatformInfo.isWindows() || PlatformInfo.isXWindows()) {
                FactoryUtils.setRestoreMatlabWindows((FactoryUtilSupplier)new RestoreMatlabWindows());
                FactoryUtils.setDisableMatlabWindows((FactoryUtilSupplier)new DisableMatlabWindows());
            }
            FactoryUtils.setProcessPendingEvents((FactoryUtilSupplier)new ProcessPendingEvents());
            FactoryUtils.setProcessExposeEvents((FactoryUtilSupplier)new ProcessExposeEvents());
            FactoryUtils.setMatlabWait((FactoryUtilSupplier)new MatlabWait());
            FactoryUtils.setMatlabNotify((FactoryUtilSupplier)new MatlabNotify());
            FactoryUtils.setIsMatlabThread((FactoryUtilSupplier)new IsMatlabThread());
            FactoryUtils.setInvokeAndWait((FactoryUtilSupplier)new InvokeAndWait());
            ClassLoaderBridge.setSupplier((ClassLoaderSupplier)new ClassLoaderSupplier(){

                public Class findClass(String string) throws ClassNotFoundException {
                    return ClassLoaderManager.findClass(string);
                }
            });
            if (NativeJava.nativeLibraryExists() && PlatformInfo.getPlatform() == 1) {
                NativeJava.MatlabInitialized();
            }
            if (NativeJavaSwitch.isLoadingEnabled()) {
                try {
                    System.loadLibrary("nativejmi");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    JOptionPane.showMessageDialog(null, "Failed to load nativejmi: unsatisfied link", "ERROR", 0);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Failed to load nativejmi", "ERROR", 0);
                    Log.logException((Exception)exception);
                }
            }
            switch (Matlab.getRuntimeVariant()) {
                case 1: 
                case 2: {
                    Matlab.startKeepAliveTimer();
                    break;
                }
            }
        }
    }

    private static void startKeepAliveTimer() {
        sKeepAliveMsg = new MWMessage(-20);
        sKeepAliveTimer = new Timer();
        sKeepAliveTimer.schedule(new TimerTask(){

            public void run() {
                if (sItsAlive) {
                    sDispatcher.postMatlabMessage(sKeepAliveMsg, null);
                    sItsAlive = false;
                }
            }
        }, 300000L, 300000L);
    }

    private static void setMatlabAvailable(boolean bl, int n, int n2, String string) {
        sMatlabAvailable = bl;
        sRuntimeVariant = n;
        sNameLengthMax = n2;
        if (string != null) {
            sMatlabRoot = string;
        }
        Matlab.initMatlab();
        File file = new File(Matlab.matlabRoot() + "/toolbox/simulink/simulink");
        sSimulinkAvailable = file.exists() && file.isDirectory();
    }

    public static boolean isMatlabAvailable() {
        return sMatlabAvailable;
    }

    public static boolean isSimulinkAvailable() {
        return sSimulinkAvailable;
    }

    public static boolean isStudentVersion() {
        return sRuntimeVariant == 2;
    }

    public static int getRuntimeVariant() {
        return sRuntimeVariant;
    }

    public static int getNameLengthMax() {
        return sNameLengthMax;
    }

    public static String matlabRoot() {
        if (sMatlabRoot == null) {
            sMatlabRoot = "";
        }
        return sMatlabRoot;
    }

    public static void addListener(MatlabListener matlabListener) {
        sListeners.addElement(matlabListener);
    }

    private static void resetMatlab() {
        sListeners = new Vector();
        if (sKeepAliveTimer != null) {
            sKeepAliveTimer.cancel();
            sKeepAliveTimer = null;
            sItsAlive = false;
        }
    }

    public static void removeListener(MatlabListener matlabListener) {
        sListeners.removeElement(matlabListener);
    }

    public static void fireEvent(MatlabEvent matlabEvent) {
        for (int i = 0; i < sListeners.size(); ++i) {
            sListeners.elementAt(i).matlabEvent(matlabEvent);
        }
    }

    public static boolean setEchoEval(boolean bl) {
        boolean bl2 = sEchoEval;
        sEchoEval = bl;
        return bl2;
    }

    public static boolean isOkToExit() {
        boolean bl = false;
        try {
            Method method;
            Class<?> clazz = Class.forName("com.mathworks.mde.desk.MLDesktop");
            if (clazz != null && (method = clazz.getMethod("getInstanceNoCreate", new Class[0])) != null) {
                Object[] objectArray = new Object[0];
                Object object = method.invoke(null, objectArray);
                if (object == null) {
                    bl = true;
                } else {
                    method = clazz.getMethod("canClose", new Class[0]);
                    if (method != null) {
                        bl = (Boolean)method.invoke(object, objectArray);
                    }
                }
            }
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        return bl;
    }

    private static void matlabQuitting() {
        try {
            Object[] objectArray;
            Object object;
            Method method;
            Class<?> clazz = Class.forName("com.mathworks.mde.desk.MLDesktop");
            if (clazz != null && (method = clazz.getMethod("getInstanceNoCreate", new Class[0])) != null && (object = method.invoke(null, objectArray = new Object[0])) != null) {
                method = clazz.getMethod("close", new Class[0]);
                method.invoke(object, objectArray);
            }
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        if (WindowRegistry.getRegistry().closeAllJavaWindows() == 0) {
            Matlab.fireEvent(new MatlabEvent(1));
            Prefs.save();
        }
    }

    public static int getHGStatus(int n) {
        n = n >>> 24 & 0x7F;
        return n & 0xFFFFFFEF;
    }

    public static int getProfilerStatus(int n) {
        return n >>> 24 & 0x10;
    }

    public static int getExecutionStatus(int n) {
        return n >>> 16 & 0x7F;
    }

    public static int getInputRequester(int n) {
        if ((n = n >>> 8 & 0xFF) == 255) {
            n = -1;
        }
        return n;
    }

    public static int getCodeBlockStatus(int n) {
        return n & 0xFF;
    }

    public void evalConsoleOutput(String string) {
        this.fMatlabMCR.evalConsoleOutput(string);
    }

    public void evalConsoleOutput(String string, CompletionObserver completionObserver) {
        this.fMatlabMCR.evalConsoleOutput(string, completionObserver);
    }

    public void evalConsoleOutput(String string, MatlabListener matlabListener) {
        this.fMatlabMCR.evalConsoleOutput(string, matlabListener);
    }

    public void evalConsoleOutput(String string, CompletionObserver completionObserver, int n) {
        this.fMatlabMCR.evalConsoleOutput(string, completionObserver, n);
    }

    public void evalNoOutput(String string) {
        this.fMatlabMCR.evalNoOutput(string);
    }

    public void evalNoOutput(String string, CompletionObserver completionObserver) {
        this.fMatlabMCR.evalNoOutput(string, completionObserver);
    }

    public void evalNoOutput(String string, int n) {
        this.fMatlabMCR.evalNoOutput(string, n);
    }

    public void evalStreamOutput(String string, CompletionObserver completionObserver) {
        this.fMatlabMCR.evalStreamOutput(string, completionObserver);
    }

    public void evalStreamOutput(String string, CompletionObserver completionObserver, int n) {
        this.fMatlabMCR.evalStreamOutput(string, completionObserver, n);
    }

    public void evalStreamOutput(String string, CompletionObserver completionObserver, MWMessage mWMessage) {
        this.fMatlabMCR.evalStreamOutput(string, completionObserver, mWMessage);
    }

    public void eval(char c) {
        this.fMatlabMCR.eval(c);
    }

    public void eval(String string, CompletionObserver completionObserver) {
        this.fMatlabMCR.eval(string, completionObserver);
    }

    public void eval(String string, MatlabListener matlabListener) {
        this.fMatlabMCR.eval(string, matlabListener);
    }

    public void eval(String string, CompletionObserver completionObserver, int n) {
        this.fMatlabMCR.eval(string, completionObserver, n);
    }

    public void eval(String string, MatlabListener matlabListener, int n) {
        this.fMatlabMCR.eval(string, matlabListener, n);
    }

    public void fevalNoOutput(String string, Object[] objectArray) {
        this.fMatlabMCR.fevalNoOutput(string, objectArray);
    }

    public void feval(String string, Object[] objectArray, CompletionObserver completionObserver) {
        this.fMatlabMCR.feval(string, objectArray, completionObserver);
    }

    public void feval(String string, Object[] objectArray, int n, CompletionObserver completionObserver) {
        this.fMatlabMCR.feval(string, objectArray, n, completionObserver);
    }

    public void feval(String string, Object[] objectArray, int n, MatlabListener matlabListener) {
        this.fMatlabMCR.feval(string, objectArray, n, matlabListener);
    }

    public void fevalConsoleOutput(String string, Object[] objectArray, int n, CompletionObserver completionObserver) {
        this.fMatlabMCR.fevalConsoleOutput(string, objectArray, n, completionObserver);
    }

    public void fevalConsoleOutput(String string, Object[] objectArray, int n, MatlabListener matlabListener) {
        this.fMatlabMCR.fevalConsoleOutput(string, objectArray, n, matlabListener);
    }

    public void fevalConsoleOutput(String string, Object[] objectArray) {
        this.fMatlabMCR.fevalConsoleOutput(string, objectArray);
    }

    @Deprecated
    public String eval(String string) throws InterruptedException, MatlabException {
        return this.fMatlabMCR.eval(string);
    }

    @Deprecated
    public Object feval(String string, Object[] objectArray) throws InterruptedException, MatlabException {
        return this.fMatlabMCR.feval(string, objectArray);
    }

    @Deprecated
    public Object feval(String string, Object[] objectArray, int n) throws InterruptedException, MatlabException {
        return this.fMatlabMCR.feval(string, objectArray, n);
    }

    public Object registerInterest(int n, int n2, CompletionObserver completionObserver) {
        return this.fMatlabMCR.registerInterest(n, n2, completionObserver);
    }

    public void unregisterInterest(Object object) {
        this.fMatlabMCR.unregisterInterest(object);
    }

    public void unregisterAll() {
        this.fMatlabMCR.unregisterAll();
    }

    public void interrupt() {
        this.fMatlabMCR.interrupt();
    }

    public void setWindowSize(int n, int n2) {
        this.fMatlabMCR.setWindowSize(n, n2);
    }

    public static void LMKeepAlive() {
        sItsAlive = true;
    }

    public static void whenAtPrompt(final Runnable runnable) {
        new Matlab().evalNoOutput("", new CompletionObserver(){

            public void completed(int n, Object object) {
                runnable.run();
            }
        });
    }

    public static void whenMatlabIdle(Runnable runnable) {
        sDispatcher.postMatlabRunnable(runnable, true);
    }

    public static void whenMatlabReady(Runnable runnable) {
        sDispatcher.postMatlabRunnable(runnable, false);
    }

    public static void mtEval(String string) throws Exception {
        Matlab.mtEval(string, 0);
    }

    public static Object mtEval(String string, int n) throws Exception {
        Object object = Matlab.mtFeval("eval", new Object[]{string}, n);
        if (object == null) {
            object = "";
        }
        return object;
    }

    public static Object mtFeval(String string, Object[] objectArray, int n) throws Exception {
        MWMessage mWMessage = new MWMessage(-6);
        mWMessage.put((Object)CMD_STR, (Object)0);
        mWMessage.put((Object)STRING_STR, (Object)string);
        mWMessage.put((Object)NLHS_STR, (Object)n);
        mWMessage.put((Object)FLAGS_STR, (Object)516);
        if (objectArray != null) {
            mWMessage.put((Object)ARGUMENTS_STR, (Object)objectArray);
        }
        Matlab.debugEcho(string, objectArray);
        return MatlabLooper.sendMatlabMessage(mWMessage);
    }

    public static Object mtFevalConsoleOutput(String string, Object[] objectArray, int n) throws Exception {
        MWMessage mWMessage = new MWMessage(-6);
        mWMessage.put((Object)CMD_STR, (Object)0);
        mWMessage.put((Object)STRING_STR, (Object)string);
        mWMessage.put((Object)NLHS_STR, (Object)n);
        if (objectArray != null) {
            mWMessage.put((Object)ARGUMENTS_STR, (Object)objectArray);
        }
        Matlab.debugEcho(string, objectArray);
        return MatlabLooper.sendMatlabMessage(mWMessage);
    }

    public static Object mtGet(double d, String[] stringArray) throws Exception {
        Object[] objectArray;
        MWMessage mWMessage = new MWMessage(-6);
        if (stringArray == null) {
            objectArray = new Object[1];
        } else {
            objectArray = new Object[2];
            objectArray[1] = stringArray;
        }
        objectArray[0] = d;
        mWMessage.put((Object)CMD_STR, (Object)1);
        mWMessage.put((Object)STRING_STR, (Object)"get");
        mWMessage.put((Object)ARGUMENTS_STR, (Object)objectArray);
        mWMessage.put((Object)NLHS_STR, (Object)1);
        return MatlabLooper.sendMatlabMessage(mWMessage);
    }

    public static Object mtGet(double d, String string) throws Exception {
        String[] stringArray = string != null ? new String[]{string} : null;
        return Matlab.mtGet(d, stringArray);
    }

    public static void mtSet(double d, String[] stringArray, Object[] objectArray) throws Exception {
        Object[] objectArray2 = new Object[]{d, stringArray, objectArray};
        Matlab.mtFeval("set", objectArray2, 0);
    }

    public static void mtSet(double d, String string, Object object) throws Exception {
        String[] stringArray = new String[1];
        Object[] objectArray = new Object[1];
        stringArray[0] = string;
        objectArray[0] = object;
        Matlab.mtSet(d, stringArray, objectArray);
    }

    public static Object mtSendLicenseCheck(Object[] objectArray) throws Exception {
        MWMessage mWMessage = new MWMessage(-6);
        mWMessage.put((Object)CMD_STR, (Object)6);
        mWMessage.put((Object)ARGUMENTS_STR, (Object)objectArray);
        return MatlabLooper.sendMatlabMessage(mWMessage);
    }

    public static boolean useJava(String string) {
        boolean bl = true;
        if (Matlab.isMatlabAvailable()) {
            MWMessage mWMessage = new MWMessage(-19);
            mWMessage.put((Object)STRING_STR, (Object)string);
            sDispatcher.postMatlabMessage(mWMessage, null);
            bl = (Boolean)mWMessage.get((Object)RESULT_STR);
        }
        return bl;
    }

    public static String[] mtFindAllTabCompletions(String string) throws Exception {
        MWMessage mWMessage = new MWMessage(-6);
        mWMessage.put((Object)CMD_STR, (Object)8);
        mWMessage.put((Object)STRING_STR, (Object)string);
        return (String[])MatlabLooper.sendMatlabMessage(mWMessage);
    }

    public static String mtFormTabCompletion(int n) throws Exception {
        MWMessage mWMessage = new MWMessage(-6);
        mWMessage.put((Object)CMD_STR, (Object)5);
        mWMessage.put((Object)STATUS_STR, (Object)n);
        return (String)MatlabLooper.sendMatlabMessage(mWMessage);
    }

    static void debugEcho(String string) {
        if (sEchoEval && string != null && !string.equals("") && !string.equals("\n")) {
            boolean bl = Log.isLogging();
            Log.setLogging((boolean)true);
            Log.printLn((String)("eval: " + string));
            Log.setLogging((boolean)bl);
        }
    }

    static void debugEcho(MWMessage mWMessage) {
        if (sEchoEval && mWMessage != null) {
            String string;
            boolean bl = Log.isLogging();
            Log.setLogging((boolean)true);
            if (!(mWMessage.getType() != -1 && mWMessage.getType() != -3 || (string = (String)mWMessage.get((Object)STRING_STR)) == null || string.equals("") || string.equals("\n"))) {
                if (mWMessage.getType() == -1) {
                    Log.printLn((String)("eval: " + string));
                } else {
                    Log.printLn((String)("feval: " + string));
                }
            }
            Log.setLogging((boolean)bl);
        }
    }

    static void debugEcho(String string, Object[] objectArray) {
        if (sEchoEval) {
            int n;
            boolean bl = Log.isLogging();
            Log.setLogging((boolean)true);
            Log.log((String)("mtFeval: " + string));
            int n2 = n = objectArray == null ? 0 : objectArray.length;
            if (n > 0) {
                Log.log((String)"(");
                for (int i = 0; i < n; ++i) {
                    assert (objectArray != null);
                    Log.log((String)objectArray[i].toString());
                    if (i >= n - 1) continue;
                    Log.log((String)", ");
                }
                Log.log((String)")");
            }
            Log.printLn((String)"");
            Log.setLogging((boolean)bl);
        }
    }

    static {
        sMatlabRoot = "";
        sRuntimeVariant = 1;
        sNameLengthMax = 63;
        sEchoEval = false;
        sKeepAliveMsg = null;
        sKeepAliveTimer = null;
        sItsAlive = false;
        sDispatcher = new MatlabLooper();
    }

    private static class InvokeAndWait
    extends FactoryUtilAdapter {
        private InvokeAndWait() {
        }

        public void callVoidMethod(Object object) {
            try {
                AWTUtilities.invokeAndWait((Runnable)object);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static class IsMatlabThread
    extends FactoryUtilAdapter {
        private IsMatlabThread() {
        }

        public boolean callBooleanMethod(Object object) {
            return NativeMatlab.nativeIsMatlabThread();
        }
    }

    private static class MatlabNotify
    extends FactoryUtilAdapter {
        private MatlabNotify() {
        }

        public void callVoidMethod(Object object) {
            NativeMatlab.matlabNotify();
        }
    }

    private static class MatlabWait
    extends FactoryUtilAdapter {
        private String msg;

        private MatlabWait() {
        }

        public Object getValue() {
            return this.msg;
        }

        public boolean callBooleanMethod(Object object) {
            boolean bl;
            this.msg = null;
            try {
                bl = NativeMatlab.matlabWait();
            }
            catch (MatlabThreadException matlabThreadException) {
                this.msg = matlabThreadException.getMessage();
                bl = false;
            }
            return bl;
        }
    }

    private static class ProcessExposeEvents
    extends FactoryUtilAdapter {
        private ProcessExposeEvents() {
        }

        public boolean callBooleanMethod(Object object) {
            return NativeMatlab.processExposeEvents();
        }
    }

    private static class ProcessPendingEvents
    extends FactoryUtilAdapter {
        private ProcessPendingEvents() {
        }

        public boolean callBooleanMethod(Object object) {
            return NativeMatlab.processPendingEvents();
        }
    }

    private static class DisableMatlabWindows
    extends FactoryUtilAdapter
    implements Runnable {
        private DisableMatlabWindows() {
        }

        public void callVoidMethod(Object object) {
            if (!NativeJava.nativeLibraryExists() || PlatformInfo.getPlatform() != 1 || PlatformInfo.getVendor() != 3) {
                Matlab.whenMatlabReady(this);
            }
        }

        public void run() {
            NativeMatlab.disableMatlabWindows();
        }
    }

    private static class RestoreMatlabWindows
    extends FactoryUtilAdapter
    implements Runnable {
        private RestoreMatlabWindows() {
        }

        public void callVoidMethod(Object object) {
            if (!NativeJava.nativeLibraryExists() || PlatformInfo.getPlatform() != 1 || PlatformInfo.getVendor() != 3) {
                Matlab.whenMatlabReady(this);
            }
        }

        public void run() {
            NativeMatlab.restoreMatlabWindows();
        }
    }

    private static class MatlabQuitListener
    implements MatlabListener {
        private MatlabQuitListener() {
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (matlabEvent.getEventType() == 1) {
                Prefs.save();
            }
        }
    }

    private static class MatlabDirSeed
    extends FactoryUtilAdapter {
        private MatlabDirSeed() {
        }

        public Object getValue() {
            File file = MatlabPath.getCurrentDirectory();
            return file == null ? null : file.getAbsolutePath();
        }
    }
}

