/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.services.Prefs;
import com.mathworks.services.message.MWMessage;
import com.mathworks.util.ArrayUtils;
import com.mathworks.util.FileUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.QueueEvent;
import com.mathworks.util.StringUtils;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.SuffixFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatlabPath {
    public static final String PATH_EVENT = "PATH_CHANGE";
    public static final String CWD_EVENT = "CWD_CHANGE";
    private static final int SAVE_PATH_REPLY = 200;
    private static final int NEW_PATH_REPLY = 201;
    private static final int NEW_CWD_REPLY = 202;
    private static final int CWD_REGISTER = 203;
    private static final int PATH_REGISTER = 204;
    private static final int UNKNOWN_GROUP = 0;
    private static final int MATLAB_GROUP = 1;
    private static final int SIMULINK_GROUP = 2;
    private static final int STATEFLOW_GROUP = 3;
    private static final int RTW_GROUP = 4;
    private static final String MATLAB = "matlab";
    private static final String SIMULINK = "simulink";
    private static final String STATEFLOW = "stateflow";
    private static final String RTW = "rtw";
    private static final String PACKAGE_PREFIX = "+";
    private static final String OBJECT_PREFIX = "@";
    private static final String QUALIFYING_SEPARATOR = ".";
    private static final String PRIVATE_DIRECTORY = "private";
    private static final String MATLABROOT = Matlab.matlabRoot();
    private static final File sToolboxDir = new File(MATLABROOT, "toolbox");
    private static final File sPathDir = new File(new File(sToolboxDir, "local"), "path");
    private static final Matlab sMatlab = new Matlab();
    private static File sCwdPath = null;
    private static List<File> sPath = Collections.unmodifiableList(new ArrayList());
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.jmi.resources.RES_JMI");
    private static ActionListener sListener;
    private static final CwdChangeWhenAtPrompt sCwdChangeWhenAtPrompt;
    private static final boolean sDeferCDUpdateUntilPrompt;

    private MatlabPath() {
    }

    public static void addActionListener(ActionListener actionListener) {
        sListener = AWTEventMulticaster.add(sListener, actionListener);
        if (sCwdPath != null) {
            MatlabPath.fireActionListener(actionListener, CWD_EVENT);
            MatlabPath.fireActionListener(actionListener, PATH_EVENT);
        }
    }

    public static void removeActionListener(ActionListener actionListener) {
        sListener = AWTEventMulticaster.remove(sListener, actionListener);
    }

    private static void fireActionListener(ActionListener actionListener, String string) {
        if (actionListener != null) {
            QueueEvent.postQueueEvent((QueueEvent)new DeferredActionEvent(actionListener, string));
        }
    }

    public static synchronized void setInitialPath(String string) {
        if (sPath.isEmpty()) {
            MatlabPath.updatePathArray(MatlabPath.stripTrailingNewLines(string));
            if (sListener != null) {
                MatlabPath.fireActionListener(sListener, PATH_EVENT);
            }
        }
    }

    @Deprecated
    public static String getCWD() {
        if (sCwdPath != null) {
            return sCwdPath.getAbsolutePath();
        }
        return "";
    }

    public static File getCurrentDirectory() {
        return sCwdPath;
    }

    public static void setCWD(String string) {
        MatlabPath.setCWD(string, null);
    }

    public static void setCurrentDirectory(File file) {
        MatlabPath.setCurrentDirectory(file, null);
    }

    public static void setCurrentDirectory(File file, CompletionObserver completionObserver) {
        MatlabPath.setCWD(file.getAbsolutePath(), completionObserver);
    }

    public static void setCWD(String string, CompletionObserver completionObserver) {
        if (Matlab.isMatlabAvailable() && string != null) {
            String string2 = "builtin('cd','" + StringUtils.quoteSingleQuotes((String)string) + "');";
            if (completionObserver != null) {
                sMatlab.eval(string2, completionObserver);
            } else {
                sMatlab.evalConsoleOutput(string2);
            }
        }
    }

    @Deprecated
    public static synchronized String[] getPath() {
        return MatlabPath.getStringArrayFromFileList(sPath);
    }

    public static synchronized List<File> getPathFiles() {
        return Collections.unmodifiableList(sPath);
    }

    @Deprecated
    public static String[] getSearchPath() {
        LinkedList<File> linkedList = new LinkedList<File>(MatlabPath.getPathFiles());
        String[] stringArray = new String[linkedList.size() + 1];
        System.arraycopy(MatlabPath.getStringArrayFromFileList(linkedList), 0, stringArray, 1, linkedList.size());
        stringArray[0] = MatlabPath.getCWD();
        return stringArray;
    }

    public static List<File> getSearchPathFiles() {
        LinkedList<File> linkedList = new LinkedList<File>(MatlabPath.getPathFiles());
        linkedList.add(0, sCwdPath);
        return Collections.unmodifiableList(linkedList);
    }

    @Deprecated
    public static void setPath(String[] stringArray, CompletionObserver completionObserver) {
        MatlabPath.setPath(MatlabPath.getFileListFromstringArray(stringArray), completionObserver);
    }

    public static void setPath(List<File> list, CompletionObserver completionObserver) {
        if (list != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (File file : list) {
                stringBuilder.append(file.getAbsolutePath()).append(File.pathSeparator);
            }
            MatlabPath.setPath(stringBuilder.toString(), completionObserver);
        }
    }

    public static void setPath(String string, CompletionObserver completionObserver) {
        MatlabPath.setPathNoQuotification("'" + StringUtils.quoteSingleQuotes((String)string) + "'", completionObserver);
    }

    private static void setPathNoQuotification(String string, CompletionObserver completionObserver) {
        String string2 = "builtin('matlabpath'," + string + ");";
        sMatlab.eval(string2, completionObserver);
    }

    @Deprecated
    public static void prepend(String string, CompletionObserver completionObserver) {
        MatlabPath.prepend(new File(string), completionObserver);
    }

    public static void prepend(File file, CompletionObserver completionObserver) {
        MatlabPath.prepend(MatlabPath.getFileListFromFile(file), completionObserver);
    }

    @Deprecated
    public static void prepend(String[] stringArray, CompletionObserver completionObserver) {
        MatlabPath.prepend(MatlabPath.getFileListFromstringArray(stringArray), completionObserver);
    }

    public static void prepend(List<File> list, CompletionObserver completionObserver) {
        String string;
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        for (File object2 : list) {
            string = StringUtils.quoteSingleQuotes((String)object2.getAbsolutePath());
            stringBuffer = stringBuffer.append('\'').append(string).append("', ");
            stringBuffer2 = stringBuffer2.append('\'').append(string).append(File.pathSeparator).append("', ");
        }
        String string2 = "addpath(" + stringBuffer + "'-begin'" + ");";
        String string3 = "matlabpath([" + stringBuffer2 + "matlabpath]);";
        string = "try, " + (String)string2 + "catch, " + string3 + "end;";
        if (completionObserver != null) {
            sMatlab.eval(string, completionObserver);
        } else {
            sMatlab.evalNoOutput(string);
        }
    }

    @Deprecated
    public static void prependRecursively(String string, CompletionObserver completionObserver) {
        MatlabPath.prependRecursively(new File(string), completionObserver);
    }

    public static void prependRecursively(File file, CompletionObserver completionObserver) {
        MatlabPath.prependRecursively(MatlabPath.getFileListFromFile(file), completionObserver);
    }

    @Deprecated
    public static void prependRecursively(String[] stringArray, CompletionObserver completionObserver) {
        MatlabPath.prependRecursively(MatlabPath.getFileListFromstringArray(stringArray), completionObserver);
    }

    public static void prependRecursively(List<File> list, CompletionObserver completionObserver) {
        StringBuffer stringBuffer = new StringBuffer("addpath(genpath(");
        for (File file : list) {
            stringBuffer = stringBuffer.append('\'').append(StringUtils.quoteSingleQuotes((String)file.getAbsolutePath())).append("'), ");
        }
        stringBuffer = stringBuffer.append("'-begin'").append(");");
        if (completionObserver != null) {
            sMatlab.eval(stringBuffer.toString(), completionObserver);
        } else {
            sMatlab.evalNoOutput(stringBuffer.toString());
        }
    }

    @Deprecated
    public static void append(String string, CompletionObserver completionObserver) {
        MatlabPath.append(new File(string), completionObserver);
    }

    public static void append(File file, CompletionObserver completionObserver) {
        MatlabPath.append(MatlabPath.getFileListFromFile(file), completionObserver);
    }

    @Deprecated
    public static void append(String[] stringArray, CompletionObserver completionObserver) {
        MatlabPath.append(MatlabPath.getFileListFromstringArray(stringArray), completionObserver);
    }

    public static void append(List<File> list, CompletionObserver completionObserver) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (File object2 : list) {
            string = StringUtils.quoteSingleQuotes((String)object2.getAbsolutePath());
            stringBuffer = stringBuffer.append('\'').append(string).append("', ");
            stringBuffer2 = stringBuffer2.append('\'').append(string).append("' ");
        }
        String string2 = "addpath(" + stringBuffer + "'-end'" + ");";
        String string3 = "matlabpath([matlabpath '" + File.pathSeparator + "' " + stringBuffer2 + "'']);";
        string = "try, " + (String)string2 + "catch, " + string3 + "end;";
        if (completionObserver != null) {
            sMatlab.eval(string, completionObserver);
        } else {
            sMatlab.evalNoOutput(string);
        }
    }

    @Deprecated
    public static void appendRecursively(String string, CompletionObserver completionObserver) {
        File file = new File(string);
        MatlabPath.appendRecursively(file, completionObserver);
    }

    public static void appendRecursively(File file, CompletionObserver completionObserver) {
        MatlabPath.appendRecursively(MatlabPath.getFileListFromFile(file), completionObserver);
    }

    @Deprecated
    public static void appendRecursively(String[] stringArray, CompletionObserver completionObserver) {
        MatlabPath.appendRecursively(MatlabPath.getFileListFromstringArray(stringArray), completionObserver);
    }

    public static void appendRecursively(List<File> list, CompletionObserver completionObserver) {
        StringBuffer stringBuffer = new StringBuffer("addpath(genpath(");
        for (File file : list) {
            stringBuffer = stringBuffer.append('\'').append(StringUtils.quoteSingleQuotes((String)file.getAbsolutePath())).append("'), ");
        }
        stringBuffer = stringBuffer.append("'-end'").append(");");
        if (completionObserver != null) {
            sMatlab.eval(stringBuffer.toString(), completionObserver);
        } else {
            sMatlab.evalNoOutput(stringBuffer.toString());
        }
    }

    @Deprecated
    public static void remove(String string, CompletionObserver completionObserver) {
        File file = new File(string);
        MatlabPath.remove(file, completionObserver);
    }

    public static void remove(File file, CompletionObserver completionObserver) {
        MatlabPath.remove(MatlabPath.getFileListFromFile(file), completionObserver);
    }

    @Deprecated
    public static void remove(String[] stringArray, CompletionObserver completionObserver) {
        MatlabPath.remove(MatlabPath.getFileListFromstringArray(stringArray), completionObserver);
    }

    public static void remove(List<File> list, CompletionObserver completionObserver) {
        StringBuffer stringBuffer = new StringBuffer("rmpath(");
        for (int i = 0; i < list.size() - 1; ++i) {
            stringBuffer = stringBuffer.append('\'').append(StringUtils.quoteSingleQuotes((String)list.get(i).getAbsolutePath())).append("', ");
        }
        stringBuffer = stringBuffer.append('\'').append(StringUtils.quoteSingleQuotes((String)list.get(list.size() - 1).getAbsolutePath())).append('\'').append(");");
        if (completionObserver != null) {
            sMatlab.eval(stringBuffer.toString(), completionObserver);
        } else {
            sMatlab.evalNoOutput(stringBuffer.toString());
        }
    }

    private static synchronized void updatePathArray(String string) {
        Vector<File> vector = new Vector<File>(32);
        int n = 0;
        String string2 = 'X' + string;
        while (n != -1) {
            int n2 = string2.indexOf(File.pathSeparator, n + 1);
            if (n2 != -1) {
                vector.add(new File(string2.substring(n + 1, n2)));
            } else {
                vector.add(new File(string2.substring(n + 1)));
            }
            n = n2;
        }
        sPath = Collections.unmodifiableList(vector);
    }

    @Deprecated
    public static boolean isValidPathEntry(String string) {
        return string != null && !MatlabPath.isObject(string) && !MatlabPath.isPrivate(string) && !MatlabPath.isPackage(string);
    }

    public static boolean isValidPathEntry(File file) {
        return !MatlabPath.isObject(file) && !MatlabPath.isPrivate(file) && !MatlabPath.isPackage(file);
    }

    @Deprecated
    public static String getValidPathEntryParent(String string) {
        return MatlabPath.getValidPathEntryParent(new File(string)).getAbsolutePath();
    }

    public static File getValidPathEntryParent(File file) {
        File file2;
        for (file2 = file; file2 != null && !MatlabPath.isValidPathEntry(file2); file2 = file2.getParentFile()) {
        }
        return file2;
    }

    @Deprecated
    public static void showInvalidPathEntryDialog(Component component, String string) {
        MJOptionPane.showMessageDialog((Component)component, (Object)sRes.getString("path.invalidentry.message"), (String)string, (int)0);
    }

    @Deprecated
    public static boolean isObject(String string) {
        return string != null && FileUtils.toJavaPath((String)string).contains(File.separator + OBJECT_PREFIX);
    }

    public static boolean isObject(File file) {
        return FileUtils.toJavaPath((String)file.getAbsolutePath()).contains(File.separator + OBJECT_PREFIX);
    }

    @Deprecated
    public static boolean isPrivate(String string) {
        String string2 = FileUtils.toJavaPath((String)string);
        return string2 != null && (string2.endsWith(File.separator + PRIVATE_DIRECTORY + File.separator) || string2.endsWith(File.separator + PRIVATE_DIRECTORY));
    }

    public static boolean isPrivate(File file) {
        String string = FileUtils.toJavaPath((String)file.getAbsolutePath());
        return string != null && (string.endsWith(File.separator + PRIVATE_DIRECTORY + File.separator) || string.endsWith(File.separator + PRIVATE_DIRECTORY));
    }

    @Deprecated
    public static boolean isPackage(String string) {
        if (string == null) {
            return false;
        }
        String string2 = new File(FileUtils.toJavaPath((String)string)).getName();
        String string3 = FilenameUtils.getBaseName((String)new File(string).getParent());
        return string2 != null && (string2.startsWith(PACKAGE_PREFIX) || string3 != null && string3.startsWith(PACKAGE_PREFIX) && string2.startsWith(OBJECT_PREFIX));
    }

    public static boolean isPackage(File file) {
        String string = new File(FileUtils.toJavaPath((String)file.getAbsolutePath())).getName();
        String string2 = FilenameUtils.getBaseName((String)new File(file.getAbsolutePath()).getParent());
        return string != null && (string.startsWith(PACKAGE_PREFIX) || string2 != null && string2.startsWith(PACKAGE_PREFIX) && string.startsWith(OBJECT_PREFIX));
    }

    @Deprecated
    public static String trimToMcosPath(String string) {
        if (string == null) {
            return null;
        }
        if (!MatlabPath.isPackage(FilenameUtils.getFullPath((String)string)) && !MatlabPath.isObject(string)) {
            return FilenameUtils.getName((String)string);
        }
        int n = string.indexOf(File.separator + PACKAGE_PREFIX);
        if (n == -1) {
            n = string.indexOf(File.separator + OBJECT_PREFIX);
        }
        assert (n != -1) : "Didn't find package directory or object despite checking earlier";
        return string.substring(n + 1);
    }

    public static File trimToMcosPath(File file) {
        if (!MatlabPath.isPackage(new File(FilenameUtils.getFullPath((String)file.getAbsolutePath()))) && !MatlabPath.isObject(file)) {
            return new File(FilenameUtils.getName((String)file.getAbsolutePath()));
        }
        int n = file.getAbsolutePath().indexOf(File.separator + PACKAGE_PREFIX);
        if (n == -1) {
            n = file.getAbsolutePath().indexOf(File.separator + OBJECT_PREFIX);
        }
        assert (n != -1) : "Didn't find package directory or object despite checking earlier";
        return new File(file.getAbsolutePath().substring(n + 1));
    }

    public static String getQualifiedFunctionOrMethodName(File file) {
        String string = FilenameUtils.removeExtension((String)MatlabPath.trimToMcosPath(file).getPath());
        string = string.replaceAll("\\Q" + File.separator + "\\E", QUALIFYING_SEPARATOR);
        string = string.replaceAll("@(.*?)\\.(?=\\1)", "");
        string = string.replaceAll(OBJECT_PREFIX, "");
        return string.replaceAll("\\Q+\\E", "");
    }

    public static void restoreDefaultPath(CompletionObserver completionObserver) {
        MatlabPath.restoreDefaultPath(true, completionObserver);
    }

    private static void restoreDefaultPath(boolean bl, CompletionObserver completionObserver) {
        String string = bl ? "userpath " : "";
        RDPCO rDPCO = new RDPCO(bl, completionObserver);
        MatlabPath.setPathNoQuotification("[" + string + MatlabPath.getDefaultPathStringNoUserpath() + "]", rDPCO);
    }

    private static String getDefaultPathStringNoUserpath() {
        String string = null;
        StringBuffer stringBuffer = MatlabPath.getPhlBasedPath();
        if (stringBuffer != null) {
            stringBuffer = MatlabPath.removeDups(stringBuffer);
            string = stringBuffer.toString();
        }
        return "'" + StringUtils.quoteSingleQuotes((String)string) + "'";
    }

    private static StringBuffer getPhlBasedPath() {
        if (!Matlab.isMatlabAvailable()) {
            return null;
        }
        Vector<File> vector = new Vector<File>(25);
        Vector<File> vector2 = new Vector<File>(10);
        Vector<File> vector3 = new Vector<File>(10);
        Vector<File> vector4 = new Vector<File>(10);
        Vector<File> vector5 = new Vector<File>(10);
        if (sPathDir.exists()) {
            MatlabPath.fillPhlFileLists(sPathDir, 0, vector, vector2, vector3, vector4, vector5);
        } else {
            MatlabPath.fillDeepPhlFileLists(sToolboxDir, 0, vector, vector2, vector3, vector4, vector5);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (File file : vector) {
            stringBuffer.append(MatlabPath.readPhlFile(file));
        }
        for (File file : vector2) {
            stringBuffer.append(MatlabPath.readPhlFile(file));
        }
        for (File file : vector3) {
            stringBuffer.append(MatlabPath.readPhlFile(file));
        }
        for (File file : vector4) {
            stringBuffer.append(MatlabPath.readPhlFile(file));
        }
        for (File file : vector5) {
            stringBuffer.append(MatlabPath.readPhlFile(file));
        }
        return stringBuffer;
    }

    private static void fillDeepPhlFileLists(File file, int n, List<File> list, List<File> list2, List<File> list3, List<File> list4, List<File> list5) {
        String[] stringArray;
        for (String string : stringArray = file.list()) {
            int n2 = MatlabPath.getNewGroup(n, string);
            File file2 = new File(file, string);
            if (!file2.isDirectory()) continue;
            MatlabPath.fillPhlFileLists(file2, n2, list, list2, list3, list4, list5);
            if (!MatlabPath.isDeepPHLDirectoryEnding(string)) continue;
            MatlabPath.fillDeepPhlFileLists(file2, n2, list, list2, list3, list4, list5);
        }
    }

    private static boolean isDeepPHLDirectoryEnding(String string) {
        return string.equals("physmod") || string.equals(SIMULINK) || string.equals("symbolic") || string.equals("slvnv") || string.equals("distcomp") || string.equals(RTW) || string.equals("targets");
    }

    private static int getNewGroup(int n, String string) {
        if (n == 0) {
            if (string.equals(MATLAB)) {
                return 1;
            }
            if (string.equals(SIMULINK)) {
                return 2;
            }
            if (string.equals(STATEFLOW)) {
                return 3;
            }
            if (string.equals(RTW)) {
                return 4;
            }
            return 0;
        }
        return n;
    }

    private static void fillPhlFileLists(File file, int n, List<File> list, List<File> list2, List<File> list3, List<File> list4, List<File> list5) {
        String[] stringArray;
        for (String string : stringArray = file.list((FilenameFilter)new SuffixFileFilter(".phl"))) {
            File file2 = new File(file, string);
            if (string.startsWith(MATLAB) || n == 1) {
                list.add(file2);
                continue;
            }
            if (string.startsWith(SIMULINK) || n == 2) {
                list2.add(file2);
                continue;
            }
            if (string.startsWith(STATEFLOW) || n == 3) {
                list3.add(file2);
                continue;
            }
            if (string.startsWith(RTW) || n == 4) {
                list4.add(file2);
                continue;
            }
            list5.add(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readPhlFile(File file) {
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                File file2;
                string = string.trim();
                if (PlatformInfo.isWindows()) {
                    string = string.replace('/', '\\');
                }
                if (!(file2 = new File(MATLABROOT, string)).isDirectory() || string.length() == 0) continue;
                stringBuilder.append(file2.getAbsolutePath()).append('\n');
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return stringBuilder.toString();
    }

    private static StringBuffer removeDups(StringBuffer stringBuffer) {
        int n;
        StringBuffer stringBuffer2 = new StringBuffer();
        String string = stringBuffer.toString();
        int n2 = 0;
        int n3 = 1;
        while (n2 != -1) {
            n2 = string.indexOf(10, n2 + 1);
            ++n3;
        }
        String[] stringArray = new String[n3];
        int n4 = string.indexOf(10, 0);
        int n5 = 0;
        int n6 = 0;
        while (n4 != -1) {
            stringArray[n6] = string.substring(n5, n4);
            ++n6;
            n5 = n4 + 1;
            n4 = string.indexOf(10, n5);
        }
        --n6;
        for (int i = 0; i <= n6; ++i) {
            if (stringArray[i] == null) continue;
            for (n = i + 1; n <= n6; ++n) {
                if (!stringArray[i].equalsIgnoreCase(stringArray[n])) continue;
                stringArray[n] = null;
            }
        }
        for (n = 0; n <= n6; ++n) {
            if (stringArray[n] == null) continue;
            stringBuffer2.append(stringArray[n]).append(File.pathSeparator);
        }
        return stringBuffer2;
    }

    @Deprecated
    public static void saveAs(String string) {
        MatlabPath.saveAs(new File(string));
    }

    public static void saveAs(File file) {
        Object[] objectArray = file != null ? new Object[]{file.getAbsolutePath()} : ArrayUtils.EmptyObjects.OBJECT;
        sMatlab.feval("path2rc", objectArray, new PathCallback(200));
    }

    public static void loadPath(File file, CompletionObserver completionObserver) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath() + " does not exist.");
        }
        String string = file.getParent();
        String string2 = file.getName();
        String string3 = string2.substring(0, string2.indexOf(46));
        File file2 = MatlabPath.getCurrentDirectory();
        String string4 = file2.getAbsolutePath();
        sMatlab.evalConsoleOutput("try, builtin('cd','" + StringUtils.quoteSingleQuotes((String)string) + "'), " + "path(" + string3 + "), builtin('cd','" + StringUtils.quoteSingleQuotes((String)string4) + "'); catch," + "builtin('cd','" + StringUtils.quoteSingleQuotes((String)string4) + "'); rethrow(lasterror), end", completionObserver);
    }

    public static void callFSChange(File file) {
        String string = file.getAbsolutePath();
        sMatlab.evalNoOutput("fschange('" + StringUtils.quoteSingleQuotes((String)string) + "');");
    }

    public static void callRehashToolboxIfToolboxFile(File file) {
        if (IOCase.SYSTEM.checkStartsWith(file.getAbsolutePath(), sToolboxDir.getAbsolutePath())) {
            sMatlab.evalNoOutput("rehash('toolbox');");
        }
    }

    @Deprecated
    public static void clearFunctionFullPath(String string) {
        MatlabPath.clearFunction(new File(string));
    }

    public static void clearFunction(File file) {
        sMatlab.evalNoOutput("clear('" + StringUtils.quoteSingleQuotes((String)file.getAbsolutePath()) + "');");
    }

    @Deprecated
    public static void dbclearFunctionFullPath(String string) {
        MatlabPath.dbclearFunction(new File(string));
    }

    public static void dbclearFunction(File file) {
        sMatlab.evalNoOutput("try dbclear('-completenames', '" + StringUtils.quoteSingleQuotes((String)file.getAbsolutePath()) + "'); catch exception, end");
    }

    private static String stripTrailingNewLines(String string) {
        int n = string.indexOf(10);
        if (string.indexOf(13) > n) {
            n = string.indexOf(13);
        }
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    private static List<File> getFileListFromstringArray(String[] stringArray) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : stringArray) {
            arrayList.add(new File(string));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static String[] getStringArrayFromFileList(List<File> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            File file = list.get(i);
            stringArray[i] = file != null ? file.getAbsolutePath() : "";
        }
        return stringArray;
    }

    private static List<File> getFileListFromFile(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(file);
        return Collections.unmodifiableList(arrayList);
    }

    static {
        sCwdChangeWhenAtPrompt = new CwdChangeWhenAtPrompt();
        sDeferCDUpdateUntilPrompt = Prefs.getBooleanPref((String)"DeferCDUpdateUntilPrompt", (boolean)true);
        if (Matlab.isMatlabAvailable()) {
            sMatlab.registerInterest(2, 0x40000000, new PathCallback(203));
            sMatlab.registerInterest(2, Integer.MIN_VALUE, new PathCallback(204));
        }
    }

    private static class PathCallback
    implements CompletionObserver {
        private int fReplyType;

        PathCallback(int n) {
            this.fReplyType = n;
        }

        public void completed(int n, Object object) {
            if (this.fReplyType != 200) {
                if (this.fReplyType == 202) {
                    if (Matlab.getExecutionStatus(n) == 0 && object != null) {
                        sCwdPath = new File(MatlabPath.stripTrailingNewLines((String)object));
                    }
                    sCwdChangeWhenAtPrompt.trigger(sCwdPath);
                } else if (this.fReplyType == 201) {
                    if (Matlab.getExecutionStatus(n) == 0 && object != null) {
                        MatlabPath.updatePathArray(MatlabPath.stripTrailingNewLines((String)object));
                    }
                    MatlabPath.fireActionListener(sListener, MatlabPath.PATH_EVENT);
                } else {
                    MWMessage mWMessage = (MWMessage)object;
                    Integer n2 = (Integer)mWMessage.get((Object)"eventid");
                    if (this.fReplyType == 203) {
                        if (n2 == -8) {
                            sMatlab.eval("disp(cd)", new PathCallback(202));
                        } else if (n2 == 0x40000000) {
                            File file = new File((String)mWMessage.get((Object)"string"));
                            sCwdChangeWhenAtPrompt.trigger(file);
                        }
                    } else if (this.fReplyType == 204) {
                        if (n2 == -8) {
                            sMatlab.eval("disp(matlabpath)", new PathCallback(201));
                        } else if (n2 == Integer.MIN_VALUE) {
                            MatlabPath.updatePathArray((String)mWMessage.get((Object)"string"));
                            MatlabPath.fireActionListener(sListener, MatlabPath.PATH_EVENT);
                        }
                    }
                }
            }
        }
    }

    private static class RDPCO
    implements CompletionObserver {
        private CompletionObserver iOriginalCO;
        private boolean iUserpathPrepended;

        RDPCO(boolean bl, CompletionObserver completionObserver) {
            this.iUserpathPrepended = bl;
            this.iOriginalCO = completionObserver;
        }

        public void completed(int n, Object object) {
            if (Matlab.getExecutionStatus(n) != 0 && this.iUserpathPrepended) {
                MatlabPath.restoreDefaultPath(false, new RDPCO(false, this.iOriginalCO));
                return;
            }
            if (this.iOriginalCO != null) {
                this.iOriginalCO.completed(n, object);
            }
        }
    }

    private static class DeferredActionEvent
    extends QueueEvent {
        private ActionListener fListener;
        private String fCommand;

        DeferredActionEvent(ActionListener actionListener, String string) {
            this.fListener = actionListener;
            this.fCommand = string;
        }

        public void dispatch() {
            this.fListener.actionPerformed(new ActionEvent(sMatlab, 1001, this.fCommand));
        }
    }

    private static class CwdChangeWhenAtPrompt {
        private File iNewCwd;
        private final Object iLock = new Object();

        private CwdChangeWhenAtPrompt() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void trigger(File file) {
            if (sDeferCDUpdateUntilPrompt) {
                Object object = this.iLock;
                synchronized (object) {
                    boolean bl = this.iNewCwd != null;
                    this.iNewCwd = file;
                    if (!bl) {
                        Matlab.whenAtPrompt(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                Object object = CwdChangeWhenAtPrompt.this.iLock;
                                synchronized (object) {
                                    sCwdPath = CwdChangeWhenAtPrompt.this.iNewCwd;
                                    CwdChangeWhenAtPrompt.this.iNewCwd = null;
                                }
                                MatlabPath.fireActionListener(sListener, MatlabPath.CWD_EVENT);
                            }
                        });
                    }
                }
            } else {
                sCwdPath = file;
                MatlabPath.fireActionListener(sListener, MatlabPath.CWD_EVENT);
            }
        }
    }
}

