/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi;

import com.mathworks.jmi.Support;
import com.mathworks.util.Timer;
import java.awt.Button;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class RemoteLogClient
implements Runnable,
ActionListener {
    private static final String DEFAULT_HOST = "madmax.mathworks.com";
    private static final String DEFAULT_HOST_IP = "144.212.95.21";
    private static String sUserInfo = null;
    private static String sMachineDetails = null;
    private static RemoteLogClient sThis = null;
    private static final int AWT_PING_SEC = 10;
    private static final int AWT_TOLERANCE = 1;
    private static final String sAliveString = "OK";
    private static final String LONGEST_STRING = "LOGGING_DISABLED";
    private static final int NORMALIZED_LENGTH = "LOGGING_DISABLED".length();
    private static InetAddress sServerAddress;
    private static DatagramSocket sds;
    private static int sPort;
    private static long sAWTTime;
    private static int sAliveCounter;
    private static boolean sDesktopNotificationPending;
    public static final int DEFAULT_PORT = 2122;
    public static final String TIME_TOKEN = "_TIME_";

    private RemoteLogClient(String string, int n) {
        this.prepareClient(string, n);
    }

    public static void startClient() {
        RemoteLogClient.startClient(DEFAULT_HOST);
    }

    public static void startClient(String string) {
        RemoteLogClient.startClient(string, 2122);
    }

    public static void startClient(String string, int n) {
        if (!RemoteLogClient.isCurrentlyEnabled() && Support.useAWT()) {
            String string2 = null;
            try {
                string2 = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (string2 != null) {
                sThis = new RemoteLogClient(string, n);
            }
        }
    }

    private static boolean isCurrentlyEnabled() {
        return sThis != null;
    }

    public static void desktopStarted() {
        if (RemoteLogClient.isCurrentlyEnabled()) {
            RemoteLogClient.sendDesktopStartMessage();
        } else {
            sDesktopNotificationPending = true;
        }
    }

    private static void sendDesktopStartMessage() {
        RemoteLogClient.sendMessage("DESKTOP_START");
        sDesktopNotificationPending = false;
    }

    private static void setHost(String string) {
        try {
            sServerAddress = InetAddress.getByName(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void prepareClient(String string, int n) {
        sPort = n;
        try {
            sServerAddress = InetAddress.getByName(DEFAULT_HOST_IP);
            sds = new DatagramSocket();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Thread thread = new Thread((Runnable)this, "MATLAB Listener Client");
        thread.setPriority(1);
        thread.start();
    }

    private static String getMachineDetails() {
        if (sMachineDetails == null) {
            sMachineDetails = "(" + System.getProperty("os.name") + " " + System.getProperty("os.version") + ", " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + ")";
        }
        return sMachineDetails;
    }

    private static String getUserInfo() {
        if (sUserInfo == null) {
            sUserInfo = "Unknown_user@unknown_machine";
            try {
                sUserInfo = System.getProperty("user.name") + "@" + InetAddress.getLocalHost().getHostName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return sUserInfo;
    }

    private static void sendStartupMessage(String string) {
        RemoteLogClient.dispatchMessage(RemoteLogClient.constructMessageString(string, RemoteLogClient.getMachineDetails()));
        if (sDesktopNotificationPending) {
            RemoteLogClient.sendDesktopStartMessage();
        }
    }

    public static void sendMessage(String string) {
        RemoteLogClient.sendMessage(string, null);
    }

    public static void sendMessage(String string, String string2) {
        RemoteLogClient.dispatchMessage(RemoteLogClient.constructMessageString(string, string2));
    }

    public static String constructMessageString(String string, String string2) {
        String string3 = RemoteLogClient.normalize(string) + ", " + RemoteLogClient.getUserInfo() + ", " + TIME_TOKEN;
        if (string2 != null) {
            string3 = string3 + ", " + string2;
        }
        return string3;
    }

    public static String constructMessageString(String string) {
        return RemoteLogClient.constructMessageString(string, null);
    }

    private static String normalize(String string) {
        int n = string.length();
        if (n < NORMALIZED_LENGTH) {
            StringBuffer stringBuffer = new StringBuffer(string);
            for (int i = 0; i < NORMALIZED_LENGTH - n; ++i) {
                stringBuffer.append(" ");
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static void dispatchMessage(String string) {
        if (RemoteLogClient.isCurrentlyEnabled()) {
            try {
                byte[] byArray = string.getBytes();
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, sServerAddress, sPort);
                sds.send(datagramPacket);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void disable() {
        RemoteLogClient.sendMessage(LONGEST_STRING);
        sThis = null;
    }

    public static void desktopExit() {
        RemoteLogClient.sendMessage("DESKTOP_EXIT");
        RemoteLogClient.disable();
    }

    public static void makeHangButton() {
        if (RemoteLogClient.isCurrentlyEnabled()) {
            Frame frame = new Frame("Hang AWT Thread");
            Button button = new Button("Stall");
            button.addActionListener(sThis);
            frame.add("Center", button);
            frame.setLocation(100, 100);
            frame.setSize(300, 100);
            frame.setVisible(true);
        }
    }

    public void run() {
        RemoteLogClient.sendStartupMessage("LOGGING_ENABLED");
        Timer timer = new Timer(10000, (ActionListener)this, 1, 10, "Remote Log Client");
        sAWTTime = System.currentTimeMillis();
        timer.start();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("Stall".equals(actionEvent.getActionCommand())) {
            sThis.pause(100000);
        } else {
            long l = System.currentTimeMillis() - sAWTTime;
            if (l > 11000L) {
                RemoteLogClient.sendMessage("AWT_HANG");
            }
            if (++sAliveCounter >= 60) {
                RemoteLogClient.sendMessage(sAliveString);
                sAliveCounter = 0;
            }
            sAWTTime = System.currentTimeMillis();
        }
    }

    private void pause(int n) {
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        sAWTTime = 0L;
        sAliveCounter = 0;
        sDesktopNotificationPending = false;
    }
}

