/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.jmi.bean;

import com.mathworks.jmi.bean.ClassFileConstants;
import com.mathworks.jmi.bean.attribute_info;
import com.mathworks.jmi.bean.class_file;
import com.mathworks.jmi.bean.constant_class_info;
import com.mathworks.jmi.bean.constant_double_info;
import com.mathworks.jmi.bean.constant_fieldref_info;
import com.mathworks.jmi.bean.constant_float_info;
import com.mathworks.jmi.bean.constant_integer_info;
import com.mathworks.jmi.bean.constant_interfaceref_info;
import com.mathworks.jmi.bean.constant_long_info;
import com.mathworks.jmi.bean.constant_methodref_info;
import com.mathworks.jmi.bean.constant_nameandtype_info;
import com.mathworks.jmi.bean.constant_string_info;
import com.mathworks.jmi.bean.constant_utf8_info;
import com.mathworks.jmi.bean.cp_info;
import com.mathworks.jmi.bean.field_info;
import com.mathworks.jmi.bean.method_info;
import com.mathworks.jmi.bean.sourcefile_attribute_info;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.Vector;

public class ClassFileEditor
implements Cloneable,
ClassFileConstants {
    private int constantAttribute = -1;
    private int codeAttribute = -1;
    private int exceptionsAttribute = -1;
    private class_file cf = null;
    private static int interfaceMethodOffset = 2;

    public ClassFileEditor() {
        this.cf = new class_file();
        this.cf.magic = -889275714;
        this.cf.major_version = 45;
        this.cf.minor_version = 3;
        this.cf.constant_pool_count = 1;
        this.cf.constant_pool = new cp_info[1];
        this.cf.access_flags = 0;
        this.cf.this_class = -1;
        this.cf.super_class = -1;
        this.cf.interfaces_count = 0;
        this.cf.interfaces = null;
        this.cf.fields_count = 0;
        this.cf.fields = null;
        this.cf.methods_count = 0;
        this.cf.methods = null;
        this.cf.attributes_count = 0;
        this.cf.attributes = null;
    }

    public ClassFileEditor(String string) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
            this.cf = new class_file();
            this.cf.readValues(randomAccessFile);
            randomAccessFile.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ClassFileEditor classFileEditor = (ClassFileEditor)super.clone();
        classFileEditor.cf = (class_file)this.cf.clone();
        return classFileEditor;
    }

    public void displayFile() {
        this.cf.displayFile();
    }

    public byte[] writeBuffer() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000);
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            this.cf.writeValues(dataOutputStream);
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void writeFile(String string) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            this.cf.writeValues(dataOutputStream);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    public void setClassDeclaration(String string, String string2, String[] stringArray, int n) {
        this.cf.access_flags = n;
        this.cf.this_class = this.addClassRef(string);
        if (string2 == null) {
            string2 = new String("java/lang/Object");
        }
        this.cf.super_class = this.addClassRef(string2);
        this.cf.interfaces_count = stringArray.length;
        this.cf.interfaces = new int[this.cf.interfaces_count];
        for (int i = 0; i < this.cf.interfaces_count; ++i) {
            this.cf.interfaces[i] = this.addClassRef(stringArray[i]);
        }
        this.cf.attributes_count = 1;
        this.cf.attributes = new attribute_info[1];
        String string3 = string.substring(string.lastIndexOf("/") + 1) + ".java";
        this.cf.attributes[0] = new sourcefile_attribute_info(this.addUTF8("SourceFile"), this.addUTF8(string3));
    }

    public void addField(String string, String string2, int n, int n2) {
        int n3 = this.cf.fields_count++;
        field_info[] field_infoArray = this.cf.fields;
        this.cf.fields = new field_info[this.cf.fields_count];
        if (n3 > 0) {
            System.arraycopy(field_infoArray, 0, this.cf.fields, 0, n3);
        }
        this.cf.fields[n3] = new field_info(this.addUTF8(string), this.addUTF8(string2), n, n2);
        if (n2 != -1) {
            if (this.constantAttribute == -1) {
                this.constantAttribute = this.addUTF8("ConstantValue");
            }
            this.cf.fields[n3].attributes[0].attribute_name_index = this.constantAttribute;
        }
    }

    public void addMethod(String string, String string2, int n, byte[] byArray, String[] stringArray, int n2, int n3) {
        int n4 = this.cf.methods_count++;
        method_info[] method_infoArray = this.cf.methods;
        this.cf.methods = new method_info[this.cf.methods_count];
        if (n4 > 0) {
            System.arraycopy(method_infoArray, 0, this.cf.methods, 0, n4);
        }
        int[] nArray = null;
        if (stringArray != null && stringArray.length > 0) {
            nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = this.addClassRef(stringArray[i]);
            }
        }
        this.cf.methods[n4] = new method_info(this.addUTF8(string), this.addUTF8(string2), n, byArray, nArray, n2, n3);
        if (this.codeAttribute == -1) {
            this.codeAttribute = this.addUTF8("Code");
        }
        this.cf.methods[n4].attributes[0].attribute_name_index = this.codeAttribute;
        if (stringArray != null && stringArray.length > 0) {
            if (this.exceptionsAttribute == -1) {
                this.exceptionsAttribute = this.addUTF8("Exceptions");
            }
            this.cf.methods[n4].attributes[1].attribute_name_index = this.exceptionsAttribute;
        }
    }

    public void addMethod(String string, String string2, int n, byte[] byArray, String[] stringArray) {
        this.addMethod(string, string2, n, byArray, stringArray, 5, 10);
    }

    private int newConstantInfo() {
        int n = this.cf.constant_pool_count++;
        cp_info[] cp_infoArray = this.cf.constant_pool;
        this.cf.constant_pool = new cp_info[this.cf.constant_pool_count];
        System.arraycopy(cp_infoArray, 0, this.cf.constant_pool, 0, n);
        return n;
    }

    public int addFieldRef(int n, String string, String string2) {
        int n2 = this.newConstantInfo();
        constant_fieldref_info constant_fieldref_info2 = new constant_fieldref_info(n, this.addNameAndType(string, string2));
        this.cf.constant_pool[n2] = constant_fieldref_info2;
        return n2;
    }

    public int addMethodRef(int n, String string, String string2) {
        int n2 = this.newConstantInfo();
        constant_methodref_info constant_methodref_info2 = new constant_methodref_info(n, this.addNameAndType(string, string2));
        this.cf.constant_pool[n2] = constant_methodref_info2;
        return n2;
    }

    public int addInterfaceMethodRef(int n, String string, String string2) {
        int n2 = this.newConstantInfo();
        constant_interfaceref_info constant_interfaceref_info2 = new constant_interfaceref_info(n, this.addNameAndType(string, string2));
        this.cf.constant_pool[n2] = constant_interfaceref_info2;
        return n2;
    }

    public int addNameAndType(String string, String string2) {
        int n = this.newConstantInfo();
        constant_nameandtype_info constant_nameandtype_info2 = new constant_nameandtype_info(this.addUTF8(string), this.addUTF8(string2));
        this.cf.constant_pool[n] = constant_nameandtype_info2;
        return n;
    }

    public int addClassRef(String string) {
        int n = 0;
        int n2 = this.addUTF8(string);
        for (int i = 1; i < this.cf.constant_pool.length; ++i) {
            if (this.cf.constant_pool[i] == null || this.cf.constant_pool[i].tag != 7 || ((constant_class_info)this.cf.constant_pool[i]).name_index != n2) continue;
            n = i;
        }
        if (n == 0) {
            n = this.newConstantInfo();
            constant_class_info constant_class_info2 = new constant_class_info(n2);
            this.cf.constant_pool[n] = constant_class_info2;
        }
        return n;
    }

    public int addConstant(int n) {
        int n2 = this.newConstantInfo();
        constant_integer_info constant_integer_info2 = new constant_integer_info(n);
        this.cf.constant_pool[n2] = constant_integer_info2;
        return n2;
    }

    public int addConstant(long l) {
        int n = this.newConstantInfo();
        constant_long_info constant_long_info2 = new constant_long_info(l);
        this.cf.constant_pool[n] = constant_long_info2;
        this.newConstantInfo();
        return n;
    }

    public int addConstant(float f) {
        int n = this.newConstantInfo();
        constant_float_info constant_float_info2 = new constant_float_info(f);
        this.cf.constant_pool[n] = constant_float_info2;
        return n;
    }

    public int addConstant(double d) {
        int n = this.newConstantInfo();
        constant_double_info constant_double_info2 = new constant_double_info(d);
        this.cf.constant_pool[n] = constant_double_info2;
        this.newConstantInfo();
        return n;
    }

    public int addConstant(String string) {
        int n = this.newConstantInfo();
        constant_string_info constant_string_info2 = new constant_string_info(this.addUTF8(string));
        this.cf.constant_pool[n] = constant_string_info2;
        return n;
    }

    public int addUTF8(String string) {
        int n = 0;
        for (int i = 1; i < this.cf.constant_pool.length; ++i) {
            if (this.cf.constant_pool[i] == null || this.cf.constant_pool[i].tag != 1 || !string.equals(((constant_utf8_info)this.cf.constant_pool[i]).name)) continue;
            n = i;
        }
        if (n == 0) {
            n = this.newConstantInfo();
            constant_utf8_info constant_utf8_info2 = new constant_utf8_info(string);
            this.cf.constant_pool[n] = constant_utf8_info2;
        }
        return n;
    }

    public void changeClassName(String string) {
        constant_utf8_info constant_utf8_info2 = (constant_utf8_info)this.cf.constant_pool[((constant_class_info)this.cf.constant_pool[this.cf.this_class]).name_index];
        constant_utf8_info2.name = new String(string);
        constant_utf8_info constant_utf8_info3 = (constant_utf8_info)this.cf.constant_pool[((sourcefile_attribute_info)this.cf.attributes[0]).source_file_index];
        constant_utf8_info3.name = string + ".java";
    }

    public void changeInterfaceName(String string) {
        constant_utf8_info constant_utf8_info2 = (constant_utf8_info)this.cf.constant_pool[((constant_class_info)this.cf.constant_pool[this.cf.interfaces[0]]).name_index];
        constant_utf8_info2.name = new String(string);
    }

    public void changeMethodName(int n, String string, int n2) {
        int n3 = n + interfaceMethodOffset;
        this.cf.methods[n3].descriptor_index = n2;
        ((constant_utf8_info)this.cf.constant_pool[this.cf.methods[n3].name_index]).name = new String(string);
    }

    public int addMethodDescriptor(String string) {
        int n = this.cf.constant_pool_count++;
        cp_info[] cp_infoArray = this.cf.constant_pool;
        this.cf.constant_pool = new cp_info[this.cf.constant_pool_count];
        System.arraycopy(cp_infoArray, 0, this.cf.constant_pool, 0, n);
        constant_utf8_info constant_utf8_info2 = new constant_utf8_info();
        this.cf.constant_pool[n] = constant_utf8_info2;
        constant_utf8_info2.tag = 1;
        constant_utf8_info2.name = new String(string);
        return n;
    }

    public String getMethodDescriptor(int n) {
        return ((constant_utf8_info)this.cf.constant_pool[n]).name;
    }

    public String[] getClassesReferenced() {
        Vector<String> vector = new Vector<String>();
        for (int i = 1; i < this.cf.constant_pool.length; ++i) {
            if (this.cf.constant_pool[i] == null || this.cf.constant_pool[i].tag != 7) continue;
            constant_class_info constant_class_info2 = (constant_class_info)this.cf.constant_pool[i];
            String string = this.getMethodDescriptor(constant_class_info2.name_index);
            string = string.replace('/', '.');
            vector.addElement(string);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public String[] getMethodsReferenced() {
        Vector<String> vector = new Vector<String>();
        for (int i = 1; i < this.cf.constant_pool.length; ++i) {
            int n;
            if (this.cf.constant_pool[i] == null || this.cf.constant_pool[i].tag != 10) continue;
            constant_methodref_info constant_methodref_info2 = (constant_methodref_info)this.cf.constant_pool[i];
            constant_class_info constant_class_info2 = (constant_class_info)this.cf.constant_pool[constant_methodref_info2.class_index];
            String string = this.getMethodDescriptor(constant_class_info2.name_index);
            string = string.replace('/', '.');
            constant_nameandtype_info constant_nameandtype_info2 = (constant_nameandtype_info)this.cf.constant_pool[constant_methodref_info2.name_and_type_index];
            String string2 = this.getMethodDescriptor(constant_nameandtype_info2.name_index);
            if (string2.equals("<init>") && (n = (string2 = string).lastIndexOf(46)) != -1) {
                string2 = string2.substring(n + 1);
            }
            vector.addElement(string + "." + string2 + this.getMethodDescriptor(constant_nameandtype_info2.descriptor_index));
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public String getClassName() {
        String string = this.getMethodDescriptor(((constant_class_info)this.cf.constant_pool[this.cf.this_class]).name_index);
        string = string.replace('/', '.');
        return string;
    }

    public String[] getPublicMethods() {
        Vector<String> vector = new Vector<String>();
        int n = this.cf.methods_count;
        for (int i = 0; i < n; ++i) {
            int n2;
            if ((this.cf.methods[i].access_flags & 1) == 0) continue;
            String string = this.getMethodDescriptor(this.cf.methods[i].name_index);
            if (string.equals("<init>") && (n2 = (string = this.getClassName()).lastIndexOf(46)) != -1) {
                string = string.substring(n2 + 1);
            }
            String string2 = this.getMethodDescriptor(this.cf.methods[i].descriptor_index);
            vector.addElement(string + string2);
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    private static void test1() {
        ClassFileEditor classFileEditor = new ClassFileEditor("d:\\JavaExperiments\\BeanGObject\\listenerclass.tmplt");
        classFileEditor.displayFile();
    }

    public static void main(String[] stringArray) {
        ClassFileEditor.test1();
    }
}

