/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.governance.dcep;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import org.ow2.play.governance.api.ComplexPatternService;
import org.ow2.play.governance.api.EventGovernance;
import org.ow2.play.governance.api.GovernanceExeption;
import org.ow2.play.governance.api.PatternRegistry;
import org.ow2.play.governance.api.SimplePatternService;
import org.ow2.play.governance.api.bean.Pattern;
import org.ow2.play.governance.api.bean.Topic;
import org.ow2.play.metadata.api.Data;
import org.ow2.play.metadata.api.Metadata;

public class ComplexPatternServiceImpl
implements ComplexPatternService {
    private static Logger logger = Logger.getLogger(ComplexPatternServiceImpl.class.getName());
    private SimplePatternService simplePatternService;
    private EventGovernance eventGovernance;
    private PatternRegistry patternRegistry;
    private AtomicLong id = new AtomicLong(0L);

    @WebMethod
    public List<Metadata> deploy(String id, String pattern, List<Metadata> metadata) throws GovernanceExeption {
        long sequenceId = this.id.incrementAndGet();
        long start = System.currentTimeMillis();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("[SEQ:" + sequenceId + "] Deploying pattern : " + id);
        }
        ArrayList result = Lists.newArrayList();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("[SEQ:" + sequenceId + "] creating topics...");
        }
        String endpoint = this.createTopics(pattern);
        result.add(new Metadata("endpoint", new Data("url", endpoint)));
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("[SEQ:" + sequenceId + "] topic creation endpoint : " + endpoint);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("[SEQ:" + sequenceId + "] deploying pattern...");
        }
        this.deployPattern(id, pattern);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("[SEQ:" + sequenceId + "] pattern deployed!");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("[SEQ:" + sequenceId + "] registering pattern...");
        }
        this.registerPattern(id, pattern, metadata);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("[SEQ:" + sequenceId + "] pattern registred!");
        }
        logger.info("Pattern deployed in the platform in " + (System.currentTimeMillis() - start) + " ms");
        return result;
    }

    private void registerPattern(String id, String pattern, List<Metadata> metadata) {
        if (this.patternRegistry == null) {
            logger.fine("Pattern registry is null");
            return;
        }
        Pattern p = new Pattern();
        p.id = id;
        p.content = pattern;
        p.name = "_" + id;
        p.recordDate = "" + System.currentTimeMillis();
        try {
            this.patternRegistry.put(p);
        }
        catch (GovernanceExeption e) {
            logger.warning("Can not register pattern in registry : " + e.getMessage());
        }
    }

    private void deployPattern(String id, String pattern) throws GovernanceExeption {
        this.simplePatternService.deploy(id, pattern);
    }

    private String createTopics(String pattern) {
        String result = null;
        try {
            List inTopics = this.simplePatternService.getInputTopics(pattern);
            List outTopics = this.simplePatternService.getOutputTopics(pattern);
            for (Topic topic : outTopics) {
                result = this.eventGovernance.createSubscriberTopic(topic);
            }
        }
        catch (GovernanceExeption e) {
            e.printStackTrace();
        }
        return result;
    }

    @WebMethod
    public List<Metadata> undeploy(String id) throws GovernanceExeption {
        this.simplePatternService.undeploy(id);
        return Lists.newArrayList();
    }

    public void setSimplePatternService(SimplePatternService simplePatternService) {
        this.simplePatternService = simplePatternService;
    }

    public void setEventGovernance(EventGovernance eventGovernance) {
        this.eventGovernance = eventGovernance;
    }

    public void setPatternRegistry(PatternRegistry patternRegistry) {
        this.patternRegistry = patternRegistry;
    }
}

