/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.governance.dcep;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import org.ow2.play.governance.api.ComplexPatternService;
import org.ow2.play.governance.api.GovernanceExeption;
import org.ow2.play.governance.api.SimplePatternService;
import org.ow2.play.governance.api.bean.Pattern;
import org.ow2.play.governance.api.bean.Topic;
import org.ow2.play.metadata.api.Data;
import org.ow2.play.metadata.api.Metadata;

public class PatternServiceImpl
implements SimplePatternService {
    private static Logger logger = Logger.getLogger(PatternServiceImpl.class.getName());
    private ComplexPatternService complexPatternService;
    private SimplePatternService simplePatternService;

    @WebMethod
    public List<Topic> getInputTopics(String pattern) throws GovernanceExeption {
        logger.info("Get input topics");
        return this.simplePatternService.getInputTopics(pattern);
    }

    @WebMethod
    public List<Topic> getOutputTopics(String pattern) throws GovernanceExeption {
        return this.simplePatternService.getOutputTopics(pattern);
    }

    @WebMethod
    public String deploy(String id, String pattern) throws GovernanceExeption {
        String result = "";
        List out = this.complexPatternService.deploy(id, pattern, null);
        ArrayList endpoints = Lists.newArrayList((Iterable)Collections2.filter((Collection)out, (Predicate)new Predicate<Metadata>(){

            public boolean apply(Metadata md) {
                return md != null && md.getName() != null && md.getName().equals("endpoint");
            }
        }));
        result = endpoints.get(0) != null && ((Metadata)endpoints.get(0)).getData() != null && ((Metadata)endpoints.get(0)).getData().get(0) != null ? ((Data)((Metadata)endpoints.get(0)).getData().get(0)).getValue() : "";
        return result;
    }

    @WebMethod
    public List<Pattern> getPatterns() throws GovernanceExeption {
        throw new GovernanceExeption("Not implemented");
    }

    @WebMethod
    public Pattern getPattern(String id) throws GovernanceExeption {
        throw new GovernanceExeption("Not implemented");
    }

    @WebMethod
    public String undeploy(String id) throws GovernanceExeption {
        this.complexPatternService.undeploy(id);
        return "";
    }

    public void setComplexPatternService(ComplexPatternService complexPatternService) {
        this.complexPatternService = complexPatternService;
    }

    public void setSimplePatternService(SimplePatternService simplePatternService) {
        this.simplePatternService = simplePatternService;
    }
}

