/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.metadata.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import org.bson.types.BasicBSONList;
import org.ow2.play.metadata.api.Data;
import org.ow2.play.metadata.api.MetaResource;
import org.ow2.play.metadata.api.Metadata;
import org.ow2.play.metadata.api.Resource;
import org.ow2.play.metadata.mongodb.BSONAdapter;

public class BSONAdapterImpl
implements BSONAdapter {
    @Override
    public DBObject createBSON(MetaResource metaResource) {
        BasicDBObject result = null;
        if (metaResource != null) {
            result = new BasicDBObject();
            result.put("resource", (Object)this.createBSON(metaResource.getResource()));
            BasicBSONList list = new BasicBSONList();
            for (Metadata md : metaResource.getMetadata()) {
                list.add((Object)this.createBSON(md));
            }
            result.put("metadata", (Object)list);
        }
        return result;
    }

    @Override
    public DBObject createBSON(Resource resource) {
        BasicDBObject result = null;
        if (resource != null) {
            result = new BasicDBObject();
            result.put("name", (Object)resource.getName());
            result.put("url", (Object)resource.getUrl());
        }
        return result;
    }

    @Override
    public DBObject createBSON(Metadata metadata) {
        BasicDBObject result = null;
        if (metadata != null) {
            result = new BasicDBObject();
            result.put("name", (Object)metadata.getName());
            BasicBSONList list = new BasicBSONList();
            for (Data data : metadata.getData()) {
                list.add((Object)this.createBSON(data));
            }
            result.put("data", (Object)list);
        }
        return result;
    }

    @Override
    public DBObject createBSON(Data data) {
        BasicDBObject result = null;
        if (data != null) {
            result = new BasicDBObject();
            result.put("type", (Object)data.getType());
            result.put("value", (Object)data.getValue());
        }
        return result;
    }

    @Override
    public MetaResource readMetaResource(DBObject dbo) {
        if (dbo == null) {
            return null;
        }
        MetaResource result = new MetaResource();
        result.setResource(this.readResource((DBObject)dbo.get("resource")));
        Object o = dbo.get("metadata");
        if (o != null && o instanceof BasicDBList) {
            BasicDBList metalist = (BasicDBList)o;
            for (Object object : metalist) {
                if (object != null && object instanceof DBObject) {
                    DBObject entry = (DBObject)object;
                    System.out.println(entry);
                    Metadata md = new Metadata();
                    md.setName(entry.get("name").toString());
                    Object data = entry.get("data");
                    if (data != null && data instanceof BasicDBList) {
                        BasicDBList list = (BasicDBList)data;
                        for (Object object2 : list) {
                            md.getData().add(new Data(((DBObject)object2).get("type").toString(), ((DBObject)object2).get("value").toString()));
                        }
                    }
                    result.getMetadata().add(md);
                    continue;
                }
                System.out.println("BAD object : " + object);
            }
        }
        return result;
    }

    @Override
    public Resource readResource(DBObject object) {
        if (object == null) {
            return null;
        }
        return new Resource(object.get("name").toString(), object.get("url").toString());
    }
}

