/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.play.service.registry.mongo;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.ServerAddress;
import com.mongodb.WriteResult;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jws.WebMethod;
import org.ow2.play.service.registry.api.Entry;
import org.ow2.play.service.registry.api.Registry;
import org.ow2.play.service.registry.api.RegistryException;

public class RegistryImpl
implements Registry {
    private static final String DEFAULT_MONGO_DB_HOSTNAME = "localhost";
    private static final String DEFAULT_MONGO_DB_PORT = "27017";
    private static final String DEFAULT_MONGO_DB_DATABASE_NAME = "play";
    private static final String DEFAULT_MONGO_DB_COLLECTION_NAME = "serviceregistry";
    private static final String URL_KEY = "url";
    private static final String NAME_KEY = "name";
    private String hostname = "localhost";
    private String port = "27017";
    private String databaseName = "play";
    private String collectionName = "serviceregistry";
    private String userName;
    private String password;
    private Mongo mongo;
    private DBCollection collection;
    private Properties properties;
    private boolean initialized = false;
    private static Logger logger = Logger.getLogger(RegistryImpl.class.getName());

    @WebMethod
    public void init() throws RegistryException {
        logger.info("Initializing registry service");
        if (this.initialized) {
            logger.info("Already initialized");
            return;
        }
        if (this.mongo != null) {
            this.close();
        }
        if (this.properties != null) {
            logger.fine("Getting properties from " + this.properties);
            this.hostname = this.properties.getProperty("mongo.hostname", DEFAULT_MONGO_DB_HOSTNAME);
            this.port = this.properties.getProperty("mongo.port", DEFAULT_MONGO_DB_PORT);
            this.userName = this.properties.getProperty("mongo.username", this.userName);
            this.password = this.properties.getProperty("mongo.password", this.password);
            this.collectionName = this.properties.getProperty("mongo.collection", DEFAULT_MONGO_DB_COLLECTION_NAME);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info(String.format("Connection to %s %s with credentials %s %s", this.hostname, this.port, this.userName, "******"));
        }
        List<ServerAddress> addresses = this.getServerAddresses(this.hostname, this.port);
        logger.fine("Got server addresses " + addresses);
        this.mongo = this.getMongo(addresses);
        DB database = this.getDatabase(this.mongo, this.databaseName);
        if (this.userName != null && this.userName.trim().length() > 0) {
            if (!database.authenticate(this.userName, this.password.toCharArray())) {
                throw new RuntimeException("Unable to authenticate with MongoDB server.");
            }
            this.password = null;
        }
        this.setCollection(database.getCollection(this.collectionName));
        this.initialized = true;
    }

    @WebMethod
    public String get(String name) throws RegistryException {
        String url = null;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Get url for name %s", name));
        }
        this.checkInitialized();
        BasicDBObject filter = new BasicDBObject();
        filter.put(NAME_KEY, (Object)name);
        DBObject result = this.collection.findOne((DBObject)filter);
        if (result != null && result.get(URL_KEY) != null) {
            url = result.get(URL_KEY).toString();
        }
        return url;
    }

    @WebMethod
    public List<Entry> entries() throws RegistryException {
        ArrayList<Entry> result = new ArrayList<Entry>();
        for (String key : this.keys()) {
            Entry entry = new Entry();
            entry.key = key;
            entry.value = this.get(key);
            result.add(entry);
        }
        return result;
    }

    @WebMethod
    public void put(String name, String url) throws RegistryException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Put url %s for name %s", url, name));
        }
        this.checkInitialized();
        if (name == null || url == null) {
            throw new RegistryException("Can not put null values name = %s, url = %s", new Object[]{name, url});
        }
        BasicDBObject filter = new BasicDBObject();
        filter.put(NAME_KEY, (Object)name);
        DBObject filtered = this.collection.findOne((DBObject)filter);
        if (filtered != null) {
            filtered.put(URL_KEY, (Object)url);
            this.collection.save(filtered);
        } else {
            BasicDBObject o = new BasicDBObject();
            o.put(NAME_KEY, (Object)name);
            o.put(URL_KEY, (Object)url);
            this.collection.insert(new DBObject[]{o});
        }
    }

    @WebMethod
    public List<String> keys() throws RegistryException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Get keys");
        }
        this.checkInitialized();
        ArrayList<String> result = new ArrayList<String>();
        DBCursor cursor = this.collection.find();
        for (DBObject dbObject : cursor) {
            if (dbObject == null || dbObject.get(NAME_KEY) == null) continue;
            result.add(dbObject.get(NAME_KEY).toString());
        }
        return result;
    }

    @WebMethod
    public void clear() throws RegistryException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Clear");
        }
        this.checkInitialized();
        this.clearCollection();
    }

    @WebMethod
    public void load(String url) throws RegistryException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("Load from url %s", url));
        }
        if (url == null) {
            throw new RegistryException("Can not load properties from null value");
        }
        if (!this.initialized) {
            this.init();
        }
        Properties props = new Properties();
        try {
            URL u = new URL(url);
            props.load(u.openStream());
            for (Object key : props.keySet()) {
                String k = key.toString();
                String v = props.getProperty(k);
                if (v == null) continue;
                this.put(k, v.toString());
            }
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
            throw new RegistryException((Throwable)e);
        }
    }

    protected void checkInitialized() throws RegistryException {
        if (!this.initialized) {
            throw new RegistryException("Registry has not been initialized");
        }
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    protected DB getDatabase(Mongo mongo, String databaseName) {
        return mongo.getDB(databaseName);
    }

    protected DBCollection getDbCollection() {
        return this.collection;
    }

    protected Mongo getMongo(List<ServerAddress> addresses) {
        if (addresses.size() == 1) {
            return new Mongo(addresses.get(0));
        }
        return new Mongo(addresses);
    }

    protected void close() {
        if (this.mongo != null) {
            this.collection = null;
            this.mongo.close();
        }
    }

    public void setCollection(DBCollection collection) {
        assert (collection != null) : "collection must not be null";
        this.collection = collection;
    }

    private List<ServerAddress> getServerAddresses(String hostname, String port) {
        List<Integer> portNums;
        ArrayList<ServerAddress> addresses = new ArrayList<ServerAddress>();
        String[] hosts = hostname.split(" ");
        String[] ports = port.split(" ");
        if (!(ports.length != 1 && ports.length != hosts.length || (portNums = this.getPortNums(ports)).size() != 1 && portNums.size() != hosts.length)) {
            boolean onePort = portNums.size() == 1;
            int i = 0;
            for (String host : hosts) {
                int portNum = onePort ? portNums.get(0) : portNums.get(i);
                try {
                    addresses.add(new ServerAddress(host.trim(), portNum));
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
                ++i;
            }
        }
        return addresses;
    }

    private List<Integer> getPortNums(String[] ports) {
        ArrayList<Integer> portNums = new ArrayList<Integer>();
        for (String port : ports) {
            try {
                Integer portNum = Integer.valueOf(port.trim());
                if (portNum < 0) continue;
                portNums.add(portNum);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return portNums;
    }

    protected void clearCollection() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Remove all objects from the collection");
        }
        WriteResult wr = this.getDbCollection().remove((DBObject)new BasicDBObject());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Write result : " + wr);
        }
    }
}

