/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.basenotification.datatypes.api.test;

import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.FilterType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.MessageContentExpression;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.ProducerPropertiesExpression;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.QueryExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Renew;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.RenewResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Unsubscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UseRaw;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.WsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.WsnbReader;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.WsnbWriter;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.implementor.WsnbModelFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.test.WsnbUnitTestsUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.test.util.AbsWsaTypesUnitTests;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.test.util.WsaUnitTestsUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.UUID;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class AbsWsnbTypesAndPayloadsUnitTests
extends TestCase {
    protected boolean isDebug = false;
    private WsnbFactory factory;
    protected WsnbModelFactory modelFactoryImpl;
    private WsnbReader reader;
    private WsnbWriter writer;

    protected void setUp() throws Exception {
        super.setUp();
        this.initRefinedWsnbFactory();
        this.initRequiredDependencyModelFactories();
    }

    protected abstract void setWsnbModelFactory();

    protected abstract void initRequiredDependencyModelFactories();

    public void initRefinedWsnbFactory() {
        if (this.modelFactoryImpl == null) {
            this.setWsnbModelFactory();
        }
        AbsWsnbTypesAndPayloadsUnitTests.assertNotNull((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "the \"WsnbModelFactory\" implementation Object has not been set.\n" + "Please provide an instance of \"WsnbModelFactory\" implementation class"), (Object)this.modelFactoryImpl);
        if (this.factory == null) {
            this.factory = RefinedWsnbFactory.getInstance((WsnbModelFactory)this.modelFactoryImpl);
        }
        if (this.reader == null) {
            this.reader = this.factory.getWsnbReader();
        }
        if (this.writer == null) {
            this.writer = this.factory.getWsnbWriter();
        }
    }

    protected FilterType createDefaultFilter() throws WsnbException {
        FilterType filter = this.factory.createFilterType();
        TopicExpressionType topicExpression = this.factory.createTopicExpressionType(WstopConstants.XPATH_TOPIC_EXPRESSION_DIALECT_URI);
        topicExpression.setContent("tns1:rootTopic/*/grandChildTopic1");
        try {
            topicExpression.addTopicNamespace("tns1", new URI("http://default/namespace/for/topic"));
        }
        catch (URISyntaxException e1) {
            throw new WsnbException((Throwable)e1);
        }
        filter.addTopicExpression(topicExpression);
        MessageContentExpression msgContentExpression = this.factory.createMessageContentExpression(WstopConstants.XPATH_TOPIC_EXPRESSION_DIALECT_URI);
        msgContentExpression.setContent("/data/temperature[external>35]");
        filter.addMessageContentExpression(msgContentExpression);
        ProducerPropertiesExpression prodPropertiesExpression = this.factory.createProducerPropertiesExpression(WstopConstants.XPATH_TOPIC_EXPRESSION_DIALECT_URI);
        prodPropertiesExpression.setContent("*//identity[name=\"External Sensor\"]");
        filter.addProducerPropertiesExpression(prodPropertiesExpression);
        return filter;
    }

    protected Document createDefaultDocument(String docUri) throws WsnbException {
        Document defaultDoc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            defaultDoc = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new WsnbException((Throwable)e);
        }
        return defaultDoc;
    }

    protected SubscriptionManagerRP createDefaultSubscriptionManagerRP() throws WsnbException {
        EndpointReferenceType consumerRef = null;
        try {
            consumerRef = WsnbUnitTestsUtils.createDefaultWsnConsumerOriginator();
        }
        catch (URISyntaxException e1) {
            throw new WsnbException((Throwable)e1);
        }
        SubscriptionManagerRP subscription = this.factory.createSubscriptionManagerRP(consumerRef);
        subscription.setFilter(this.createDefaultFilter());
        subscription.setCreationTime(new Date());
        SubscriptionPolicyType policy = this.factory.createSubscriptionPolicyType();
        Document defaultDoc = this.createDefaultDocument("http://defauturi/for/policy");
        Element policyAsElt = defaultDoc.createElement("CustomPolicy");
        Element child1 = defaultDoc.createElement("NotifFrequency");
        child1.setNodeValue("1 per minute max");
        policyAsElt.appendChild(child1);
        policy.addPolicy(policyAsElt);
        subscription.setSubscriptionPolicy(policy);
        return subscription;
    }

    public static boolean checkTopicExpressionType(TopicExpressionType expectedTopicExpression, TopicExpressionType toCheckTopicExpression, boolean isDebug) {
        URI expectedDialect = expectedTopicExpression.getDialect();
        URI toCheckDialect = toCheckTopicExpression.getDialect();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckDialect value : " + (toCheckDialect != null ? toCheckDialect.toString() : "null") + "\n[DEBUG] --> expectedDialect value : " + (expectedDialect != null ? expectedDialect.toString() : "null") + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "TopicExpression dialects are \n" + "\t(-> toCheckDialect value : " + (toCheckDialect != null ? toCheckDialect.toString() : "null") + "\n\t-> expectedDialect value : " + (expectedDialect != null ? expectedDialect.toString() : "null") + ")"), (toCheckDialect == expectedDialect || toCheckDialect != null && toCheckDialect.equals(expectedDialect) ? 1 : 0) != 0);
        String expectedContent = expectedTopicExpression.getContent();
        String toCheckContent = toCheckTopicExpression.getContent();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckContent value : " + toCheckContent + "\n[DEBUG] --> expectedContent value : " + expectedContent + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "TopicExpression contents are \n" + "\t(-> toCheckContent value : " + toCheckContent + "\n\t-> expectedContent value : " + expectedContent + ")"), (toCheckContent == expectedContent || toCheckContent != null && toCheckContent.equals(expectedContent) ? 1 : 0) != 0);
        List expectedTopicNamespaces = expectedTopicExpression.getTopicNamespaces();
        List toCheckTopicNamespaces = toCheckTopicExpression.getTopicNamespaces();
        int expectedTopicNamespacesCount = expectedTopicNamespaces != null ? expectedTopicNamespaces.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "TopicExpression have different \"TopicNamespace\" values\n" + "\t(-> toCheckTopicExpression topicNamespace count : " + (toCheckTopicNamespaces != null ? Integer.valueOf(toCheckTopicNamespaces.size()) : "none") + "\n\t-> expectedTopicExpression topicNamespace count : " + (expectedTopicNamespacesCount == -1 ? "none" : Integer.valueOf(expectedTopicNamespacesCount)) + ")"), (toCheckTopicNamespaces == null && expectedTopicNamespaces == null || toCheckTopicNamespaces.size() == expectedTopicNamespacesCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedTopicNamespacesCount; ++i) {
            QName toCheckTopicNamespace = (QName)toCheckTopicNamespaces.get(i);
            QName expectedTopicNamespace = (QName)expectedTopicNamespaces.get(i);
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckTopicExpression TopicNamespace #" + i + " : \"" + toCheckTopicNamespace + "\n[DEBUG] --> expectedTopicExpression TopicNamespace #" + i + " : \"" + expectedTopicNamespace + "\"\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "faults  UnknownFilter values are different \n" + "\t(-> toCheckTopicExpression TopicNamespace #" + i + " : " + toCheckTopicNamespace + "\n\t-> expectedTopicExpression TopicNamespace #" + i + " : " + expectedTopicNamespace + ")"), (boolean)toCheckTopicNamespace.equals(expectedTopicNamespace));
        }
        return true;
    }

    protected static boolean checkMessageContentExpression(MessageContentExpression expectedMessageContent, MessageContentExpression toCheckMessageContent, boolean isDebug) {
        URI expectedDialect = expectedMessageContent.getDialect();
        URI toCheckDialect = toCheckMessageContent.getDialect();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckDialect value : " + (toCheckDialect != null ? toCheckDialect.toString() : "null") + "\n[DEBUG] --> expectedDialect value : " + (expectedDialect != null ? expectedDialect.toString() : "null") + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "MessageContentExpression dialects are \n" + "\t(-> toCheckDialect value : " + (toCheckDialect != null ? toCheckDialect.toString() : "null") + "\n\t-> expectedDialect value : " + (expectedDialect != null ? expectedDialect.toString() : "null") + ")"), (toCheckDialect == expectedDialect || toCheckDialect != null && toCheckDialect.equals(expectedDialect) ? 1 : 0) != 0);
        String expectedContent = expectedMessageContent.getContent();
        String toCheckContent = toCheckMessageContent.getContent();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckContent value : " + toCheckContent + "\n[DEBUG] --> expectedContent value : " + expectedContent + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "MessageContentExpression contents are \n" + "\t(-> toCheckContent value : " + toCheckContent + "\n\t-> expectedContent value : " + expectedContent + ")"), (toCheckContent == expectedContent || toCheckContent != null && toCheckContent.equals(expectedContent) ? 1 : 0) != 0);
        return true;
    }

    protected static boolean checkProducerPropertiesExpression(ProducerPropertiesExpression expectedProducerProperties, ProducerPropertiesExpression toCheckProducerProperties, boolean isDebug) {
        URI expectedDialect = expectedProducerProperties.getDialect();
        URI toCheckDialect = toCheckProducerProperties.getDialect();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckDialect value : " + (toCheckDialect != null ? toCheckDialect.toString() : "null") + "\n[DEBUG] --> expectedDialect value : " + (expectedDialect != null ? expectedDialect.toString() : "null") + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "ProducerPropertiesExpression dialects are \n" + "\t(-> toCheckDialect value : " + (toCheckDialect != null ? toCheckDialect.toString() : "null") + "\n\t-> expectedDialect value : " + (expectedDialect != null ? expectedDialect.toString() : "null") + ")"), (toCheckDialect == expectedDialect || toCheckDialect != null && toCheckDialect.equals(expectedDialect) ? 1 : 0) != 0);
        String expectedContent = expectedProducerProperties.getContent();
        String toCheckContent = toCheckProducerProperties.getContent();
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckContent value : " + toCheckContent + "\n[DEBUG] --> expectedContent value : " + expectedContent + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "ProducerPropertiesExpression contents are \n" + "\t(-> toCheckContent value : " + toCheckContent + "\n\t-> expectedContent value : " + expectedContent + ")"), (toCheckContent == expectedContent || toCheckContent != null && toCheckContent.equals(expectedContent) ? 1 : 0) != 0);
        return true;
    }

    protected static boolean checkFilterType(FilterType expectedFilter, FilterType toCheckFilter, boolean isDebug) {
        List expectedTopicExpressions = expectedFilter.getTopicExpressions();
        List toCheckTopicExpressions = toCheckFilter.getTopicExpressions();
        int expectedTopicExpressionsCount = expectedTopicExpressions != null ? expectedTopicExpressions.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Filters have different TopicExpression list \n" + "\t(-> toCheckFilter TopicExpressions count : " + (toCheckTopicExpressions != null ? Integer.valueOf(toCheckTopicExpressions.size()) : "none") + "\n\t-> expectedFilter TopicExpressions count : " + (expectedTopicExpressionsCount == -1 ? "none" : Integer.valueOf(expectedTopicExpressionsCount)) + ")"), (expectedTopicExpressions == null && toCheckTopicExpressions == null || toCheckTopicExpressions.size() == expectedTopicExpressionsCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedTopicExpressionsCount; ++i) {
            TopicExpressionType toCheckTopicExpression = (TopicExpressionType)toCheckTopicExpressions.get(i);
            TopicExpressionType expectedTopicExpression = (TopicExpressionType)expectedTopicExpressions.get(i);
            if (isDebug) {
                System.out.println("[DEBUG] \t ~~~~ TopicExpression (# " + i + ") details : ~~~~\n");
            }
            AbsWsnbTypesAndPayloadsUnitTests.checkTopicExpressionType(expectedTopicExpression, toCheckTopicExpression, isDebug);
            if (!isDebug) continue;
            System.out.println("[DEBUG] \t\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        List expectedMessageContentExpressions = expectedFilter.getMessageContentExpressions();
        List toCheckMessageContentExpressions = toCheckFilter.getMessageContentExpressions();
        int expectedMessageContentExpressionsCount = expectedMessageContentExpressions != null ? expectedMessageContentExpressions.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Filters have different MessageContentExpression list \n" + "\t(-> toCheckFilter MessageContentExpressions count : " + (toCheckMessageContentExpressions != null ? Integer.valueOf(toCheckMessageContentExpressions.size()) : "none") + "\n\t-> expectedFilter MessageContentExpressions count : " + (expectedMessageContentExpressionsCount == -1 ? "none" : Integer.valueOf(expectedMessageContentExpressionsCount)) + ")"), (expectedMessageContentExpressions == null && toCheckMessageContentExpressions == null || toCheckMessageContentExpressions.size() == expectedMessageContentExpressionsCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedMessageContentExpressionsCount; ++i) {
            MessageContentExpression toCheckMessageContentExpression = (MessageContentExpression)toCheckMessageContentExpressions.get(i);
            MessageContentExpression expectedMessageContentExpression = (MessageContentExpression)expectedMessageContentExpressions.get(i);
            if (isDebug) {
                System.out.println("[DEBUG] \t~~~~ MessageContentExpression (# " + i + ") details : ~~~~\n");
            }
            AbsWsnbTypesAndPayloadsUnitTests.checkMessageContentExpression(expectedMessageContentExpression, toCheckMessageContentExpression, isDebug);
            if (!isDebug) continue;
            System.out.println("[DEBUG] \t\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        List expectedProducerPropertiesExpressions = expectedFilter.getProducerPropertiesExpressions();
        List toCheckProducerPropertiesExpressions = toCheckFilter.getProducerPropertiesExpressions();
        int expectedProducerPropertiesExpressionsCount = expectedProducerPropertiesExpressions != null ? expectedProducerPropertiesExpressions.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Filters have different ProducerPropertiesExpression list \n" + "\t(-> toCheckFilter ProducerPropertiesExpressions count : " + (toCheckProducerPropertiesExpressions != null ? Integer.valueOf(toCheckProducerPropertiesExpressions.size()) : "none") + "\n\t-> expectedFilter ProducerPropertiesExpressions count : " + (expectedProducerPropertiesExpressionsCount == -1 ? "none" : Integer.valueOf(expectedProducerPropertiesExpressionsCount)) + ")"), (expectedProducerPropertiesExpressions == null && toCheckProducerPropertiesExpressions == null || toCheckProducerPropertiesExpressions.size() == expectedProducerPropertiesExpressionsCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedProducerPropertiesExpressionsCount; ++i) {
            ProducerPropertiesExpression toCheckProducerPropertiesExpression = (ProducerPropertiesExpression)toCheckProducerPropertiesExpressions.get(i);
            ProducerPropertiesExpression expectedProducerPropertiesExpression = (ProducerPropertiesExpression)expectedProducerPropertiesExpressions.get(i);
            if (isDebug) {
                System.out.println("[DEBUG] \t ~~~~ ProducerPropertiesExpression (# " + i + ") details : ~~~~\n");
            }
            AbsWsnbTypesAndPayloadsUnitTests.checkProducerPropertiesExpression(expectedProducerPropertiesExpression, toCheckProducerPropertiesExpression, isDebug);
            if (!isDebug) continue;
            System.out.println("[DEBUG] \t\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        return true;
    }

    protected static boolean checkGetCurrentMessage(GetCurrentMessage expectedPayload, GetCurrentMessage toCheckPayload, boolean isDebug) {
        TopicExpressionType expectedTopic = expectedPayload.getTopic();
        TopicExpressionType toCheckTopic = toCheckPayload.getTopic();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Payloads \"GetCurrentMessage\" have different topic \n" + "\t(-> toCheckTopic is " + (toCheckTopic != null ? "not null" : "null") + "\n\t-> expectedTopic is " + (expectedTopic != null ? "not null" : "null") + ")"), (toCheckTopic != null && expectedTopic != null ? 1 : 0) != 0);
        AbsWsnbTypesAndPayloadsUnitTests.checkTopicExpressionType(expectedTopic, toCheckTopic, isDebug);
        return true;
    }

    protected static boolean checkGetCurrentMessageResponse(GetCurrentMessageResponse expectedPayload, GetCurrentMessageResponse toCheckPayload, boolean isDebug) {
        List expectedNotifications = expectedPayload.getNotifications();
        List toCheckNotifications = toCheckPayload.getNotifications();
        int expectedNotificationsCount = expectedNotifications != null ? expectedNotifications.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Filters have different ProducerPropertiesExpression list \n" + "\t(-> toCheckPayload Notifications count : " + (toCheckNotifications != null ? Integer.valueOf(toCheckNotifications.size()) : "none") + "\n\t-> expectedPayload Notifications count : " + (expectedNotificationsCount == -1 ? "none" : Integer.valueOf(expectedNotificationsCount)) + ")"), (expectedNotifications == null && toCheckNotifications == null || toCheckNotifications.size() == expectedNotificationsCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedNotificationsCount; ++i) {
            NotificationMessageHolderType.Message toCheckMessage = (NotificationMessageHolderType.Message)toCheckNotifications.get(i);
            NotificationMessageHolderType.Message expectedMessage = (NotificationMessageHolderType.Message)expectedNotifications.get(i);
            if (isDebug) {
                System.out.println("[DEBUG] \t ~~~~ Message (# " + i + ") details : ~~~~\n");
            }
            AbsWsnbTypesAndPayloadsUnitTests.checkNotificationMessageHolderTypeMessage(expectedMessage, toCheckMessage, isDebug);
            if (!isDebug) continue;
            System.out.println("[DEBUG] \t\t~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        return true;
    }

    protected static boolean checkNotificationMessageHolderTypeMessage(NotificationMessageHolderType.Message expectedMessage, NotificationMessageHolderType.Message toCheckMessage, boolean isDebug) {
        Element toCheckAny = toCheckMessage.getAny();
        Element expectedAny = expectedMessage.getAny();
        String toCheckAnyType = toCheckAny.getClass().getSimpleName();
        String toCheckAnySuperType = toCheckAny.getClass().getSuperclass().getSimpleName();
        String expectedAnyType = expectedAny.getClass().getSimpleName();
        String expectedAnySuperType = expectedAny.getClass().getSuperclass().getSimpleName();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Message of NotificationMessageHolder have not supported typed content.\n" + "Expected content of message is \"org.w3c.dom.Element\" types." + "(Found types for messages are :\n" + "-> toCheck Message content type is : " + toCheckAnyType + "\n" + "-> expected Message content type is : " + expectedAnyType + ")"), (toCheckAnyType.equals(expectedAnyType) || toCheckAnySuperType.equals(expectedAnyType) || toCheckAnyType.equals(expectedAnySuperType) || toCheckAnySuperType.equals(expectedAnySuperType) ? 1 : 0) != 0);
        if (toCheckAny instanceof Element) {
            String toCheckAnyEltAsString = WsaUnitTestsUtils.formatToComparison((Element)toCheckAny);
            String expectedAnyEltAsString = WsaUnitTestsUtils.formatToComparison((Element)expectedAny);
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckMessage any value : " + toCheckAnyEltAsString + "\n[DEBUG] --> expectedMessage any value : " + expectedAnyEltAsString + "\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Message Element Content (formatted to comparison) are \n" + "\t(-> toCheckMessage any value : " + toCheckAnyEltAsString + "\n\t-> expectedMessage any value : " + expectedAnyEltAsString + ")"), (boolean)toCheckAnyEltAsString.equals(expectedAnyEltAsString));
        }
        return true;
    }

    protected static boolean checkNotificationMessageHolderType(NotificationMessageHolderType expectedNotifMsgHolder, NotificationMessageHolderType toCheckNotifMsgHolder, boolean isDebug) {
        NotificationMessageHolderType.Message toCheckMessage = toCheckNotifMsgHolder.getMessage();
        NotificationMessageHolderType.Message expectedMessage = expectedNotifMsgHolder.getMessage();
        AbsWsnbTypesAndPayloadsUnitTests.checkNotificationMessageHolderTypeMessage(expectedMessage, toCheckMessage, isDebug);
        TopicExpressionType toCheckTopic = toCheckNotifMsgHolder.getTopic();
        TopicExpressionType expectedTopic = expectedNotifMsgHolder.getTopic();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "NotificationMessageHolder have different topic \n" + "\t(-> toCheckTopic is " + (toCheckTopic != null ? "not null" : "null") + "\n\t-> expectedTopic is " + (expectedTopic != null ? "not null" : "null") + ")"), (toCheckTopic == null && expectedTopic == null || toCheckTopic != null && expectedTopic != null ? 1 : 0) != 0);
        if (toCheckTopic != null) {
            AbsWsnbTypesAndPayloadsUnitTests.checkTopicExpressionType(expectedTopic, toCheckTopic, isDebug);
        }
        EndpointReferenceType toCheckProducerRef = toCheckNotifMsgHolder.getProducerReference();
        EndpointReferenceType expectedProducerRef = expectedNotifMsgHolder.getProducerReference();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "NotificationMessageHolder have different ProducerReference  \n" + "\t(-> toCheckProducerRef is " + (toCheckProducerRef != null ? "not null" : "null") + "\n\t-> expectedProducerRef is " + (expectedProducerRef != null ? "not null" : "null") + ")"), (toCheckProducerRef == null && expectedProducerRef == null || toCheckProducerRef != null && expectedProducerRef != null ? 1 : 0) != 0);
        if (toCheckProducerRef != null) {
            AbsWsaTypesUnitTests.checkEndpointReferenceType((EndpointReferenceType)expectedProducerRef, (EndpointReferenceType)toCheckProducerRef, (String)"OASIS \"WS-BaseNotification\"", (boolean)isDebug);
        }
        EndpointReferenceType toCheckSubscriptionRef = toCheckNotifMsgHolder.getSubscriptionReference();
        EndpointReferenceType expectedSubscriptionRef = expectedNotifMsgHolder.getSubscriptionReference();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "NotificationMessageHolder have different SubscriptionReference  \n" + "\t(-> toCheckSubscriptionRef is " + (toCheckSubscriptionRef != null ? "not null" : "null") + "\n\t-> expectedSubscriptionRef is " + (expectedSubscriptionRef != null ? "not null" : "null") + ")"), (toCheckSubscriptionRef == null && expectedSubscriptionRef == null || toCheckSubscriptionRef != null && expectedSubscriptionRef != null ? 1 : 0) != 0);
        if (toCheckSubscriptionRef != null) {
            AbsWsaTypesUnitTests.checkEndpointReferenceType((EndpointReferenceType)expectedSubscriptionRef, (EndpointReferenceType)toCheckSubscriptionRef, (String)"OASIS \"WS-BaseNotification\"", (boolean)isDebug);
        }
        return true;
    }

    protected static boolean checkNotify(Notify expectedNotify, Notify toCheckNotify, boolean isDebug) {
        List toCheckNotifMessages = toCheckNotify.getNotificationMessage();
        List expectedNotifMessages = expectedNotify.getNotificationMessage();
        int expectedNotifMessagesCount = expectedNotifMessages != null ? expectedNotifMessages.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Notify payloads have different notificationMessages values\n" + "\t(-> toCheckNotify messages  count : " + (toCheckNotifMessages != null ? Integer.valueOf(toCheckNotifMessages.size()) : "none") + "\n\t-> expectedNotify messages count : " + (expectedNotifMessagesCount == -1 ? "none" : Integer.valueOf(expectedNotifMessagesCount)) + ")"), (expectedNotifMessagesCount > 0 && toCheckNotifMessages.size() == expectedNotifMessagesCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedNotifMessagesCount; ++i) {
            AbsWsnbTypesAndPayloadsUnitTests.checkNotificationMessageHolderType((NotificationMessageHolderType)expectedNotifMessages.get(i), (NotificationMessageHolderType)toCheckNotifMessages.get(i), isDebug);
        }
        return true;
    }

    protected static boolean checkRenew(Renew expectedPayload, Renew toCheckPayload, boolean isDebug) {
        Object toCheckTermTime = toCheckPayload.getTerminationTime();
        Object expectedTermTime = expectedPayload.getTerminationTime();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Renew payload have different TerminationTime \n" + "\t(-> toCheckTermTime is " + (toCheckTermTime != null ? "not null" : "null") + "\n\t-> expectedTermTime is " + (expectedTermTime != null ? "not null" : "null") + ")"), (toCheckTermTime != null && expectedTermTime != null || toCheckTermTime == null && expectedTermTime == null ? 1 : 0) != 0);
        if (toCheckTermTime != null) {
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Renew payload have different TerminationTime type\n" + "\t(-> toCheckTermTime type is " + toCheckTermTime.getClass().getSimpleName() + "\n\t-> expectedTermTime type is " + expectedTermTime.getClass().getSimpleName() + ")"), (boolean)toCheckTermTime.getClass().isInstance(expectedTermTime));
            if (toCheckTermTime instanceof Duration) {
                Duration toCheckDuration = (Duration)toCheckTermTime;
                Duration expectedDuration = (Duration)expectedTermTime;
                if (isDebug) {
                    System.out.println("[DEBUG] --> toCheckTermTime value is : " + toCheckDuration.toString() + "\n[DEBUG] --> expectedTermTime value is : " + expectedDuration.toString() + "\n");
                }
                Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Renew payload have different TerminationTime value\n" + "\t(-> toCheckTermTime value is " + toCheckDuration.toString() + "\n\t-> expectedTermTime value is " + expectedDuration.toString() + ")"), (boolean)toCheckDuration.equals(expectedDuration));
            } else if (toCheckTermTime instanceof Date) {
                Date toCheckGCal = (Date)toCheckTermTime;
                Date expectedGCal = (Date)expectedTermTime;
                if (isDebug) {
                    System.out.println("[DEBUG] --> toCheckTermTime value is : " + toCheckGCal.toString() + "\n[DEBUG] --> expectedTermTime value is : " + expectedGCal.toString() + "\n");
                }
                Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Renew payload have different TerminationTime value\n" + "\t(-> toCheckTermTime value is " + toCheckGCal.toString() + "\n\t-> expectedTermTime value is " + expectedGCal.toString() + ")"), (boolean)toCheckGCal.equals(expectedGCal));
            } else {
                Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Renew payload have unknown TerminationTime type\n" + "\t(-> type is " + toCheckTermTime.getClass().getSimpleName() + ")"));
            }
        }
        return true;
    }

    protected static boolean checkRenewResponse(RenewResponse expectedPayload, RenewResponse toCheckPayload, boolean isDebug) {
        Date toCheckTerminationTime = toCheckPayload.getTerminationTime();
        Date expectedTerminationTime = expectedPayload.getTerminationTime();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Subscribe payload have different TerminationTime \n" + "\t(-> toCheckCreationTime is " + (toCheckTerminationTime != null ? "not null" : "null") + "\n\t-> expectedCreationTime is " + (expectedTerminationTime != null ? "not null" : "null") + ")"), (toCheckTerminationTime != null && expectedTerminationTime != null ? 1 : 0) != 0);
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckTerminationTime value is : " + toCheckTerminationTime.toString() + "\n[DEBUG] --> expectedTerminationTime value is : " + expectedTerminationTime.toString() + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Subscribe payload have different InitialTerminationTime value\n" + "\t(-> toCheckTerminationTime value is " + toCheckTerminationTime.toString() + "\n\t-> expectedTerminationTime value is " + expectedTerminationTime.toString() + ")"), (boolean)toCheckTerminationTime.equals(expectedTerminationTime));
        Date toCheckCurrentTime = toCheckPayload.getCurrentTime();
        Date expectedCurrentTime = expectedPayload.getCurrentTime();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Subscribe payload have different CurrentTime \n" + "\t(-> toCheckCurrentTime is " + (toCheckCurrentTime != null ? "not null" : "null") + "\n\t-> expectedCurrentTime is " + (expectedCurrentTime != null ? "not null" : "null") + ")"), (toCheckCurrentTime == null && expectedCurrentTime == null || toCheckCurrentTime != null && expectedCurrentTime != null ? 1 : 0) != 0);
        if (toCheckCurrentTime != null) {
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckCurrentTime value is : " + toCheckCurrentTime.toString() + "\n[DEBUG] --> expectedCurrentTime value is : " + expectedCurrentTime.toString() + "\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Subscribe payload have different InitialTerminationTime value\n" + "\t(-> toCheckCurrentTime value is " + toCheckCurrentTime.toString() + "\n\t-> expectedCurrentTime value is " + expectedCurrentTime.toString() + ")"), (boolean)toCheckCurrentTime.equals(expectedCurrentTime));
        }
        return true;
    }

    protected static boolean checkSubscriptionPolicyType(SubscriptionPolicyType expectedSubsPolicy, SubscriptionPolicyType toCheckSubsPolicy, boolean isDebug) {
        List toCheckPolicies = toCheckSubsPolicy.getPolicies();
        List expectedPolicies = expectedSubsPolicy.getPolicies();
        int expectedPoliciesCount = expectedPolicies != null ? expectedPolicies.size() : -1;
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "SubscriptionPolicy have different policies content\n" + "\t(-> toCheckSubsPolicy policies  count : " + (toCheckPolicies != null ? Integer.valueOf(toCheckPolicies.size()) : "none") + "\n\t-> expectedSubsPolicy policies count : " + (expectedPoliciesCount == -1 ? "none" : Integer.valueOf(expectedPoliciesCount)) + ")"), (expectedPoliciesCount > 0 && toCheckPolicies.size() == expectedPoliciesCount ? 1 : 0) != 0);
        for (int i = 0; i < expectedPoliciesCount; ++i) {
            String toCheckPolicyEltAsString = WsaUnitTestsUtils.formatToComparison((Element)((Element)toCheckPolicies.get(i)));
            String expectedPolicyEltAsString = WsaUnitTestsUtils.formatToComparison((Element)((Element)expectedPolicies.get(i)));
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckPolicy #" + i + " (formattedToCompare) : " + toCheckPolicyEltAsString + "\n[DEBUG] --> expectedPolicy #" + i + " (formattedToCompare) : " + expectedPolicyEltAsString + "\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Message Element Content (formatted to comparison) are \n" + "\t(-> toCheckPolicy #" + i + " (formattedToCompare) : " + toCheckPolicyEltAsString + "\n\t-> expectedPolicy #" + i + " (formattedToCompare) : " + expectedPolicyEltAsString + ")"), (boolean)toCheckPolicyEltAsString.equals(expectedPolicyEltAsString));
        }
        return true;
    }

    protected static boolean checkSubscribe(Subscribe expectedSubscribe, Subscribe toCheckSubscribe, boolean isDebug) {
        EndpointReferenceType toCheckConsumerRef = toCheckSubscribe.getConsumerReference();
        EndpointReferenceType expectedConsumerRef = expectedSubscribe.getConsumerReference();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "ConsumerReference must not be null ! \n" + "\t(-> toCheckConsumerRef is " + (toCheckConsumerRef != null ? "not null" : "null") + "\n\t-> expectedConsumerRef is " + (expectedConsumerRef != null ? "not null" : "null") + ")"), (toCheckConsumerRef != null && expectedConsumerRef != null ? 1 : 0) != 0);
        AbsWsaTypesUnitTests.checkEndpointReferenceType((EndpointReferenceType)expectedConsumerRef, (EndpointReferenceType)toCheckConsumerRef, (String)"OASIS \"WS-BaseNotification\"", (boolean)isDebug);
        FilterType toCheckFilter = toCheckSubscribe.getFilter();
        FilterType expectedFilter = expectedSubscribe.getFilter();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Subscribe payload have different Filter \n" + "\t(-> toCheckFilter is " + (toCheckFilter != null ? "not null" : "null") + "\n\t-> expectedFilter is " + (expectedFilter != null ? "not null" : "null") + ")"), (toCheckFilter == null && expectedFilter == null || toCheckFilter != null && expectedFilter != null ? 1 : 0) != 0);
        if (toCheckFilter != null) {
            AbsWsnbTypesAndPayloadsUnitTests.checkFilterType(expectedFilter, toCheckFilter, isDebug);
        }
        SubscriptionPolicyType toCheckSubsPolicy = toCheckSubscribe.getSubscriptionPolicy();
        SubscriptionPolicyType expectedSubsPolicy = expectedSubscribe.getSubscriptionPolicy();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Subscribe payload have different SubscriptionPolicy \n" + "\t(-> toCheckSubsPolicy is " + (toCheckSubsPolicy != null ? "not null" : "null") + "\n\t-> expectedSubsPolicy is " + (expectedSubsPolicy != null ? "not null" : "null") + ")"), (toCheckSubsPolicy == null && expectedSubsPolicy == null || toCheckSubsPolicy != null && expectedSubsPolicy != null ? 1 : 0) != 0);
        if (toCheckSubsPolicy != null) {
            AbsWsnbTypesAndPayloadsUnitTests.checkSubscriptionPolicyType(expectedSubsPolicy, toCheckSubsPolicy, isDebug);
        }
        Object toCheckInitTermTime = toCheckSubscribe.getInitialTerminationTime();
        Object expectedInitTermTime = expectedSubscribe.getInitialTerminationTime();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Subscribe payload have different InitialTerminationTime \n" + "\t(-> toCheckInitTermTime is " + (toCheckInitTermTime != null ? "not null" : "null") + "\n\t-> expectedInitTermTime is " + (expectedInitTermTime != null ? "not null" : "null") + ")"), (toCheckInitTermTime == null && expectedInitTermTime == null || toCheckInitTermTime != null && expectedInitTermTime != null ? 1 : 0) != 0);
        if (toCheckInitTermTime != null) {
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Subscribe payload have different InitialTerminationTime type\n" + "\t(-> toCheckInitTermTime type is " + toCheckInitTermTime.getClass().getSimpleName() + "\n\t-> expectedInitTermTime type is " + expectedInitTermTime.getClass().getSimpleName() + ")"), (boolean)toCheckInitTermTime.getClass().isInstance(expectedInitTermTime));
            if (toCheckInitTermTime instanceof Duration) {
                Duration toCheckDuration = (Duration)toCheckInitTermTime;
                Duration expectedDuration = (Duration)expectedInitTermTime;
                if (isDebug) {
                    System.out.println("[DEBUG] --> toCheckInitTermTime value is : " + toCheckDuration.toString() + "\n[DEBUG] --> expectedInitTermTime value is : " + expectedDuration.toString() + "\n");
                }
                Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Subscribe payload have different InitialTerminationTime value\n" + "\t(-> toCheckInitTermTime value is " + toCheckDuration.toString() + "\n\t-> expectedInitTermTime value is " + expectedDuration.toString() + ")"), (boolean)toCheckDuration.equals(expectedDuration));
            } else if (toCheckInitTermTime instanceof Date) {
                Date toCheckGCal = (Date)toCheckInitTermTime;
                Date expectedGCal = (Date)expectedInitTermTime;
                if (isDebug) {
                    System.out.println("[DEBUG] --> toCheckInitTermTime value is : " + toCheckGCal.toString() + "\n[DEBUG] --> expectedInitTermTime value is : " + expectedGCal.toString() + "\n");
                }
                Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Subscribe payload have different InitialTerminationTime value\n" + "\t(-> toCheckInitTermTime value is " + toCheckGCal.toString() + "\n\t-> expectedInitTermTime value is " + expectedGCal.toString() + ")"), (boolean)toCheckGCal.equals(expectedGCal));
            } else {
                Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Subscribe payload have unknown InitialTerminationTime type\n" + "\t(-> type is " + toCheckInitTermTime.getClass().getSimpleName() + ")"));
            }
        }
        return true;
    }

    protected static boolean checkSubscriptionManagerRP(SubscriptionManagerRP expectedSubscription, SubscriptionManagerRP toCheckSubscription, boolean isDebug) {
        EndpointReferenceType toCheckConsumerRef = toCheckSubscription.getConsumerReference();
        EndpointReferenceType expectedConsumerRef = expectedSubscription.getConsumerReference();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "ConsumerReference must not be null ! \n" + "\t(-> toCheckConsumerRef is " + (toCheckConsumerRef != null ? "not null" : "null") + "\n\t-> expectedConsumerRef is " + (expectedConsumerRef != null ? "not null" : "null") + ")"), (toCheckConsumerRef != null && expectedConsumerRef != null ? 1 : 0) != 0);
        AbsWsaTypesUnitTests.checkEndpointReferenceType((EndpointReferenceType)expectedConsumerRef, (EndpointReferenceType)toCheckConsumerRef, (String)"OASIS \"WS-BaseNotification\"", (boolean)isDebug);
        FilterType toCheckFilter = toCheckSubscription.getFilter();
        FilterType expectedFilter = expectedSubscription.getFilter();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Subscription have different Filter \n" + "\t(-> toCheckFilter is " + (toCheckFilter != null ? "not null" : "null") + "\n\t-> expectedFilter is " + (expectedFilter != null ? "not null" : "null") + ")"), (toCheckFilter == null && expectedFilter == null || toCheckFilter != null && expectedFilter != null ? 1 : 0) != 0);
        if (toCheckFilter != null) {
            AbsWsnbTypesAndPayloadsUnitTests.checkFilterType(expectedFilter, toCheckFilter, isDebug);
        }
        SubscriptionPolicyType toCheckSubsPolicy = toCheckSubscription.getSubscriptionPolicy();
        SubscriptionPolicyType expectedSubsPolicy = expectedSubscription.getSubscriptionPolicy();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Subscription have different SubscriptionPolicy \n" + "\t(-> toCheckSubsPolicy is " + (toCheckSubsPolicy != null ? "not null" : "null") + "\n\t-> expectedSubsPolicy is " + (expectedSubsPolicy != null ? "not null" : "null") + ")"), (toCheckSubsPolicy == null && expectedSubsPolicy == null || toCheckSubsPolicy != null && expectedSubsPolicy != null ? 1 : 0) != 0);
        if (toCheckSubsPolicy != null) {
            AbsWsnbTypesAndPayloadsUnitTests.checkSubscriptionPolicyType(expectedSubsPolicy, toCheckSubsPolicy, isDebug);
        }
        Date toCheckCreationTime = toCheckSubscription.getCreationTime();
        Date expectedCreationTime = expectedSubscription.getCreationTime();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Subscription have different CreationTime \n" + "\t(-> toCheckCreationTime is " + (toCheckCreationTime != null ? "not null" : "null") + "\n\t-> expectedCreationTime is " + (expectedCreationTime != null ? "not null" : "null") + ")"), (toCheckCreationTime == null && expectedCreationTime == null || toCheckCreationTime != null && expectedCreationTime != null ? 1 : 0) != 0);
        if (toCheckCreationTime != null) {
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckCreationTime value is : " + toCheckCreationTime.toString() + "\n[DEBUG] --> expectedCreationTime value is : " + expectedCreationTime.toString() + "\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Subscription have different CreationTime value\n" + "\t(-> toCheckCreationTime value is " + toCheckCreationTime.toString() + "\n\t-> expectedCreationTime value is " + expectedCreationTime.toString() + ")"), (boolean)toCheckCreationTime.equals(expectedCreationTime));
        }
        return true;
    }

    protected static boolean checkSubscribeResponse(SubscribeResponse expectedSubscribeResponse, SubscribeResponse toCheckSubscribeResponse, boolean isDebug) {
        EndpointReferenceType toCheckSubscriptionRef = toCheckSubscribeResponse.getSubscriptionReference();
        EndpointReferenceType expectedSubscriptionRef = expectedSubscribeResponse.getSubscriptionReference();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "SubscriptionReference must not be null ! \n" + "\t(-> toCheckSubscriptionRef is " + (toCheckSubscriptionRef != null ? "not null" : "null") + "\n\t-> expectedSubscriptionRef is " + (expectedSubscriptionRef != null ? "not null" : "null") + ")"), (toCheckSubscriptionRef != null && expectedSubscriptionRef != null ? 1 : 0) != 0);
        AbsWsaTypesUnitTests.checkEndpointReferenceType((EndpointReferenceType)expectedSubscriptionRef, (EndpointReferenceType)toCheckSubscriptionRef, (String)"OASIS \"WS-BaseNotification\"", (boolean)isDebug);
        Date toCheckGCal = toCheckSubscribeResponse.getCurrentTime();
        Date expectedGCal = expectedSubscribeResponse.getCurrentTime();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "SubscribeResponse payload have different CurrentTime \n" + "\t(-> toCheckCurrentTime is " + (toCheckGCal != null ? "not null" : "null") + "\n\t-> expectedCurrentTime is " + (expectedGCal != null ? "not null" : "null") + ")"), (toCheckGCal == null && expectedGCal == null || toCheckGCal != null && expectedGCal != null ? 1 : 0) != 0);
        if (toCheckGCal != null) {
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckCurrentTime value is : " + toCheckGCal.toString() + "\n[DEBUG] --> expectedCurrentTime value is : " + expectedGCal.toString() + "\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "SubscribeResponse payload have different CurrentTime value\n" + "\t(-> toCheckCurrentTime value is " + toCheckGCal.toString() + "\n\t-> expectedCurrentTime value is " + expectedGCal.toString() + ")"), (boolean)toCheckGCal.equals(expectedGCal));
        }
        toCheckGCal = toCheckSubscribeResponse.getTerminationTime();
        expectedGCal = expectedSubscribeResponse.getTerminationTime();
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "SubscribeResponse payload have different TerminationTime \n" + "\t(-> toCheckTerminationTime is " + (toCheckGCal != null ? "not null" : "null") + "\n\t-> expectedTerminationTime is " + (expectedGCal != null ? "not null" : "null") + ")"), (toCheckGCal == null && expectedGCal == null || toCheckGCal != null && expectedGCal != null ? 1 : 0) != 0);
        if (toCheckGCal != null) {
            if (isDebug) {
                System.out.println("[DEBUG] --> toCheckTerminationTime value is : " + toCheckGCal.toString() + "\n[DEBUG] --> expectedTerminationTime value is : " + expectedGCal.toString() + "\n");
            }
            Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "SubscribeResponse payload have different TerminationTime value\n" + "\t(-> toCheckTerminationTime value is " + toCheckGCal.toString() + "\n\t-> expectedTerminationTime value is " + expectedGCal.toString() + ")"), (boolean)toCheckGCal.equals(expectedGCal));
        }
        return true;
    }

    protected static boolean checkUnsubscribe(Unsubscribe expectedUnsubscribe, Unsubscribe toCheckUnsubscribe, boolean isDebug) {
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckUnsubscribe : " + (toCheckUnsubscribe != null ? toCheckUnsubscribe.toString() : "null") + "\n[DEBUG] --> expectedUnsubscribe : " + (expectedUnsubscribe != null ? expectedUnsubscribe.toString() : "null") + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "Unsubscribe are \n" + "\t(-> toCheckUnsubscribe : " + (toCheckUnsubscribe != null ? toCheckUnsubscribe.toString() : "null") + "\n\t-> expectedUnsubscribe : " + (expectedUnsubscribe != null ? expectedUnsubscribe.toString() : "null") + ")"), (toCheckUnsubscribe != null && expectedUnsubscribe != null ? 1 : 0) != 0);
        return true;
    }

    protected static boolean checkUnsubscribeResponse(UnsubscribeResponse expectedUnsubscribeResponse, UnsubscribeResponse toCheckUnsubscribeResponse, boolean isDebug) {
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckUnsubscribeResponse : " + (toCheckUnsubscribeResponse != null ? toCheckUnsubscribeResponse.toString() : "null") + "\n[DEBUG] --> expectedUnsubscribeResponse : " + (expectedUnsubscribeResponse != null ? expectedUnsubscribeResponse.toString() : "null") + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "UnsubscribeResponse are \n" + "\t(-> toCheckUnsubscribeResponse : " + (toCheckUnsubscribeResponse != null ? toCheckUnsubscribeResponse.toString() : "null") + "\n\t-> expectedUnsubscribeResponse : " + (expectedUnsubscribeResponse != null ? expectedUnsubscribeResponse.toString() : "null") + ")"), (toCheckUnsubscribeResponse != null && expectedUnsubscribeResponse != null ? 1 : 0) != 0);
        return true;
    }

    protected static boolean checkUseRaw(UseRaw expectedUseRaw, UseRaw toCheckUseRaw, boolean isDebug) {
        if (isDebug) {
            System.out.println("[DEBUG] --> toCheckUseRaw : " + (toCheckUseRaw != null ? toCheckUseRaw.toString() : "null") + "\n[DEBUG] --> expectedUseRaw : " + (expectedUseRaw != null ? expectedUseRaw.toString() : "null") + "\n");
        }
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "UseRaw are \n" + "\t(-> toCheckUseRaw : " + (toCheckUseRaw != null ? toCheckUseRaw.toString() : "null") + "\n\t-> expectedUseRaw : " + (expectedUseRaw != null ? expectedUseRaw.toString() : "null") + ")"), (toCheckUseRaw != null && expectedUseRaw != null ? 1 : 0) != 0);
        return true;
    }

    @Test
    public final void testCreateWriteAsDOMReadGetCurrentMessage() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM GetCurrentMessage\" ~~~~~~~ \n");
        GetCurrentMessage payload = null;
        try {
            TopicExpressionType concreteTopic = this.factory.createTopicExpressionType(WstopConstants.CONCRETE_TOPIC_EXPRESSION_DIALECT_URI);
            concreteTopic.addTopicNamespace("sensor", new URI("http://www.scneiderElectric/sensor"));
            concreteTopic.setContent("sensor:outside/thermal");
            payload = this.factory.createGetCurrentMessage(concreteTopic);
        }
        catch (URISyntaxException e1) {
            throw new WsnbException((Throwable)e1);
        }
        Document payloadAsDOM = this.writer.writeGetCurrentMessageAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsnbUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", GetCurrentMessage.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        GetCurrentMessage readGetCurrentMessage = this.reader.readGetCurrentMessage(payloadAsDOM);
        AbsWsnbTypesAndPayloadsUnitTests.checkGetCurrentMessage(payload, readGetCurrentMessage, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM GetCurrentMessage\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadGetCurrentMessageResponse() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM GetCurrentMessageResponse\" ~~~~~~~ \n");
        Document defaultDoc = this.createDefaultDocument("http://default/test/uri");
        Element msgElt = defaultDoc.createElementNS("http://www.schneider-electric.org/sensor", "SensorCapture");
        msgElt.setPrefix("npex");
        Element child1 = defaultDoc.createElement("Temperature");
        child1.setNodeValue("38\u00b0C");
        msgElt.appendChild(child1);
        Element child2 = defaultDoc.createElement("Humidity");
        child2.setNodeValue("12%");
        msgElt.appendChild(child2);
        NotificationMessageHolderType.Message msg = this.factory.createNotificationMessageHolderTypeMessage(msgElt);
        GetCurrentMessageResponse payload = this.factory.createGetCurrentMessageResponse(msg);
        Document payloadAsDOM = this.writer.writeGetCurrentMessageResponseAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsnbUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", GetCurrentMessageResponse.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        GetCurrentMessageResponse readGetCurrentMessageResponse = this.reader.readGetCurrentMessageResponse(payloadAsDOM);
        AbsWsnbTypesAndPayloadsUnitTests.checkGetCurrentMessageResponse(payload, readGetCurrentMessageResponse, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM GetCurrentMessageResponse\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadTopicExpressionType() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM TopicExpressionType\" ~~~~~~~ \n");
        TopicExpressionType topicExpression = this.factory.createTopicExpressionType(WstopConstants.XPATH_TOPIC_EXPRESSION_DIALECT_URI);
        topicExpression.setContent("tns1:rootTopic/*/grandChildTopic1");
        try {
            topicExpression.addTopicNamespace("tns1", new URI("http://default/namespace/for/topic"));
        }
        catch (URISyntaxException e1) {
            throw new WsnbException((Throwable)e1);
        }
        Document topicExpressionAsDOM = this.writer.writeTopicExpressionTypeAsDOM(topicExpression);
        try {
            WsaUnitTestsUtils.validateResult((Document)topicExpressionAsDOM, (String[])WsnbUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", TopicExpressionType.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        TopicExpressionType readTopicExpressionType = this.reader.readTopicExpressionType(topicExpressionAsDOM);
        AbsWsnbTypesAndPayloadsUnitTests.checkTopicExpressionType(topicExpression, readTopicExpressionType, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM TopicExpressionType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadMessageContentExpression() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM MessageContentExpression\" ~~~~~~~ \n");
        MessageContentExpression msgContentExpression = this.factory.createMessageContentExpression(WstopConstants.XPATH_TOPIC_EXPRESSION_DIALECT_URI);
        msgContentExpression.setContent("/data/temperature[external>35]");
        Document msgContentExpressionAsDOM = this.writer.writeMessageContentExpressionAsDOM(msgContentExpression);
        try {
            WsaUnitTestsUtils.validateResult((Document)msgContentExpressionAsDOM, (String[])WsnbUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", QueryExpressionType.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        MessageContentExpression readMsgContentExpression = this.reader.readMessageContentExpression(msgContentExpressionAsDOM);
        AbsWsnbTypesAndPayloadsUnitTests.checkMessageContentExpression(msgContentExpression, readMsgContentExpression, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM MessageContentExpression\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadProducerPropertiesExpression() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM ProducerPropertiesExpression\" ~~~~~~~ \n");
        ProducerPropertiesExpression prodPropertiesExpression = this.factory.createProducerPropertiesExpression(WstopConstants.XPATH_TOPIC_EXPRESSION_DIALECT_URI);
        prodPropertiesExpression.setContent("*//identity[name=\"External Sensor\"]");
        Document prodPropertiesExpressionAsDOM = this.writer.writeProducerPropertiesExpressionAsDOM(prodPropertiesExpression);
        try {
            WsaUnitTestsUtils.validateResult((Document)prodPropertiesExpressionAsDOM, (String[])WsnbUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", QueryExpressionType.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        ProducerPropertiesExpression readMsgContentExpression = this.reader.readProducerPropertiesExpression(prodPropertiesExpressionAsDOM);
        AbsWsnbTypesAndPayloadsUnitTests.checkProducerPropertiesExpression(prodPropertiesExpression, readMsgContentExpression, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM ProducerPropertiesExpression\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMReadFilterType() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM FilterType\" ~~~~~~~ \n");
        FilterType filter = this.createDefaultFilter();
        Document filterAsDOM = this.writer.writeFilterTypeAsDOM(filter);
        try {
            WsaUnitTestsUtils.validateResult((Document)filterAsDOM, (String[])WsnbUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", FilterType.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        FilterType readFilter = this.reader.readFilterType(filterAsDOM);
        AbsWsnbTypesAndPayloadsUnitTests.checkFilterType(filter, readFilter, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM FilterType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMNotify() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM Notify \" ~~~~~~~ \n");
        Document defaultDoc = this.createDefaultDocument("http://default/test/uri");
        Element msgElt = defaultDoc.createElement("SensorCapture");
        Element child1 = defaultDoc.createElement("Temperature");
        child1.setNodeValue("38\u00b0C");
        msgElt.appendChild(child1);
        Element child2 = defaultDoc.createElement("Humidity");
        child2.setNodeValue("12%");
        msgElt.appendChild(child2);
        NotificationMessageHolderType.Message msg = this.factory.createNotificationMessageHolderTypeMessage(msgElt);
        NotificationMessageHolderType notifMsg = this.factory.createNotificationMessageHolderType(msg);
        try {
            TopicExpressionType concreteTopic = this.factory.createTopicExpressionType(WstopConstants.CONCRETE_TOPIC_EXPRESSION_DIALECT_URI);
            concreteTopic.addTopicNamespace("sensor", new URI("http://www.scneiderElectric/sensor"));
            concreteTopic.setContent("sensor:outside/thermal");
            notifMsg.setTopic(concreteTopic);
        }
        catch (URISyntaxException e1) {
            throw new WsnbException((Throwable)e1);
        }
        try {
            EndpointReferenceType subscriptionRef = WsnbUnitTestsUtils.createDefaultWsnSubscriptionReference();
            notifMsg.setSubscriptionReference(subscriptionRef);
        }
        catch (Exception e1) {
            throw new WsnbException((Throwable)e1);
        }
        try {
            EndpointReferenceType producerRef = WsnbUnitTestsUtils.createDefaultWsnProducerOriginator();
            notifMsg.setProducerReference(producerRef);
        }
        catch (URISyntaxException e1) {
            throw new WsnbException((Throwable)e1);
        }
        Notify payload = this.factory.createNotify(notifMsg);
        Document payloadAsDOM = this.writer.writeNotifyAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsnbUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", Notify.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        Notify readPayload = this.reader.readNotify(payloadAsDOM);
        AbsWsnbTypesAndPayloadsUnitTests.checkNotify(payload, readPayload, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM Notify \" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    public final void genericCreateWriteAsDOMRenew(Object terminationTime) throws WsnbException {
        Renew payload = this.factory.createRenew();
        if (terminationTime instanceof Duration) {
            payload.setTerminationTime((Duration)terminationTime);
        } else {
            payload.setTerminationTime((Date)terminationTime);
        }
        Document payloadAsDOM = this.writer.writeRenewAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsnbUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", Renew.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        Renew readRenew = this.reader.readRenew(payloadAsDOM);
        AbsWsnbTypesAndPayloadsUnitTests.checkRenew(payload, readRenew, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
    }

    @Test
    public final void testCreateWriteAsDOMRenewWithDuration() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM Renew with Duration\" ~~~~~~~ \n");
        try {
            this.genericCreateWriteAsDOMRenew(DatatypeFactory.newInstance().newDuration(0x6DDD00L));
        }
        catch (DatatypeConfigurationException e) {
            throw new WsnbException((Throwable)e);
        }
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM Renew with Duration\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMRenewWithDate() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM Renew with Date\" ~~~~~~~ \n");
        GregorianCalendar gCal = new GregorianCalendar();
        gCal.add(10, 3);
        this.genericCreateWriteAsDOMRenew(gCal.getTime());
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM Renew with Date\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMRenewResponse() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM RenewResponse\" ~~~~~~~ \n");
        GregorianCalendar gCal = new GregorianCalendar();
        Date currentTime = gCal.getTime();
        gCal.add(10, 2);
        Date termTime = gCal.getTime();
        RenewResponse payload = this.factory.createRenewResponse(termTime);
        payload.setCurrentTime(currentTime);
        Document payloadAsDOM = this.writer.writeRenewResponseAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsnbUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", RenewResponse.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        RenewResponse readPayload = this.reader.readRenewResponse(payloadAsDOM);
        AbsWsnbTypesAndPayloadsUnitTests.checkRenewResponse(payload, readPayload, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM RenewResponse\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    public final void genericCreateWriteAsDOMSubscribe(Object initTerminationTime) throws WsnbException {
        EndpointReferenceType consumerRef = null;
        try {
            consumerRef = WsnbUnitTestsUtils.createDefaultWsnConsumerOriginator();
        }
        catch (URISyntaxException e1) {
            throw new WsnbException((Throwable)e1);
        }
        Subscribe payload = this.factory.createSubscribe(consumerRef);
        payload.setFilter(this.createDefaultFilter());
        if (initTerminationTime instanceof Duration) {
            payload.setInitialTerminationTime((Duration)initTerminationTime);
        } else {
            payload.setInitialTerminationTime((Date)initTerminationTime);
        }
        SubscriptionPolicyType policy = this.factory.createSubscriptionPolicyType();
        Document defaultDoc = this.createDefaultDocument("http://defauturi/for/policy");
        Element policyAsElt = defaultDoc.createElement("CustomPolicy");
        Element child1 = defaultDoc.createElement("NotifFrequency");
        child1.setNodeValue("1 per minute max");
        policyAsElt.appendChild(child1);
        policy.addPolicy(policyAsElt);
        payload.setSubscriptionPolicy(policy);
        Document payloadAsDOM = this.writer.writeSubscribeAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsnbUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", Subscribe.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        Subscribe readPayload = this.reader.readSubscribe(payloadAsDOM);
        AbsWsnbTypesAndPayloadsUnitTests.checkSubscribe(payload, readPayload, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
    }

    @Test
    public final void testCreateWriteAsDOMSubscribeWithDuration() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM Subscribe with Duration \" ~~~~~~~ \n");
        try {
            this.genericCreateWriteAsDOMSubscribe(DatatypeFactory.newInstance().newDuration(3600000L));
        }
        catch (DatatypeConfigurationException e) {
            throw new WsnbException((Throwable)e);
        }
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM Subscribe with Duration\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMSubscribeWithDate() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM Subscribe with Date \" ~~~~~~~ \n");
        GregorianCalendar gCal = new GregorianCalendar();
        gCal.add(10, 2);
        this.genericCreateWriteAsDOMSubscribe(gCal.getTime());
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM Subscribe with Date\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMSubscriptionManagerRP() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM SubscriptionManagerRP\" ~~~~~~~ \n");
        SubscriptionManagerRP subscription = this.createDefaultSubscriptionManagerRP();
        Document subscriptionAsDOM = this.writer.writeSubscriptionManagerRPAsDOM(subscription);
        try {
            WsaUnitTestsUtils.validateResult((Document)subscriptionAsDOM, (String[])WsnbUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", SubscriptionManagerRP.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        SubscriptionManagerRP readSubscription = this.reader.readSubscriptionManagerRP(subscriptionAsDOM);
        AbsWsnbTypesAndPayloadsUnitTests.checkSubscriptionManagerRP(subscription, readSubscription, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM SubscriptionManagerRP \" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteToFSReadFromFSEnpointReferenceType() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-Filesystem and read-from-Filesystem SubscriptionManagerRP\" ~~~~~~~ \n");
        File persistenceRepository = WsaUnitTestsUtils.createTempTestDirectory((String)"SaveSubscriptions");
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "the persistence directory has not been found on filesystem !"), (persistenceRepository.exists() && persistenceRepository.isDirectory() ? 1 : 0) != 0);
        SubscriptionManagerRP defaultSubscription = this.createDefaultSubscriptionManagerRP();
        String subscriptionFileName = "subscription-" + UUID.randomUUID().toString();
        this.writer.writeSubscriptionManagerRPToFilesystem(defaultSubscription, persistenceRepository.getAbsolutePath() + File.separatorChar + subscriptionFileName);
        File subscriptionAsFile = new File(persistenceRepository.getAbsolutePath() + File.separatorChar + subscriptionFileName);
        Assert.assertTrue((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + "The subscription has not been written on Filesystem\n" + "\tNo file named \"" + subscriptionFileName + "\" has been found"), (subscriptionAsFile.exists() && subscriptionAsFile.length() > 0L ? 1 : 0) != 0);
        System.out.println("\t Unit Test Step 1 (\"create\" and \"write to Filesystem\") passed !\n");
        SubscriptionManagerRP readSubscription = this.reader.readSubscriptionManagerRP(subscriptionAsFile);
        AbsWsnbTypesAndPayloadsUnitTests.checkSubscriptionManagerRP(defaultSubscription, readSubscription, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from Filesystem\") passed !");
        if (!this.isDebug) {
            WsaUnitTestsUtils.deleteExistingTestDirectory((File)persistenceRepository);
        }
        System.out.println("\n\t OK, unit test \"Create, Write-to-Filesystem and read-from-Filesystem SubscriptionManagerRP\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMSubscribeResponse() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM SubscribeResponse\" ~~~~~~~ \n");
        EndpointReferenceType subscriptionRef = null;
        try {
            subscriptionRef = WsnbUnitTestsUtils.createDefaultWsnSubscriptionReference();
        }
        catch (Exception e1) {
            throw new WsnbException((Throwable)e1);
        }
        SubscribeResponse payload = this.factory.createSubscribeResponse(subscriptionRef);
        GregorianCalendar gCal = new GregorianCalendar();
        Date currentTime = gCal.getTime();
        payload.setCurrentTime(currentTime);
        gCal.add(10, 2);
        Date termTime = gCal.getTime();
        payload.setTerminationTime(termTime);
        Document payloadAsDOM = this.writer.writeSubscribeResponseAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsnbUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", SubscribeResponse.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        SubscribeResponse readPayload = this.reader.readSubscribeResponse(payloadAsDOM);
        AbsWsnbTypesAndPayloadsUnitTests.checkSubscribeResponse(payload, readPayload, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM SubscribeResponse \" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMUnsubscribe() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM Unsubscribe\" ~~~~~~~ \n");
        Unsubscribe payload = this.factory.createUnsubscribe();
        Document payloadAsDOM = this.writer.writeUnsubscribeAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsnbUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", Unsubscribe.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        Unsubscribe readPayload = this.reader.readUnsubscribe(payloadAsDOM);
        AbsWsnbTypesAndPayloadsUnitTests.checkUnsubscribe(payload, readPayload, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM Unsubscribe\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMUnsubscribeResponse() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM UnsubscribeResponse\" ~~~~~~~ \n");
        UnsubscribeResponse payload = this.factory.createUnsubscribeResponse();
        Document payloadAsDOM = this.writer.writeUnsubscribeResponseAsDOM(payload);
        try {
            WsaUnitTestsUtils.validateResult((Document)payloadAsDOM, (String[])WsnbUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", UnsubscribeResponse.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        UnsubscribeResponse readPayload = this.reader.readUnsubscribeResponse(payloadAsDOM);
        AbsWsnbTypesAndPayloadsUnitTests.checkUnsubscribeResponse(payload, readPayload, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM UnsubscribeResponse\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }

    @Test
    public final void testCreateWriteAsDOMUseRaw() throws WsnbException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM UseRaw\" ~~~~~~~ \n");
        UseRaw useRaw = this.factory.createUseRaw();
        Document useRawAsDOM = this.writer.writeUseRawAsDOM(useRaw);
        try {
            WsaUnitTestsUtils.validateResult((Document)useRawAsDOM, (String[])WsnbUnitTestsUtils.WSN_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-BaseNotification\"", UseRaw.class, (boolean)this.isDebug);
            System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
        }
        catch (SAXException e) {
            Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-BaseNotification\"") + e.getMessage()));
        }
        UseRaw readUseRaw = this.reader.readUseRaw(useRawAsDOM);
        AbsWsnbTypesAndPayloadsUnitTests.checkUseRaw(useRaw, readUseRaw, this.isDebug);
        System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
        System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM UseRaw\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
    }
}

