package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.XMLConstants;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.WsnbConstants;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.CreatePullPoint;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.CreatePullPointResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.DestroyPullPoint;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.DestroyPullPointResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.FilterType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetMessages;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetMessagesResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.InvalidFilterFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.InvalidMessageContentExpressionFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.InvalidProducerPropertiesExpressionFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.InvalidTopicExpressionFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.MessageContentExpression;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.MultipleTopicsSpecifiedFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NoCurrentMessageOnTopicFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationProducerRP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotifyMessageNotSupportedFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.PauseFailedFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.PauseSubscription;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.PauseSubscriptionResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.ProducerPropertiesExpression;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Renew;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.RenewResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.ResumeFailedFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.ResumeSubscription;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.ResumeSubscriptionResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeCreationFailedFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscriptionManagerRP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscriptionPolicyType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionDialectUnknownFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicExpressionType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.TopicNotSupportedFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnableToCreatePullPointFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnableToDestroyPullPointFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnableToDestroySubscriptionFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnableToGetMessagesFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnacceptableInitialTerminationTimeFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnacceptableTerminationTimeFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnrecognizedPolicyRequestFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Unsubscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnsupportedPolicyRequestFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UseRaw;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.WsnbReader;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbFilterType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbGetCurrentMessage;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbGetCurrentMessageResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbInvalidFilterFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbInvalidMessageContentExpressionFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbInvalidProducerPropertiesExpressionFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbInvalidTopicExpressionFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbMultipleTopicsSpecifiedFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNoCurrentMessageOnTopicFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationMessageHolderType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotificationProducerRP;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotify;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbNotifyMessageNotSupportedFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbPauseFailedFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbQueryExpressionType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbRenew;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbRenewResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbResumeFailedFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeCreationFailedFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscriptionManagerRP;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbSubscriptionPolicyType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbTopicExpressionDialectUnknownFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbTopicExpressionType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbTopicNotSupportedFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnableToCreatePullPointFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnableToDestroyPullPointFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnableToDestroySubscriptionFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnableToGetMessagesFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnacceptableInitialTerminationTimeFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnacceptableTerminationTimeFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnrecognizedPolicyRequestFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribe;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsubscribeResponse;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUnsupportedPolicyRequestFaultType;
import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUseRaw;

public class WsnbReaderImpl implements WsnbReader {

	private WsnbJAXBContext wsnbJaxbContext = null;
	//private Logger logger = Logger.getLogger(WsnbReaderImpl.class.getName());
		
	/**
	 * Default constructor
	 */
	protected WsnbReaderImpl() {
		this.wsnbJaxbContext = WsnbJAXBContext.getInstance();
	}
	protected WsnbReaderImpl(String[] nsAndPrefixForMarshalling) {
		this.wsnbJaxbContext = WsnbJAXBContext.getInstance(nsAndPrefixForMarshalling);
	}
	
	@Override
	public final CreatePullPoint readCreatePullPoint(Document document)
			throws WsnbException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public final CreatePullPointResponse readCreatePullPointResponse(Document document)
			throws WsnbException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public final DestroyPullPoint readDestroyPullPoint(Document document)
			throws WsnbException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public final DestroyPullPointResponse readDestroyPullPointResponse(
			Document document) throws WsnbException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public final FilterType readFilterType(Document document) throws WsnbException {
		FilterType result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();
			
			// Save additional namespaces present on TopicExpression nodes
            List<List<String[]>> additionalTopicNSs = new ArrayList<List<String[]>>();
            
            NodeList topicExpressionNodes = document.getDocumentElement().getElementsByTagNameNS(
            		WsnbConstants.TOPIC_EXPRESSION_QNAME.getNamespaceURI(),
            		WsnbConstants.TOPIC_EXPRESSION_QNAME.getLocalPart());
            
            Element currentTopicExpressionAsElt = null;
            for (int i = 0; i < topicExpressionNodes.getLength(); i++) {
            	currentTopicExpressionAsElt = (Element) topicExpressionNodes.item(i);            	
            	additionalTopicNSs.add(this.getAdditionalNamespacesFromDom(currentTopicExpressionAsElt));
            }

            // ------- unmarshall ------
            final JAXBElement<EJaxbFilterType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbFilterType.class);
			result = new FilterTypeImpl(schemaBinding.getValue());
			
			// Trick : add previously saved namespaces to the created JaxB model
            // (will be used on the write process)         
//			List<TopicExpressionType> topicExpressions = result.getTopicExpressions();
//			if (topicExpressions!= null){
//				for (TopicExpressionType topicExpressionItem : topicExpressions) {
//					for (String[] currentNs : additionalTopicNSs.get(topicExpressions.indexOf(topicExpressionItem))) {
//						topicExpressionItem.addTopicNamespace(currentNs[0], new URI(currentNs[1]));
//					}
//				}				
//			}
		} catch (JAXBException e) {			
			throw new WsnbException(e);
		} 
//		catch (URISyntaxException e) {
//			throw new WsnbException(e);
//		} 		
		return result;
	}

	@Override
	public final GetCurrentMessage readGetCurrentMessage(Document document)
	throws WsnbException {
		GetCurrentMessage result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// Save additional namespaces present on Topic nodes
			List<String[]> additionalTopicNs = new ArrayList<String[]>();
			NodeList topicNodes = document.getDocumentElement().getElementsByTagNameNS(
					WsnbConstants.TOPIC_QNAME.getNamespaceURI(),
					WsnbConstants.TOPIC_QNAME.getLocalPart());

			if (topicNodes != null && topicNodes.getLength() ==1){
				Element topicNode = (Element)topicNodes.item(0);
				additionalTopicNs.addAll(this.getAdditionalNamespacesFromDom(topicNode));
			}

			// Unmarshall to Java Object
			final JAXBElement<EJaxbGetCurrentMessage> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbGetCurrentMessage.class);
			result = new GetCurrentMessageImpl(schemaBinding.getValue());

			// Trick : add previously saved namespaces to the created JaxB model
			// (will be used on the write process)     			
//			if (additionalTopicNs != null){
//				for (String[] currentNs : additionalTopicNs) {
//					result.getTopic().addTopicNamespace(currentNs[0], new URI(currentNs[1]));
//				}
//			}
		} catch (JAXBException e) {			
			throw new WsnbException(e);
		} 
//		catch (URISyntaxException e) {
//			throw new WsnbException(e);
//		}                   		
		return result;
	}

	@Override
	public final GetCurrentMessageResponse readGetCurrentMessageResponse(
			Document document) throws WsnbException {
		GetCurrentMessageResponse result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();
			// Unmarshall to Java Object
			final JAXBElement<EJaxbGetCurrentMessageResponse> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbGetCurrentMessageResponse.class);
			result = new GetCurrentMessageResponseImpl(schemaBinding.getValue());

		} catch (JAXBException e) {			
			throw new WsnbException(e);
		}                   		
		return result;
	}

	@Override
	public final GetMessages readGetMessages(Document document) throws WsnbException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public final GetMessagesResponse readGetMessagesResponse(Document document)
			throws WsnbException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public final InvalidFilterFaultType readInvalidFilterFaultType(Document document)
			throws WsnbException {
		InvalidFilterFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbInvalidFilterFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbInvalidFilterFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new InvalidFilterFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final InvalidMessageContentExpressionFaultType readInvalidMessageContentExpressionFaultType(
			Document document) throws WsnbException {
		InvalidMessageContentExpressionFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbInvalidMessageContentExpressionFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbInvalidMessageContentExpressionFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new InvalidMessageContentExpressionFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final InvalidProducerPropertiesExpressionFaultType readInvalidProducerPropertiesExpressionFaultType(
			Document document) throws WsnbException {
		InvalidProducerPropertiesExpressionFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbInvalidProducerPropertiesExpressionFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbInvalidProducerPropertiesExpressionFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new InvalidProducerPropertiesExpressionFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final InvalidTopicExpressionFaultType readInvalidTopicExpressionFaultType(
			Document document) throws WsnbException {
		InvalidTopicExpressionFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbInvalidTopicExpressionFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbInvalidTopicExpressionFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new InvalidTopicExpressionFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final MessageContentExpression readMessageContentExpression(Document document)
			throws WsnbException {
		MessageContentExpression result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();
						
            final JAXBElement<EJaxbQueryExpressionType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbQueryExpressionType.class);
			result = new MessageContentExpressionImpl(schemaBinding.getValue());

		} catch (JAXBException e) {			
			throw new WsnbException(e);
		} 		
		return result;
	}
	
	@Override
	public final MultipleTopicsSpecifiedFaultType readMultipleTopicsSpecifiedFaultType(
			Document document) throws WsnbException {
		MultipleTopicsSpecifiedFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbMultipleTopicsSpecifiedFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbMultipleTopicsSpecifiedFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new MultipleTopicsSpecifiedFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final NoCurrentMessageOnTopicFaultType readNoCurrentMessageOnTopicFaultType(
			Document document) throws WsnbException {
		NoCurrentMessageOnTopicFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbNoCurrentMessageOnTopicFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbNoCurrentMessageOnTopicFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new NoCurrentMessageOnTopicFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final NotificationMessageHolderType readNotificationMessageHolderType(
			Document document) throws WsnbException {
		NotificationMessageHolderType result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();
		
			// Save additional namespaces present on Topic nodes
            List<String[]> additionalTopicNS = new ArrayList<String[]>();
            
            NodeList topicNodes = document.getDocumentElement().getElementsByTagNameNS(
            		WsnbConstants.TOPIC_QNAME.getNamespaceURI(),
            		WsnbConstants.TOPIC_QNAME.getLocalPart());
                       
            if (topicNodes != null && topicNodes.getLength() == 1) {        	
            	additionalTopicNS.addAll(this.getAdditionalNamespacesFromDom((Element)topicNodes.item(0)));
            }
            // Unmarshall to Java Object
            final JAXBElement<EJaxbNotificationMessageHolderType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbNotificationMessageHolderType.class);
			result = new NotificationMessageHolderTypeImpl(schemaBinding.getValue());

			// Trick : add previously saved namespaces to the created JaxB model
            // (will be used on the write process)     
//			TopicExpressionType concreteTopic  = result.getTopic();
//			if (concreteTopic != null){
//				for (String[] currentNs : additionalTopicNS) {
//					concreteTopic.addTopicNamespace(currentNs[0], new URI(currentNs[1]));
//				}
//			}
		} catch (JAXBException e) {			
			throw new WsnbException(e);
		} 
//		catch (URISyntaxException e) {
//			throw new WsnbException(e);
//		}                   		

		return result;
	}

	@Override
	public final NotificationProducerRP readNotificationProducerRP(Document document)
			throws WsnbException {
		NotificationProducerRP result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();
			
			// Save additional namespaces present on Topic nodes
			Map<Integer,List<String[]>> additionalTopicNSPerMsg = new HashMap<Integer,List<String[]>>();
            NodeList topicExprNodes = document.getDocumentElement().getElementsByTagNameNS(
                    WsnbConstants.TOPIC_EXPRESSION_QNAME.getNamespaceURI(),
                    WsnbConstants.TOPIC_EXPRESSION_QNAME.getLocalPart());
            
            Element currentTopicNode = null;
            for (int i = 0; i < topicExprNodes.getLength(); i++) {            	
            		currentTopicNode = (Element) topicExprNodes.item(0);
            		additionalTopicNSPerMsg.put(i,this.getAdditionalNamespacesFromDom(currentTopicNode));
            }
            
            // Unmarshall to Java Object
            final JAXBElement<EJaxbNotificationProducerRP> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbNotificationProducerRP.class);
			result = new NotificationProducerRPImpl(schemaBinding.getValue());

			// Trick : add previously saved namespaces to the created JaxB model
			// (will be used on the write process)     			
//			List<TopicExpressionType> topicExpressions = result.getTopicExpressions();
//			for (TopicExpressionType topExprItem : topicExpressions) {
//				List<String[]> topicNSToAdd = additionalTopicNSPerMsg.get(topicExpressions.indexOf(topExprItem));
//				if (topicNSToAdd != null){
//					for (String[] currentNs : topicNSToAdd) {
//						topExprItem.addTopicNamespace(currentNs[0], new URI(currentNs[1]));
//					}
//				}
//			}

		} catch (JAXBException e) {			
			throw new WsnbException(e);
		} 
//		catch (URISyntaxException e) {
//			throw new WsnbException(e);
//		}                   		

		return result;
	}

	@Override
	public final Notify readNotify(Document document) throws WsnbException {
		Notify result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();
			
			// Save additional namespaces present on Topic nodes
			Map<Integer,List<String[]>> additionalTopicNSPerMsg = new HashMap<Integer,List<String[]>>();
            NodeList notifMsgNodes = document.getDocumentElement().getElementsByTagNameNS(
                    WsnbConstants.NOTIFICATION_MSG_QNAME.getNamespaceURI(),
                    WsnbConstants.NOTIFICATION_MSG_QNAME.getLocalPart());
            
            Element currentTopicNode = null;
            NodeList topicNodes = null;
            for (int i = 0; i < notifMsgNodes.getLength(); i++) {
            	topicNodes = ((Element) notifMsgNodes.item(i)).getElementsByTagNameNS(
            			WsnbConstants.TOPIC_QNAME.getNamespaceURI(),
            			WsnbConstants.TOPIC_QNAME.getLocalPart());
            	if (topicNodes.getLength() > 0) {
            		currentTopicNode = (Element) topicNodes.item(0);
            		additionalTopicNSPerMsg.put(i,this.getAdditionalNamespacesFromDom(currentTopicNode));
            	}
            }
            
            // Unmarshall to Java Object
            final JAXBElement<EJaxbNotify> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbNotify.class);
			result = new NotifyImpl(schemaBinding.getValue());

			// Trick : add previously saved namespaces to the created JaxB model
            // (will be used on the write process)     			
//			List<NotificationMessageHolderType> notifMessages = result.getNotificationMessage();
//			for (NotificationMessageHolderType notifMsgItem : notifMessages) {
//				List<String[]> topicNSToAdd = additionalTopicNSPerMsg.get(notifMessages.indexOf(notifMsgItem));
//				if (topicNSToAdd != null){
//					for (String[] currentNs : topicNSToAdd) {
//						notifMsgItem.getTopic().addTopicNamespace(currentNs[0], new URI(currentNs[1]));
//					}
//				}
//			}

		} catch (JAXBException e) {			
			throw new WsnbException(e);
		} 
//		catch (URISyntaxException e) {
//			throw new WsnbException(e);
//		}                   		

		return result;
	}

	@Override
	public final NotifyMessageNotSupportedFaultType readNotifyMessageNotSupportedFaultType(
			Document document) throws WsnbException {
		NotifyMessageNotSupportedFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbNotifyMessageNotSupportedFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbNotifyMessageNotSupportedFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new NotifyMessageNotSupportedFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final PauseFailedFaultType readPauseFailedFaultType(Document document)
			throws WsnbException {
		PauseFailedFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbPauseFailedFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbPauseFailedFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new PauseFailedFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final PauseSubscription readPauseSubscription(Document document)
			throws WsnbException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public final PauseSubscriptionResponse readPauseSubscriptionResponse(
			Document document) throws WsnbException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public final ProducerPropertiesExpression readProducerPropertiesExpression(Document document)
			throws WsnbException {
		ProducerPropertiesExpression result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();
						
            final JAXBElement<EJaxbQueryExpressionType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbQueryExpressionType.class);
			            
            result = new ProducerPropertiesExpressionImpl(schemaBinding.getValue());

		} catch (JAXBException e) {			
			throw new WsnbException(e);
		} 
		
		return result;
	}
	

	@Override
	public final Renew readRenew(Document document) throws WsnbException {
		Renew result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();
						           
            // ------- unmarshall ------
            final JAXBElement<EJaxbRenew> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbRenew.class);
			result = new RenewImpl(schemaBinding.getValue());
			
		} catch (JAXBException e) {			
			throw new WsnbException(e);
		}		
		return result;
	}

	@Override
	public final RenewResponse readRenewResponse(Document document)
			throws WsnbException {
		RenewResponse result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();
						           
            // ------- unmarshall ------
            final JAXBElement<EJaxbRenewResponse> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbRenewResponse.class);
			result = new RenewResponseImpl(schemaBinding.getValue());
			
		} catch (JAXBException e) {			
			throw new WsnbException(e);
		}		
		return result;
	}

	@Override
	public final ResumeFailedFaultType readResumeFailedFaultType(Document document)
			throws WsnbException {
		ResumeFailedFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbResumeFailedFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbResumeFailedFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new ResumeFailedFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final ResumeSubscription readResumeSubscription(Document document)
			throws WsnbException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public final ResumeSubscriptionResponse readResumeSubscriptionResponse(
			Document document) throws WsnbException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public final Subscribe readSubscribe(Document document) throws WsnbException {
		Subscribe result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();
			
			// Save additional namespaces present on TopicExpression nodes
            List<List<String[]>> additionalTopicNSs = new ArrayList<List<String[]>>();
            
            NodeList filterNode = document.getDocumentElement().getElementsByTagNameNS(
            		WsnbConstants.FILTER_QNAME.getNamespaceURI(),
            		WsnbConstants.FILTER_QNAME.getLocalPart());
           
            if (filterNode.getLength() == 1){
            	NodeList topicExpressionNodes = ((Element)filterNode.item(0)).getElementsByTagNameNS(
            			WsnbConstants.TOPIC_EXPRESSION_QNAME.getNamespaceURI(),
            			WsnbConstants.TOPIC_EXPRESSION_QNAME.getLocalPart());

            	Element currentTopicExpressionAsElt = null;
            	for (int i = 0; i < topicExpressionNodes.getLength(); i++) {
            		currentTopicExpressionAsElt = (Element) topicExpressionNodes.item(i);            	
            		additionalTopicNSs.add(this.getAdditionalNamespacesFromDom(currentTopicExpressionAsElt));
            	}
            }
            
            // ------- unmarshall ------
            final JAXBElement<EJaxbSubscribe> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbSubscribe.class);
			result = new SubscribeImpl(schemaBinding.getValue());
			
			// Trick : add previously saved namespaces to the created JaxB model
            // (will be used on the write process)       
//			FilterType filter = result.getFilter();
//			if (filter != null) {
//				List<TopicExpressionType> topicExpressions = filter.getTopicExpressions();
//				if (topicExpressions!= null){
//					for (TopicExpressionType topicExpressionItem : topicExpressions) {
//						for (String[] currentNs : additionalTopicNSs.get(topicExpressions.indexOf(topicExpressionItem))) {
//							topicExpressionItem.addTopicNamespace(currentNs[0], new URI(currentNs[1]));
//						}
//					}				
//				}
//			}
		} catch (JAXBException e) {			
			throw new WsnbException(e);
		} 
//		catch (URISyntaxException e) {
//			throw new WsnbException(e);
//		} 		
		return result;
	}

	@Override
	public final SubscribeCreationFailedFaultType readSubscribeCreationFailedFaultType(
			Document document) throws WsnbException {
		SubscribeCreationFailedFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbSubscribeCreationFailedFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbSubscribeCreationFailedFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new SubscribeCreationFailedFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final SubscribeResponse readSubscribeResponse(Document document)
			throws WsnbException {
		SubscribeResponse result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();
						           
            // ------- unmarshall ------
            final JAXBElement<EJaxbSubscribeResponse> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbSubscribeResponse.class);
			result = new SubscribeResponseImpl(schemaBinding.getValue());
			
		} catch (JAXBException e) {			
			throw new WsnbException(e);
		}		
		return result;
	}

	@Override
	public final SubscriptionManagerRP readSubscriptionManagerRP(Document document)
			throws WsnbException {
		SubscriptionManagerRP result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();
			
			// Save additional namespaces present on TopicExpression nodes
            List<List<String[]>> additionalTopicNSs = new ArrayList<List<String[]>>();
            
            NodeList filterNode = document.getDocumentElement().getElementsByTagNameNS(
            		WsnbConstants.FILTER_QNAME.getNamespaceURI(),
            		WsnbConstants.FILTER_QNAME.getLocalPart());
           
            if (filterNode.getLength() == 1){
            	NodeList topicExpressionNodes = ((Element)filterNode.item(0)).getElementsByTagNameNS(
            			WsnbConstants.TOPIC_EXPRESSION_QNAME.getNamespaceURI(),
            			WsnbConstants.TOPIC_EXPRESSION_QNAME.getLocalPart());

            	Element currentTopicExpressionAsElt = null;
            	for (int i = 0; i < topicExpressionNodes.getLength(); i++) {
            		currentTopicExpressionAsElt = (Element) topicExpressionNodes.item(i);            	
            		additionalTopicNSs.add(this.getAdditionalNamespacesFromDom(currentTopicExpressionAsElt));
            	}
            }
            
            // ------- unmarshall ------
            final JAXBElement<EJaxbSubscriptionManagerRP> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbSubscriptionManagerRP.class);
			result = new SubscriptionManagerRPImpl(schemaBinding.getValue());
			
			// Trick : add previously saved namespaces to the created JaxB model
            // (will be used on the write process)       
//			FilterType filter = result.getFilter();
//			if (filter != null) {
//				List<TopicExpressionType> topicExpressions = filter.getTopicExpressions();
//				if (topicExpressions!= null){
//					for (TopicExpressionType topicExpressionItem : topicExpressions) {
//						for (String[] currentNs : additionalTopicNSs.get(topicExpressions.indexOf(topicExpressionItem))) {
//							topicExpressionItem.addTopicNamespace(currentNs[0], new URI(currentNs[1]));
//						}
//					}				
//				}
//			}
		} catch (JAXBException e) {			
			throw new WsnbException(e);
		} 
//		catch (URISyntaxException e) {
//			throw new WsnbException(e);
//		} 		
		return result;
	}

	@Override
	public final SubscriptionManagerRP readSubscriptionManagerRP(File file)
			throws WsnbException {
		SubscriptionManagerRP subscriptionObj=null;
		try {
			Document subscriptionAsDoc = convertFromFiletoDocument(file);
			subscriptionObj = this.readSubscriptionManagerRP(subscriptionAsDoc);
		} catch (Exception e) {
			throw new WsnbException(e);
		}
		return subscriptionObj;
	}
	
	/**
	 * convert xml File loaded as {@link File} Java object to {@link Document} Java object 
	 * 
	 * @param file {@lin File} Java object to convert
	 * @return Document Representation 
	 */
	public static Document convertFromFiletoDocument(File file) throws Exception {
		Document result = null;		
		try{
			DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
			dbfac.setNamespaceAware(true);
			DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
			result = docBuilder.parse(file);
		} catch (SAXException e) {
			throw new Exception(e);
		} catch (IOException e) {
			throw new Exception(e);
		} catch (ParserConfigurationException e) {
			throw new Exception(e);
		}

		return result;
	}

	@Override
	public final SubscriptionPolicyType readSubscriptionPolicyType(Document document)
			throws WsnbException {
		SubscriptionPolicyType result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();
					
            final JAXBElement<EJaxbSubscriptionPolicyType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbSubscriptionPolicyType.class);
			result = new SubscriptionPolicyTypeImpl(schemaBinding.getValue());
			
		} catch (JAXBException e) {			
			throw new WsnbException(e);	
		}                   		

		return result;
	}

	@Override
	public final TopicExpressionType readTopicExpressionType(Document document)
			throws WsnbException {
		TopicExpressionType result = null;
		try {

			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();
		
			// Save additional namespaces present on Topic nodes
            List<String[]> additionalTopicNS = new ArrayList<String[]>();
            
            Element topicExpressionAsElt = document.getDocumentElement();
            if (topicExpressionAsElt!= null) {            	
            	additionalTopicNS.addAll(this.getAdditionalNamespacesFromDom(topicExpressionAsElt));
            }
            final JAXBElement<EJaxbTopicExpressionType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbTopicExpressionType.class);
			result = new TopicExpressionTypeImpl(schemaBinding.getValue());

			// Trick : add previously saved namespaces to the created JaxB model
            // (will be used on the write process)            
//			for (String[] currentNs : additionalTopicNS) {
//                    result.addTopicNamespace(currentNs[0], new URI(currentNs[1]));
//			}
           
		} catch (JAXBException e) {			
			throw new WsnbException(e);
		} 
//		catch (URISyntaxException e) {
//			throw new WsnbException(e);
//		}                   		

		return result;
	}

	@Override
	public final TopicExpressionDialectUnknownFaultType readTopicExpressionDialectUnknownFaultType(
			Document document) throws WsnbException {
		TopicExpressionDialectUnknownFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbTopicExpressionDialectUnknownFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbTopicExpressionDialectUnknownFaultType.class);
			if (schemaBinding.getValue() != null) {
				result = new TopicExpressionDialectUnknownFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final TopicNotSupportedFaultType readTopicNotSupportedFaultType(
			Document document) throws WsnbException {
		TopicNotSupportedFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbTopicNotSupportedFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbTopicNotSupportedFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new TopicNotSupportedFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final UnableToCreatePullPointFaultType readUnableToCreatePullPointFaultType(
			Document document) throws WsnbException {
		UnableToCreatePullPointFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbUnableToCreatePullPointFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbUnableToCreatePullPointFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new UnableToCreatePullPointFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final UnableToDestroyPullPointFaultType readUnableToDestroyPullPointFaultType(
			Document document) throws WsnbException {
		UnableToDestroyPullPointFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbUnableToDestroyPullPointFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbUnableToDestroyPullPointFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new UnableToDestroyPullPointFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final UnableToDestroySubscriptionFaultType readUnableToDestroySubscriptionFaultType(
			Document document) throws WsnbException {
		UnableToDestroySubscriptionFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbUnableToDestroySubscriptionFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbUnableToDestroySubscriptionFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new UnableToDestroySubscriptionFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final UnableToGetMessagesFaultType readUnableToGetMessagesFaultType(
			Document document) throws WsnbException {
		UnableToGetMessagesFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbUnableToGetMessagesFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbUnableToGetMessagesFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new UnableToGetMessagesFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final UnacceptableInitialTerminationTimeFaultType readUnacceptableInitialTerminationTimeFaultType(
			Document document) throws WsnbException {
		UnacceptableInitialTerminationTimeFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbUnacceptableInitialTerminationTimeFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbUnacceptableInitialTerminationTimeFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new UnacceptableInitialTerminationTimeFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final UnacceptableTerminationTimeFaultType readUnacceptableTerminationTimeFaultType(
			Document document) throws WsnbException {
		UnacceptableTerminationTimeFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbUnacceptableTerminationTimeFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbUnacceptableTerminationTimeFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new UnacceptableTerminationTimeFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final UnrecognizedPolicyRequestFaultType readUnrecognizedPolicyRequestFaultType(
			Document document) throws WsnbException {
		UnrecognizedPolicyRequestFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbUnrecognizedPolicyRequestFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbUnrecognizedPolicyRequestFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new UnrecognizedPolicyRequestFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final Unsubscribe readUnsubscribe(Document document) throws WsnbException {
		Unsubscribe result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbUnsubscribe> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbUnsubscribe.class);
			if (schemaBinding.getValue() != null){
				result = new UnsubscribeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final UnsubscribeResponse readUnsubscribeResponse(Document document)
			throws WsnbException {
		UnsubscribeResponse result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbUnsubscribeResponse> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbUnsubscribeResponse.class);
			if (schemaBinding.getValue() != null){
				result = new UnsubscribeResponseImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final UnsupportedPolicyRequestFaultType readUnsupportedPolicyRequestFaultType(
			Document document) throws WsnbException {
		UnsupportedPolicyRequestFaultType result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbUnsupportedPolicyRequestFaultType> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbUnsupportedPolicyRequestFaultType.class);
			if (schemaBinding.getValue() != null){
				result = new UnsupportedPolicyRequestFaultTypeImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}

	@Override
	public final UseRaw readUseRaw(Document document) throws WsnbException {
		UseRaw result = null ;
		try {
			Unmarshaller unmarshaller = this.wsnbJaxbContext.createWSNotificationUnmarshaller();

			// TODO : Check if it is a Thread safe method
			JAXBElement<EJaxbUseRaw> schemaBinding = 
				unmarshaller.unmarshal(new DOMSource(document),EJaxbUseRaw.class);
			if (schemaBinding.getValue() != null){
				result = new UseRawImpl(schemaBinding.getValue());
			}
		} catch (JAXBException e) {
			throw new WsnbException(e);
		} 	
		return result;
	}
	
	// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// ~~~~~~~~~~~~~~~~~~ Technical methods section ~~~~~~~~~~~~~~~~~~~~~
	
	
	/**
	 * Private method used to extract AdditionalNamespaces
	 * 
	 * @param topicExpressionNode
	 * @return
	 */
	private List<String[]> getAdditionalNamespacesFromDom(org.w3c.dom.Element topicExpressionNode) {
		List<String[]> additionalNamespaces = new ArrayList<String[]>();
		NamedNodeMap nnm = topicExpressionNode.getAttributes();
		for (int i = 0; i < nnm.getLength(); ++i) {
			Node attribute = nnm.item(i);
			if (XMLConstants.XMLNS_ATTRIBUTE.equals(attribute.getPrefix()) || XMLConstants.XML_NS_PREFIX.equals(attribute.getPrefix())) {
				// It's an namespace declaration attribute
				additionalNamespaces.add(new String[] { attribute.getLocalName(),
						attribute.getNodeValue() });
			}
		}
		return additionalNamespaces;
	}
}
