package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import java.util.Date;
import java.util.logging.Logger;

import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.BaseFaultTypeImpl;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.utils.WsrfbfUtils;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.InvalidMessageContentExpressionFaultType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbInvalidMessageContentExpressionFaultType;

public class InvalidMessageContentExpressionFaultTypeImpl extends
		BaseFaultTypeImpl implements InvalidMessageContentExpressionFaultType {
	/**
	 * Default constructor
	 * 
	 * Note : According to the xml schema the "timestamp" field is mandatory
	 * 
	 * @param timestamp the timestamp of the {@link InvalidMessageContentExpressionFaultType) object that must
	 * 		  be {@link Date} representation of an Date xml type.
	 */
	protected InvalidMessageContentExpressionFaultTypeImpl(Date timestamp){
		super(Logger.getLogger(InvalidMessageContentExpressionFaultTypeImpl.class.getSimpleName()));
		
		EJaxbInvalidMessageContentExpressionFaultType jaxbTypeObj = 
			new EJaxbInvalidMessageContentExpressionFaultType();
		
		jaxbTypeObj.setTimestamp(WsrfbfUtils.toXMLGregorianCalendar(timestamp, this.getLogger()));
		
		this.setJaxbTypeObj(jaxbTypeObj);
	}
	
	protected InvalidMessageContentExpressionFaultTypeImpl(EJaxbInvalidMessageContentExpressionFaultType jaxbTypeObj){
		super(jaxbTypeObj,Logger.getLogger(InvalidMessageContentExpressionFaultTypeImpl.class.getSimpleName()));
	}
	
	/**
	 * A way to create a  {@link EJaxbInvalidMessageContentExpressionFaultType}
	 *  "Jaxb model type" object from a {@link InvalidMessageContentExpressionFaultType} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbInvalidMessageContentExpressionFaultType toJaxbModel(InvalidMessageContentExpressionFaultType apiTypeObj){

		EJaxbInvalidMessageContentExpressionFaultType jaxbTypeObj = null;

		if (apiTypeObj instanceof InvalidMessageContentExpressionFaultTypeImpl) {
			jaxbTypeObj = (EJaxbInvalidMessageContentExpressionFaultType)
			((InvalidMessageContentExpressionFaultTypeImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = (EJaxbInvalidMessageContentExpressionFaultType) 
			BaseFaultTypeImpl.toJaxbModel(apiTypeObj,
					WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbInvalidMessageContentExpressionFaultType());
		}
		return jaxbTypeObj;
	}
}
