package com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl;

import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UseRaw;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.WsnbJAXBContext;

import easybox.org.oasis_open.docs.wsn.b_2.EJaxbUseRaw;

public class UseRawImpl implements UseRaw {

	private EJaxbUseRaw jaxbTypeObj;
//	private static Logger logger  = Logger.getLogger(UseRawImpl.class.getSimpleName());
	
	/**
	 * Default constructor
	 */
	protected UseRawImpl() {		
		this.jaxbTypeObj = WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbUseRaw();		
	}

	protected UseRawImpl(EJaxbUseRaw jaxbTypeObj){
		this.jaxbTypeObj = jaxbTypeObj;
	}
	
	protected final EJaxbUseRaw getJaxbTypeObj() {
		return jaxbTypeObj;
	}
	
	/**
	 * A way to create a  {@link com.ebmwebsourcing.wsstar.notification.base.UseRaw}
	 *  "Jaxb model type" object from a {@link UseRaw} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbUseRaw toJaxbModel(UseRaw apiTypeObj) {

		EJaxbUseRaw jaxbTypeObj = null;
		
		if (apiTypeObj instanceof UseRawImpl){
			jaxbTypeObj = ((UseRawImpl)apiTypeObj).getJaxbTypeObj();
		} else {
			jaxbTypeObj = WsnbJAXBContext.WSNB_JAXB_FACTORY.createEJaxbUseRaw();
		}
		return jaxbTypeObj;
	}
}
