/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.resource.datatypes.api.test;

import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.abstraction.BaseFaultType;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.test.AbsWsrfbfTypesUnitTests;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.test.util.WsaUnitTestsUtils;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.abstraction.ResourceUnavailableFaultType;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.abstraction.ResourceUnknownFaultType;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.abstraction.WsrfrFactory;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.abstraction.WsrfrReader;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.abstraction.WsrfrWriter;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.implementor.WsrfrModelFactory;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.refinedabstraction.RefinedWsrfrFactory;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.test.WsrfrUnitTestsUtils;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.utils.WsrfrException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Locale;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class AbsWsrfrFaultsUnitTests
extends TestCase {
    protected boolean isDebug = false;
    private WsrfrFactory factory;
    protected WsrfrModelFactory modelFactoryImpl;
    private WsrfrReader reader;
    private WsrfrWriter writer;

    protected void setUp() throws Exception {
        super.setUp();
        this.initRefinedWsrfrFactory();
        this.initRequiredDependencyModelFactories();
    }

    protected abstract void setWsrfrModelFactory();

    protected abstract void initRequiredDependencyModelFactories();

    public void initRefinedWsrfrFactory() {
        if (this.modelFactoryImpl == null) {
            this.setWsrfrModelFactory();
        }
        AbsWsrfrFaultsUnitTests.assertNotNull((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Resource\"") + "the \"WsrfrModelFactory\" implementation Object has not been set.\n" + "Please provide an instance of \"WsrfrModelFactory\" implementation class"), (Object)this.modelFactoryImpl);
        if (this.factory == null) {
            this.factory = RefinedWsrfrFactory.getInstance((WsrfrModelFactory)this.modelFactoryImpl);
        }
        if (this.reader == null) {
            this.reader = this.factory.getWsrfrReader();
        }
        if (this.writer == null) {
            this.writer = this.factory.getWsrfrWriter();
        }
    }

    protected static boolean checkResourceUnknownFaultType(ResourceUnknownFaultType expectedFault, ResourceUnknownFaultType toCheckFault, boolean isDebug) {
        return AbsWsrfbfTypesUnitTests.checkBaseFaultType((BaseFaultType)expectedFault, (BaseFaultType)toCheckFault, (String)"OASIS \"WS-Resource\"", (boolean)isDebug);
    }

    protected static boolean checkResourceUnavailableFaultType(ResourceUnavailableFaultType expectedFault, ResourceUnavailableFaultType toCheckFault, boolean isDebug) {
        return AbsWsrfbfTypesUnitTests.checkBaseFaultType((BaseFaultType)expectedFault, (BaseFaultType)toCheckFault, (String)"OASIS \"WS-Resource\"", (boolean)isDebug);
    }

    @Test
    public final void testCreateWriteAsDOMReadResourceUnknwonFaultType() throws WsrfrException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM ResourceUnknownFaultType\" ~~~~~~~ \n");
        try {
            ResourceUnknownFaultType defaultResourceUnknownFault = this.factory.createResourceUnknownFaultType(new Date());
            AbsWsrfbfTypesUnitTests.setBaseFaultContentType((BaseFaultType)defaultResourceUnknownFault, (EndpointReferenceType)WsrfrUnitTestsUtils.createDefaultBaseFaultOriginator(), (String)"Resource not found on current topology", (Locale)Locale.ENGLISH, (String)"404", (URI)new URI("http://www.ebmwebsourcing.com/dialect/wsrf/errors"), null);
            Document resourceUnknownFaultAsDOM = this.writer.writeResourceUnknwonFaultTypeAsDOM(defaultResourceUnknownFault);
            try {
                WsaUnitTestsUtils.validateResult((Document)resourceUnknownFaultAsDOM, (String[])WsrfrUnitTestsUtils.WSRFR_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-Resource\"", ResourceUnknownFaultType.class, (boolean)this.isDebug);
                System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
            }
            catch (SAXException e) {
                Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Resource\"") + e.getMessage()));
            }
            ResourceUnknownFaultType readResourceUnknownFault = this.reader.readResourceUnknownFaultType(resourceUnknownFaultAsDOM);
            AbsWsrfrFaultsUnitTests.checkResourceUnknownFaultType(defaultResourceUnknownFault, readResourceUnknownFault, this.isDebug);
            System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
            System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM ResourceUnknownFaultType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
    }

    @Test
    public final void testCreateWriteAsDOMReadResourceUnavailableFaultType() throws WsrfrException {
        System.out.println("\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\t ~~~~~~~ unit test \"Create, Write-to-DOM and read-from-DOM ResourceUnavailableFaultType\" ~~~~~~~ \n");
        try {
            ResourceUnavailableFaultType defaultResourceUnavailableFault = this.factory.createResourceUnavailableFaultType(new Date());
            AbsWsrfbfTypesUnitTests.setBaseFaultContentType((BaseFaultType)defaultResourceUnavailableFault, (EndpointReferenceType)WsrfrUnitTestsUtils.createDefaultBaseFaultOriginator(), (String)"Resource temporarly busy !", (Locale)Locale.ENGLISH, (String)"450", (URI)new URI("http://www.ebmwebsourcing.com/dialect/wsrf/errors"), null);
            Document resourceUnknownFaultAsDOM = this.writer.writeResourceUnavailableFaultTypeAsDOM(defaultResourceUnavailableFault);
            try {
                WsaUnitTestsUtils.validateResult((Document)resourceUnknownFaultAsDOM, (String[])WsrfrUnitTestsUtils.WSRFR_XML_SCHEMAS_PATHS, (String)"OASIS \"WS-Resource\"", ResourceUnavailableFaultType.class, (boolean)this.isDebug);
                System.out.println("\t Unit Test Step 1 (\"create\" and \"write to DOM\") : Passed !\n");
            }
            catch (SAXException e) {
                Assert.fail((String)(WsaUnitTestsUtils.getFailedMessagePrefix((String)"OASIS \"WS-Resource\"") + e.getMessage()));
            }
            ResourceUnavailableFaultType readResourceUnknownFault = this.reader.readResourceUnavailableFaultType(resourceUnknownFaultAsDOM);
            AbsWsrfrFaultsUnitTests.checkResourceUnavailableFaultType(defaultResourceUnavailableFault, readResourceUnknownFault, this.isDebug);
            System.out.println("\t Unit Test Step 2 (\"read from DOM\") : Passed !");
            System.out.println("\n\t OK, unit test \"Create, Write-to-DOM and read-from-DOM ResourceUnavailableFaultType\" passed !\n\n\t ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
    }
}

