package com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.impl.impl;

import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.CurrentTime;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.ScheduledResourceTerminationRP;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.abstraction.TerminationTime;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.impl.WsrfrlJAXBContext;

import easybox.org.oasis_open.docs.wsrf.rl_2.EJaxbCurrentTime;
import easybox.org.oasis_open.docs.wsrf.rl_2.EJaxbScheduledResourceTerminationRP;

public class ScheduledResourceTerminationRPImpl	implements ScheduledResourceTerminationRP {
	
	private EJaxbScheduledResourceTerminationRP jaxbTypeObj;
	
	/**
	 * Default constructor
	 */
	protected ScheduledResourceTerminationRPImpl(CurrentTime currTime,TerminationTime termTime) {
		this.jaxbTypeObj = WsrfrlJAXBContext.WSRFRL_JAXB_FACTORY.createEJaxbScheduledResourceTerminationRP();		
		this.jaxbTypeObj.setCurrentTime(CurrentTimeImpl.toJaxbModel(currTime));
		this.jaxbTypeObj.setTerminationTime(TerminationTimeImpl.toJaxbModel(termTime));		
	}
	
	protected ScheduledResourceTerminationRPImpl(EJaxbScheduledResourceTerminationRP jaxbTypeObj) {
		this.jaxbTypeObj = jaxbTypeObj;
	}	
	
	protected final EJaxbScheduledResourceTerminationRP getJaxbTypeObj() {
		return jaxbTypeObj;
	}
	
	@Override
	public final CurrentTime getCurrentTime() {
		EJaxbCurrentTime tmpVar = this.jaxbTypeObj.getCurrentTime();		
		return (tmpVar!=null)?new CurrentTimeImpl(this.jaxbTypeObj.getCurrentTime()):null;
	}

	@Override
	public final TerminationTime getTerminationTime() {
		easybox.org.oasis_open.docs.wsrf.rl_2.TerminationTime tmpVar = this.jaxbTypeObj.getTerminationTime();		
		return (tmpVar!=null)?new TerminationTimeImpl(this.jaxbTypeObj.getTerminationTime()): null;
	}

	@Override
	public final void setCurrentTime(CurrentTime value) {
		this.jaxbTypeObj.setCurrentTime(CurrentTimeImpl.toJaxbModel(value));
	}

	@Override
	public final void setTerminationTime(TerminationTime value) {
		this.jaxbTypeObj.setTerminationTime(TerminationTimeImpl.toJaxbModel(value));
	}
	
	/**
	 * A way to create a  {@link com.ebmwebsourcing.wsstar.jaxb.resource.resourcelifetime.ScheduledResourceTerminationRP}
	 *  "Jaxb model type" object from a {@link ScheduledResourceTerminationRP} "api type" one  
	 *    
	 * @param apiTypeObj
	 */
	public static EJaxbScheduledResourceTerminationRP toJaxbModel(ScheduledResourceTerminationRP apiTypeObj) {

		EJaxbScheduledResourceTerminationRP jaxbTypeObj = null;
		
		if(apiTypeObj instanceof ScheduledResourceTerminationRPImpl){
			jaxbTypeObj = ((ScheduledResourceTerminationRPImpl)apiTypeObj).getJaxbTypeObj();
		}
		else {
			jaxbTypeObj = WsrfrlJAXBContext.WSRFRL_JAXB_FACTORY.createEJaxbScheduledResourceTerminationRP();

			CurrentTime currentTime = apiTypeObj.getCurrentTime();
			if (currentTime != null){
				jaxbTypeObj.setCurrentTime(CurrentTimeImpl.toJaxbModel(currentTime));
			}
			TerminationTime terminationTime = apiTypeObj.getTerminationTime();

			if (terminationTime != null){
				jaxbTypeObj.setTerminationTime(TerminationTimeImpl.toJaxbModel(terminationTime));
			}
		}
		return jaxbTypeObj;
	}	

}
