/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl;

import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicNamespaceType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicType;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.WstopJAXBContext;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.QueryExpressionTypeImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.TopicTypeImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.utils.WstopUtils;
import easybox.org.oasis_open.docs.wsn.t_1.EJaxbTopicNamespaceType;
import easybox.org.oasis_open.docs.wsn.t_1.EJaxbTopicType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TopicNamespaceTypeImpl
implements TopicNamespaceType {
    private EJaxbTopicNamespaceType jaxbTypeObj;
    private static Logger logger = Logger.getLogger(TopicNamespaceTypeImpl.class.getSimpleName());

    protected TopicNamespaceTypeImpl(URI dialect) {
        this.jaxbTypeObj = WstopJAXBContext.WSTOP_JAXB_FACTORY.createEJaxbTopicNamespaceType();
        this.jaxbTypeObj.setTargetNamespace(dialect.toString());
        logger = Logger.getLogger(TopicNamespaceTypeImpl.class.getSimpleName());
    }

    protected TopicNamespaceTypeImpl(EJaxbTopicNamespaceType jaxbTypeObj) {
        this.jaxbTypeObj = jaxbTypeObj;
        logger = Logger.getLogger(QueryExpressionTypeImpl.class.getSimpleName());
    }

    protected final EJaxbTopicNamespaceType getJaxbTypeObj() {
        return this.jaxbTypeObj;
    }

    public String getName() {
        return this.jaxbTypeObj.getName();
    }

    public void setName(String value) {
        this.jaxbTypeObj.setName(value);
    }

    public URI getNamespace() {
        URI result = null;
        String uriAsString = this.jaxbTypeObj.getTargetNamespace();
        try {
            result = new URI(uriAsString);
        }
        catch (URISyntaxException e) {
            logger.log(Level.WARNING, "The \"Dialect\" field value of the \"TopicNamespace\" does not respect the URI Syntax (according to RFC-2396/RFC-2732).\nUri string value is :\n\t " + uriAsString + "\n");
        }
        return result;
    }

    public void setNamespace(URI value) {
        this.jaxbTypeObj.setTargetNamespace(value.toString());
    }

    public List<TopicNamespaceType.Topic> getTopics() {
        ArrayList<TopicNamespaceType.Topic> topics = new ArrayList<TopicNamespaceType.Topic>();
        List<EJaxbTopicNamespaceType.Topic> topicsFromModel = this.jaxbTypeObj.getTopic();
        if (topicsFromModel != null) {
            for (EJaxbTopicNamespaceType.Topic topicItem : topicsFromModel) {
                topics.add(new TopicImpl(topicItem));
            }
        }
        return topics;
    }

    public void addTopic(TopicNamespaceType.Topic value) {
        this.jaxbTypeObj.getTopic().add(TopicImpl.toJaxbModel(value));
    }

    public boolean isFinal() {
        return this.jaxbTypeObj.isFinal();
    }

    public void setFinal(boolean value) {
        this.jaxbTypeObj.setFinal(value);
    }

    public List<Object> getAny() {
        return this.jaxbTypeObj.getAny();
    }

    public static EJaxbTopicNamespaceType toJaxbModel(TopicNamespaceType apiTypeObj) {
        EJaxbTopicNamespaceType jaxbTypeObj = null;
        if (apiTypeObj instanceof TopicNamespaceTypeImpl) {
            jaxbTypeObj = ((TopicNamespaceTypeImpl)apiTypeObj).getJaxbTypeObj();
        } else {
            List topics;
            String name;
            jaxbTypeObj = WstopJAXBContext.WSTOP_JAXB_FACTORY.createEJaxbTopicNamespaceType();
            URI targetNS = apiTypeObj.getNamespace();
            if (targetNS != null) {
                jaxbTypeObj.setTargetNamespace(targetNS.toString());
            }
            if ((name = apiTypeObj.getName()) != null) {
                jaxbTypeObj.setName(name);
            }
            if ((topics = apiTypeObj.getTopics()) != null && topics.size() > 0) {
                for (TopicNamespaceType.Topic topicItem : topics) {
                    jaxbTypeObj.getTopic().add(TopicImpl.toJaxbModel(topicItem));
                }
            }
            jaxbTypeObj.setFinal(apiTypeObj.isFinal());
        }
        return jaxbTypeObj;
    }

    public static class TopicImpl
    extends TopicTypeImpl
    implements TopicNamespaceType.Topic {
        protected TopicImpl(String value) {
            this.jaxbTypeObj = WstopJAXBContext.WSTOP_JAXB_FACTORY.createEJaxbTopicNamespaceTypeTopic();
            this.jaxbTypeObj.setName(value);
        }

        protected TopicImpl(EJaxbTopicNamespaceType.Topic jaxbTypeObj) {
            super(jaxbTypeObj);
        }

        @Override
        protected final EJaxbTopicNamespaceType.Topic getJaxbTypeObj() {
            return (EJaxbTopicNamespaceType.Topic)this.jaxbTypeObj;
        }

        public String getParent() {
            return ((EJaxbTopicNamespaceType.Topic)this.jaxbTypeObj).getParent();
        }

        public void setParent(String parent) {
            ((EJaxbTopicNamespaceType.Topic)this.jaxbTypeObj).setParent(parent);
        }

        public static EJaxbTopicNamespaceType.Topic toJaxbModel(TopicNamespaceType.Topic apiTypeObj) {
            EJaxbTopicNamespaceType.Topic jaxbTypeObj = null;
            if (apiTypeObj instanceof TopicImpl) {
                jaxbTypeObj = ((TopicImpl)apiTypeObj).getJaxbTypeObj();
            } else {
                EJaxbTopicType partialJaxbTypeObj = TopicTypeImpl.toJaxbModel((TopicType)apiTypeObj);
                jaxbTypeObj = WstopUtils.fromJaxbModelTopicTypeToJaxbModelTopicNamespaceTypeTopic(partialJaxbTypeObj, TopicImpl.class);
                String parentAtt = apiTypeObj.getParent();
                if (parentAtt != null) {
                    jaxbTypeObj.setParent(parentAtt);
                }
            }
            return jaxbTypeObj;
        }
    }
}

