/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.datacollector.impl;

import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngineBehaviour;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.io.ErrorUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.event.EventSender;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.event.NodeProducersLocalisationManager;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyevent.AbstractEventSender;
import com.ebmwebsourcing.easyevent.AbstractProducersLocalisationManager;
import com.ebmwebsourcing.easyevent.AdminProxyEventManagerImpl;
import com.ebmwebsourcing.easyevent.WSNHelper;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.esstar.management.AdminManagementClientSOAP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.ObjectFactory;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.Unsubscribe;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.jaxb.resource.resourceproperties.GetResourcePropertyResponse;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import easierbsm.petalslink.com.service.datacollector._1.ConnectToEsb;
import easierbsm.petalslink.com.service.datacollector._1.ConnectToEsbFault;
import easierbsm.petalslink.com.service.datacollector._1.ConnectToEsbResponse;
import easierbsm.petalslink.com.service.datacollector._1_0.AdminExceptionMsg;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnableToDestroySubscriptionFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rpw_2.InvalidResourcePropertyQNameFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnavailableFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

public class DataCollectorEngineBehaviourImpl
extends AbstractEndpointBehaviourImpl
implements DataCollectorEngineBehaviour {
    private Logger log = Logger.getLogger(DataCollectorEngineBehaviourImpl.class.getName());
    private String externalAddress = null;
    private AdminProxyEventManagerImpl pem = null;
    private static Binding b;
    private List<String> esbNodeAddresses;

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{easyesb.petalslink.com.data.admin._1.ObjectFactory.class, ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("wsdl/datacollector10.wsdl");
            Description desc = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasyESBFramework.getInstance()).get()).readDocument(url, Definitions.class));
            b = (Binding)desc.getBindings().iterator().next();
        }
        catch (XmlObjectReadException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public DataCollectorEngineBehaviourImpl(Endpoint<? extends EndpointType> ep) throws ESBException {
        super(ep);
        this.setBinding(b);
        this.esbNodeAddresses = new ArrayList<String>();
    }

    public void execute(Exchange exchange) throws TransportException {
        this.log.finest("DATA COLLECTOR BEHAVIOUR FOUND: " + exchange.getOperation());
        try {
            if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("connectToEsb")) {
                this.log.finest("Connect to ESB");
                ConnectToEsb connect = (ConnectToEsb)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), ConnectToEsb.class);
                this.connectToEsb(connect.getEsbAdminAddress());
                ConnectToEsbResponse connectResponse = new ConnectToEsbResponse();
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)connectResponse);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else {
                super.execute(exchange);
            }
        }
        catch (SOAException e) {
            this.log.severe("ERROR EX: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (easierbsm.petalslink.com.service.datacollector._1_0.ConnectToEsbFault e) {
            try {
                Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)e.getFaultInfo());
                Document fault = SOAPHandler.createSoapFault((Document)docEx);
                exchange.getMessageError().getBody().setPayload(fault);
                this.log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint((Document)exchange.getMessageError().getBody().getPayload()));
            }
            catch (SOAException ex) {
                this.log.severe("ERROR EX: " + ex.getMessage());
                throw new TransportException((Throwable)ex);
            }
            catch (SOAPException ex) {
                this.log.severe("ERROR EX: " + ex.getMessage());
                throw new TransportException((Throwable)ex);
            }
        }
    }

    public void connectToEsb(String esbAdminAddress) throws easierbsm.petalslink.com.service.datacollector._1_0.ConnectToEsbFault {
        AdminManagementClientSOAP clientSubscribe = new AdminManagementClientSOAP(esbAdminAddress);
        try {
            if (this.externalAddress == null) {
                throw new easierbsm.petalslink.com.service.datacollector._1_0.ConnectToEsbFault("DataCollector must be initialized!!!");
            }
            QName topicUsedCreationRsc = new QName("http://www.petalslink.org/resources/event/1.0", "CreationResourcesTopic", "bsm");
            Subscribe subscribeCreationRsc = WSNHelper.createSubscription((String)this.externalAddress, (QName)topicUsedCreationRsc);
            SubscribeResponse responseCreationRsc = clientSubscribe.subscribe(Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(subscribeCreationRsc));
            QName topicUsedRawReport = new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic", "bsm");
            Subscribe subscribeRawReport = WSNHelper.createSubscription((String)this.externalAddress, (QName)topicUsedRawReport);
            SubscribeResponse responseRawReport = clientSubscribe.subscribe(Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(subscribeRawReport));
        }
        catch (Exception e) {
            this.log.severe(e.getMessage());
            ConnectToEsbFault f = new ConnectToEsbFault();
            f.setMsg(e.getMessage());
            f.setStacktrace(ErrorUtil.printStackTrace((Throwable)e));
            easierbsm.petalslink.com.service.datacollector._1_0.ConnectToEsbFault datacollectorFault = new easierbsm.petalslink.com.service.datacollector._1_0.ConnectToEsbFault(e.getMessage(), f);
            throw datacollectorFault;
        }
    }

    @Override
    public void initialize(String dataCollectorExternalAddress) throws ESBException {
        this.externalAddress = dataCollectorExternalAddress;
        try {
            SoapServer soapServer = (SoapServer)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getExternalServer("soap-server");
            if (soapServer == null) {
                throw new ESBException("Soap server cannot be null");
            }
            System.out.println("externalAddress = " + this.externalAddress);
            EventSender eventSender = new EventSender((ProviderEndpoint)this.getEndpoint(), this.externalAddress);
            NodeProducersLocalisationManager producersLocator = new NodeProducersLocalisationManager(this.getEndpoint());
            AdminProxyEventManagerImpl.Mode mode = AdminProxyEventManagerImpl.Mode.BROKER;
            this.pem = new AdminProxyEventManagerImpl(mode, (AbstractProducersLocalisationManager)producersLocator, (AbstractEventSender)eventSender);
        }
        catch (WsnbException e) {
            throw new ESBException((Throwable)e);
        }
    }

    public SubscribeResponse subscribe(com.ebmwebsourcing.wsstar.jaxb.notification.base.Subscribe subscribeRequest) throws TopicNotSupportedFault, ResourceUnknownFault, UnsupportedPolicyRequestFault, UnrecognizedPolicyRequestFault, SubscribeCreationFailedFault, UnacceptableInitialTerminationTimeFault, InvalidFilterFault, InvalidProducerPropertiesExpressionFault, InvalidTopicExpressionFault, NotifyMessageNotSupportedFault, InvalidMessageContentExpressionFault, TopicExpressionDialectUnknownFault {
        return this.pem.subscribe(subscribeRequest);
    }

    public UnsubscribeResponse unsubscribe(Unsubscribe unsubscribeRequest) throws ResourceUnknownFault, UnableToDestroySubscriptionFault {
        return this.pem.unsubscribe(unsubscribeRequest);
    }

    public GetResourcePropertyResponse getResourceProperty(QName getResourcePropertyRequest) throws InvalidResourcePropertyQNameFault, ResourceUnknownFault, ResourceUnavailableFault {
        return this.pem.getResourceProperty(getResourcePropertyRequest);
    }

    @Override
    public AdminProxyEventManagerImpl getProxyEventManager() {
        return this.pem;
    }

    public boolean addEsbNode(String newNode) throws AdminExceptionMsg {
        if (!this.esbNodeAddresses.contains(newNode)) {
            this.esbNodeAddresses.add(newNode);
            return true;
        }
        return false;
    }

    @Override
    public List<String> getEsbNodeAddresses() {
        return this.esbNodeAddresses;
    }
}

