/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.datacollector.impl;

import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationConsumerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.NotificationConsumerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.NotificationProducerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.thread.NotificationProducerThreadImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;

public class DataCollectorClientEndpointBehaviourImpl
extends NotificationConsumerEndpointBehaviourImpl
implements NotificationConsumerEndpointBehaviour {
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getCanonicalName());
    private NotificationProducerEndpointBehaviour producerBehaviour;
    private SubscriptionManagerEndpointBehaviour subscriptionManagerBehaviour;
    private QName topicUsed = new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic", "tns");
    private String dialect = "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete";

    public DataCollectorClientEndpointBehaviourImpl(ProviderEndpoint<? extends ProviderEndpointType> ep) {
        super(ep);
        this.producerBehaviour = (NotificationProducerEndpointBehaviour)this.getEndpoint().findBehaviour(NotificationProducerEndpointBehaviourImpl.class);
        if (this.producerBehaviour == null) {
            this.log.severe("Internal Error: This endpoint " + this.getEndpointQName() + " has no producer behaviour to send notification");
        }
        this.subscriptionManagerBehaviour = (SubscriptionManagerEndpointBehaviour)this.getEndpoint().findBehaviour(SubscriptionManagerEndpointBehaviourImpl.class);
        if (this.subscriptionManagerBehaviour == null) {
            this.log.severe("Internal Error: This endpoint " + this.getEndpointQName() + " has no producer behaviour to send notification");
        }
    }

    public void notify(Notify request) throws WsnbException {
        try {
            Document notifyAsDom = RefinedWsnbFactory.getInstance().getWsnbWriter().writeNotifyAsDOM(request);
            NotificationProducerThreadImpl notifier = new NotificationProducerThreadImpl(this.producerBehaviour, this.subscriptionManagerBehaviour, notifyAsDom, this.topicUsed, this.dialect);
            notifier.start();
        }
        catch (Exception e) {
            if (e instanceof WsnbException) {
                throw (WsnbException)e;
            }
            e.printStackTrace();
            this.log.severe(e.getLocalizedMessage());
        }
    }
}

