/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.datacollector.impl;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngine;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngineBehaviour;
import com.ebmwebsourcing.easierbsm.datacollector.api.DispatcherProviderEndpointBehaviour;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import easyevent.petalslink.com.service.proxyeventmanager.admin._1_0.AdminProxyEventManager;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

public class DispatcherProviderEndpointBehaviourImpl
extends AbstractEndpointBehaviourImpl
implements DispatcherProviderEndpointBehaviour {
    private static final String SLA_MANAGER_COMPONENT_NAME = "SLAManager";
    private static final String SLA_MANAGER_ENDPOINT_NAME = "slaManagerEndpoint";
    private static final String SLA_MANAGER_SERVICE_NAME = "slaManagerService";
    private static final String SLA_NAMESPACE = "http://petals.ow2.org";
    private static final String WSDM_MONITORING_SUFFIXE = "_WSDMMonitoring";
    private static Logger log = Logger.getLogger(DispatcherProviderEndpointBehaviourImpl.class.getName());
    private AdminProxyEventManager pem = null;

    public DispatcherProviderEndpointBehaviourImpl(ProviderEndpoint ep) throws ESBException {
        super((Endpoint)ep);
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("eventservice/wsn-consumer.wsdl");
            Description desc = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(url, Definitions.class));
            this.setBinding((Binding)desc.getBindings().iterator().next());
            URI epr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(this.endpoint.getNode().getQName().getNamespaceURI(), "DataCollector"), null, new QueryParam[0]));
            DataCollectorEngine dataCollectorEngine = (DataCollectorEngine)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getComponent(epr);
            this.pem = ((DataCollectorEngineBehaviour)dataCollectorEngine.findBehaviour(DataCollectorEngineBehaviour.class)).getProxyEventManager();
            if (this.pem == null) {
                throw new ESBException("Proxy event manager cannot be null!!!");
            }
        }
        catch (XmlObjectReadException e) {
            throw new ESBException((Throwable)e);
        }
    }

    public void execute(Exchange exchange) throws TransportException {
        try {
            log.info("DispatcherProviderEndpointBehaviourImpl BEHAVIOUR FOUND: " + exchange.getOperation());
            if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("Notify")) {
                log.info("NOTIFY");
                System.out.println("NOTIFY IN BASE ADMIN:" + XMLPrettyPrinter.prettyPrint((Document)exchange.getMessageIn().getBody().getPayload()));
                Notify notify = Wsnb4ServUtils.getWsnbReader().readNotify(exchange.getMessageIn().getBody().getPayload());
                this.notify(notify);
            }
        }
        catch (Exception e) {
            log.severe("ERROR IN DATA COLLECTOR PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
    }

    public void notify(Notify notify) throws WsnbException {
        System.out.println("TROP LA CLASSE!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        System.out.println("Dispatcher Notify: \n" + XMLPrettyPrinter.prettyPrint((Document)Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify)));
        this.pem.notify(WSNHelper.convert2JaxbElement((Notify)notify));
    }
}

