/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.sla.manager.impl;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.sla.manager.ESBSLAManagerFactoryImpl;
import com.ebmwebsourcing.easierbsm.sla.manager.api.SLAManagerComponent;
import com.ebmwebsourcing.easierbsm.sla.manager.api.SLAManagerComponentBehaviour;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.thread.SLAViolationThread;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.Report;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.TimeStampType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.wsagreement10.api.type.AgreementType;

import easybox.petalslink.com.esrawreport._1.EJaxbReportListType;


public class SLAChecker  {

    private static Logger log = Logger
            .getLogger(SLAChecker.class.getName());


    private Map<String, Runnable> threads = new HashMap<String, Runnable>();	

    private ProviderEndpoint ep;

    public SLAChecker(final ProviderEndpoint ep) {

        this.ep = ep;

    }


    public synchronized void addNewReportList(EJaxbReportListType addNewReportListRequest) {
        try {
            log.finest("New report received ...");
            ReportList reports = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().wrap(addNewReportListRequest, ReportList.class);

            if (reports.getReports().length == 2) {

                String exchangeId = reports.getReports()[0].getExchangeId();

                Report report0 = reports.getReports()[0];
                Report report1 = reports.getReports()[1];

                String clientAddress = null;
                String providerAddress = null;


                if(report0.getTimeStamp().equals(TimeStampType.t1)){

                    clientAddress = report0.getConsumerEndpointAddress();
                    providerAddress = report1.getProviderEndpointAddress();

                }
                //TODO Really manage the case T3/T4 arrives before T1/T2
                else if(report0.getTimeStamp().equals(TimeStampType.t3)){

                    providerAddress = report0.getProviderEndpointAddress();
                    clientAddress = report1.getConsumerEndpointAddress();
                }

                // find SLAManager
                SLAManagerComponent slaManager = (SLAManagerComponent) ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getComponent(new QName(ESBSLAManagerFactoryImpl.SLA_NAMESPACE, ESBSLAManagerFactoryImpl.SLA_MANAGER_COMPONENT_NAME));


                // find agreement
                SLAManagerComponentBehaviour slaBehaviour = (SLAManagerComponentBehaviour) slaManager.findBehaviour(SLAManagerComponentBehaviour.class);
                if(slaBehaviour == null) {
                    throw new ESBException("this RawReport behaviour must be coupled with slaManager Behaviour");
                }
                Map<String, Map<String, AgreementType>> agreementRegistry = slaBehaviour.getAgreementRegistry();

                Map<String, AgreementType> clientAgreements = agreementRegistry.get(providerAddress);


                if(clientAgreements != null) {

                    AgreementType ag = clientAgreements.get(clientAddress);

                    if(ag != null) {

                        /**
                         * New thread created (a priori because we received T1/T2 reports
                         */
                        if(threads.get(exchangeId) == null){
                            // No thread running => start new one
                            // start verification of SLOs                         
                            SLAViolationThread slaViolationT = new SLAViolationThread(slaBehaviour, reports, ag);
                            threads.put(exchangeId, slaViolationT);
                            slaViolationT.start();
                        } else {
                            /**
                             * T3/T4 report received ... trying to add them to existing thread if not too late 
                             */
                            if(reports.getReports()[0].getTimeStamp().equals(TimeStampType.t3)){

                                SLAViolationThread thread = (SLAViolationThread)threads.get(exchangeId);

                                //If interrupted, we complete the reports and wake up the thread
                                if(thread.isInterrupted()){

                                    synchronized (threads) {

                                        ((SLAViolationThread)threads.get(exchangeId)).addReport(reports.getReports()[0]);
                                        ((SLAViolationThread)threads.get(exchangeId)).addReport(reports.getReports()[1]);

                                        try{
                                            synchronized ( ((SLAViolationThread)threads.get(exchangeId))) {
                                                ((SLAViolationThread)threads.get(exchangeId)).notify();
                                            }
                                        }catch (IllegalMonitorStateException e) {
                                            e.printStackTrace();
                                        }
                                    }

                                } else {
                                    /**
                                     * Potential alert has already been sent,
                                     * We create a new thread in order to confirm alert (or not).
                                     */
                                    ReportList reportst1t2 = thread.getReports();
                                    reportst1t2.addReport(reports.getReports()[0]);
                                    reportst1t2.addReport(reports.getReports()[1]);

                                    SLAViolationThread slaViolationT = new SLAViolationThread(slaBehaviour, reportst1t2, ag);
                                    threads.put(exchangeId, slaViolationT);
                                    slaViolationT.start();

                                }
                            }
                        }
                    }


                }
            }
            else {
                throw new ESBException("Incorrect number of report");
            }
        } catch (ESBException e) {
            log.severe(e.getMessage());
        }
    }



    private ProviderEndpoint getEndpoint() {
        return this.ep;
    }


}
