/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.sla.manager;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementCheckingProviderEndpoint;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementCheckingService;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementException;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponent;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.AgreementManagerComponentBehaviourImpl;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.AgreementManagerComponentImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.factory.ESBCoreFactory;
import com.ebmwebsourcing.easyesb.soa.api.factory.creation.AbstractComponentCreationFactory;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;

public class AgreementManagerComponentCreationFactory extends AbstractComponentCreationFactory {
	
	public static final String SLA_MANAGER_COMPONENT_NAME = "SLAManager";
	public static final String SLA_MANAGER_ENDPOINT_NAME = "slaChekingEndpoint";
	public static final String SLA_MANAGER_SERVICE_NAME = "slaCheckingService";
	public static final String SLA_NAMESPACE = "http://petals.ow2.org";
	
	private static Logger log = Logger
	.getLogger(AgreementManagerComponentCreationFactory.class.getName());


	@Override
	public String getId() {
		return "sla-manager-factory";
	}

	public Component<?> createComponent(ESBCoreFactory factory, Node node, Configuration conf) throws ESBException {
		try {
			final AgreementManagerComponent slaManager = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createComponent(
					new QName(SLA_NAMESPACE, SLA_MANAGER_COMPONENT_NAME), AgreementManagerComponentImpl.class);
			slaManager.addBehaviourClass(AgreementManagerComponentBehaviourImpl.class);

			// create technical provider sla service
			final QName serviceName = new QName(SLA_NAMESPACE,
					SLA_MANAGER_SERVICE_NAME);
			final String endpointName = SLA_MANAGER_ENDPOINT_NAME;
			final AgreementCheckingService slaCheckingService = slaManager
					.createSLACheckingService(serviceName);
			final AgreementCheckingProviderEndpoint slaCheckingProviderEndpoint = slaCheckingService
					.createSLACheckingEndpoint(endpointName);
			
			return slaManager;
		} catch (final AgreementException e) {
			throw new ESBException(e);
		} 
	}

}
