/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.sla.manager.impl;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngine;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngineBehaviour;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponentBehaviour;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.component.AbstractComponentBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsagreement10.api.type.AgreementType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import easierbsm.petalslink.com.data.slamanager._1.AgreementResponse;
import easierbsm.petalslink.com.data.slamanager._1.ConnectToDataCollector;
import easierbsm.petalslink.com.data.slamanager._1.ConnectToDataCollectorResponse;
import easierbsm.petalslink.com.data.slamanager._1.LoadAgreementFromUrlRequest;
import easierbsm.petalslink.com.data.slamanager._1.LoadAgreementRequest;
import easierbsm.petalslink.com.data.slamanager._1.LoadAgreementResponse;
import easierbsm.petalslink.com.service.slamanager._1_0.AdminExceptionMsg;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbAgreementType;
import easybox.org.w3._2005._08.addressing.EJaxbEndpointReferenceType;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AgreementManagerComponentBehaviourImpl
extends AbstractComponentBehaviourImpl
implements AgreementManagerComponentBehaviour {
    private final Logger log = Logger.getLogger(AgreementManagerComponentBehaviourImpl.class.getName());
    private Map<URI, Map<URI, AgreementType>> agreementRegistry = Collections.synchronizedMap(new HashMap());

    public AgreementManagerComponentBehaviourImpl(Component<? extends ComponentType> ep) throws ESBException {
        super(ep);
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("wsdl/slamanager10.wsdl");
            Description desc = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(url, Definitions.class));
            this.setBinding((Binding)desc.getBindings().iterator().next());
        }
        catch (XmlObjectReadException e) {
            throw new ESBException((Throwable)e);
        }
    }

    public void execute(Exchange exchange) throws TransportException {
        this.log.finest("SLA COMPONENT BEHAVIOUR FOUND: " + exchange.getOperation());
        try {
            if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("loadAgreementFromUrl") && QName.valueOf(exchange.getOperation()).getNamespaceURI().equals("http://com.petalslink.easierbsm/service/slamanager/1.0")) {
                this.log.finest("LOAD AGREEMENT FROM URL");
                LoadAgreementFromUrlRequest lurl = (LoadAgreementFromUrlRequest)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), LoadAgreementFromUrlRequest.class);
                LoadAgreementResponse res = this.loadAgreementFromUrl(lurl);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement((Object)res));
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("loadAgreementFromDocument") && QName.valueOf(exchange.getOperation()).getNamespaceURI().equals("http://com.petalslink.easierbsm/service/slamanager/1.0")) {
                this.log.finest("LOAD AGREEMENT FROM DOCUMENT");
                LoadAgreementRequest lag = (LoadAgreementRequest)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), LoadAgreementRequest.class);
                LoadAgreementResponse res = this.loadAgreementFromDocument(lag);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement((Object)res));
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("connectToDataCollector")) {
                this.log.finest("connectToDataCollector");
                ConnectToDataCollector connect = (ConnectToDataCollector)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), ConnectToDataCollector.class);
                this.connectToDataCollector();
                ConnectToDataCollectorResponse response = new ConnectToDataCollectorResponse();
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("Notify")) {
                this.log.info("NOTIFY");
                System.out.println("NOTIFY IN BASE ADMIN:" + XMLPrettyPrinter.prettyPrint((Document)exchange.getMessageIn().getBody().getPayload()));
                Notify notify = Wsnb4ServUtils.getWsnbReader().readNotify(exchange.getMessageIn().getBody().getPayload());
                this.notify(notify);
            } else {
                super.execute(exchange);
            }
        }
        catch (AdminExceptionMsg e) {
            try {
                Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)e.getFaultInfo());
                Document fault = SOAPHandler.createSoapFault((Document)docEx);
                exchange.getMessageError().getBody().setPayload(fault);
                this.log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint((Document)exchange.getMessageError().getBody().getPayload()));
            }
            catch (SOAException ex) {
                this.log.severe("ERROR EX: " + ex.getMessage());
                throw new TransportException((Throwable)ex);
            }
            catch (SOAPException ex) {
                this.log.severe("ERROR EX: " + ex.getMessage());
                throw new TransportException((Throwable)ex);
            }
        }
        catch (SOAException e) {
            this.log.severe("ERROR EX: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (WsnbException e) {
            this.log.severe("ERROR EX: " + e.getMessage());
        }
    }

    public void connectToDataCollector() throws AdminExceptionMsg {
        try {
            URI dataEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(this.endpoint.getNode().getQName().getNamespaceURI(), "DataCollector"), null, new QueryParam[0]));
            DataCollectorEngine dataCollectorEngine = (DataCollectorEngine)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getComponent(dataEpr);
            if (dataCollectorEngine == null) {
                throw new AdminExceptionMsg("dataCollectorEngine cannot be nul!!!");
            }
            URI address = this.endpoint.getReference();
            QName topicUsedRawReport = new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic", "bsm");
            Subscribe subscribeRawReport = WSNHelper.createSubscription((String)address.toString(), (QName)topicUsedRawReport);
            SubscribeResponse responseRawReport = ((DataCollectorEngineBehaviour)dataCollectorEngine.findBehaviour(DataCollectorEngineBehaviour.class)).subscribe(WSNHelper.convert2JaxbElement((Subscribe)subscribeRawReport));
        }
        catch (WsnbException e) {
            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (SOAException e) {
            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (TopicNotSupportedFault e) {
            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (ResourceUnknownFault e) {
            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedPolicyRequestFault e) {
            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (UnrecognizedPolicyRequestFault e) {
            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (SubscribeCreationFailedFault e) {
            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (UnacceptableInitialTerminationTimeFault e) {
            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (InvalidFilterFault e) {
            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (InvalidProducerPropertiesExpressionFault e) {
            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (InvalidTopicExpressionFault e) {
            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (NotifyMessageNotSupportedFault e) {
            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (InvalidMessageContentExpressionFault e) {
            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (TopicExpressionDialectUnknownFault e) {
            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (ESBException e) {
            throw new AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void notify(Notify notify) throws WsnbException {
        try {
            System.out.println("SLA Manager component Notify: \n" + XMLPrettyPrinter.prettyPrint((Document)Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify)));
            URI slaEpr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(this.endpoint.getNode().getQName().getNamespaceURI(), "slaCheckingService"), "slaChekingEndpoint", new QueryParam[0]));
            ProviderEndpoint slaChecking = (ProviderEndpoint)((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(slaEpr);
            if (slaChecking != null) {
                Exchange ex = ((ClientEndpoint)this.endpoint).createExchange();
                ex.setDestinationReference(slaChecking.getReference());
                ex.setInterfaceName(new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumer"));
                ex.setOperation("Notify");
                ex.setServiceName(slaChecking.getServiceProvider().getQName());
                ex.setPattern(PatternType.IN_ONLY);
                MessageUtil.getInstance().createInMessageStructure(ex);
                ex.getMessageIn().getBody().setPayload(Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify));
                ((ClientEndpoint)this.getEndpoint()).send(ex);
                this.log.finest("slaChecking service found: " + slaChecking.getName());
            } else {
                this.log.warning("slaChecking not found");
            }
        }
        catch (TransportException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (ExchangeException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (ESBException e) {
            throw new WsnbException((Throwable)e);
        }
    }

    public LoadAgreementResponse loadAgreementFromUrl(LoadAgreementFromUrlRequest parameters) throws AdminExceptionMsg {
        LoadAgreementResponse response = null;
        try {
            AgreementResponse res = new AgreementResponse();
            URL agUrl = null;
            if (parameters.getUrl().startsWith("classpath://")) {
                String classpathResource = parameters.getUrl().replace("classpath://", "");
                agUrl = Thread.currentThread().getContextClassLoader().getResource(classpathResource);
            } else {
                agUrl = new URL(parameters.getUrl());
            }
            InputStream is = agUrl.openStream();
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(is);
            is.close();
            EJaxbAgreementType jaxbAg = (EJaxbAgreementType)SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbAgreementType.class);
            LoadAgreementRequest request = new LoadAgreementRequest();
            request.setAgreement(jaxbAg);
            response = this.loadAgreementFromDocument(request);
        }
        catch (MalformedURLException e) {
            this.log.severe(e.getMessage());
            e.printStackTrace();
        }
        catch (SAXException e) {
            this.log.severe(e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            this.log.severe(e.getMessage());
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            this.log.severe(e.getMessage());
            e.printStackTrace();
        }
        catch (SOAException e) {
            this.log.severe(e.getMessage());
            e.printStackTrace();
        }
        return response;
    }

    public LoadAgreementResponse loadAgreementFromDocument(LoadAgreementRequest parameters) throws AdminExceptionMsg {
        LoadAgreementResponse response = null;
        try {
            AgreementResponse res = new AgreementResponse();
            AgreementType ag = (AgreementType)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().wrap((Object)parameters.getAgreement(), AgreementType.class);
            res.setAgreementName(ag.getName());
            res.setId(UUID.randomUUID().toString());
            String providerAddress = null;
            String clientAddress = null;
            Object responder = ag.getAgreementContext().getAgreementResponder();
            Object initiator = ag.getAgreementContext().getAgreementInitiator();
            if (responder instanceof Element) {
                providerAddress = ((EndpointReferenceType)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readFragment(DOMUtil.getInstance().createDocumentFromElement((Element)ag.getAgreementContext().getAgreementResponder()), EndpointReferenceType.class)).getAddress().getValue().toString();
            } else if (responder instanceof EJaxbEndpointReferenceType) {
                EJaxbEndpointReferenceType resp = (EJaxbEndpointReferenceType)responder;
                providerAddress = resp.getAddress().getValue().toString();
            }
            if (initiator instanceof Element) {
                clientAddress = ((EndpointReferenceType)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readFragment(DOMUtil.getInstance().createDocumentFromElement((Element)ag.getAgreementContext().getAgreementInitiator()), EndpointReferenceType.class)).getAddress().getValue().toString();
            } else if (initiator instanceof EJaxbEndpointReferenceType) {
                EJaxbEndpointReferenceType init = (EJaxbEndpointReferenceType)initiator;
                clientAddress = init.getAddress().getValue().toString();
            }
            clientAddress = clientAddress.trim();
            providerAddress = providerAddress.trim();
            Map<URI, Object> clientAgreements = this.agreementRegistry.get(ESBUtil.getURIWithoutQuery((URI)URI.create(providerAddress)));
            if (clientAgreements == null) {
                clientAgreements = Collections.synchronizedMap(new HashMap());
            }
            clientAgreements.put(ESBUtil.getURIWithoutQuery((URI)URI.create(clientAddress)), ag);
            this.agreementRegistry.put(ESBUtil.getURIWithoutQuery((URI)URI.create(providerAddress)), clientAgreements);
            response = new LoadAgreementResponse();
            response.setOut(res);
            System.err.println("AGREEMENT CHARGER: agreementRegistry = " + this.agreementRegistry.keySet());
        }
        catch (Exception e) {
            System.err.println("IMPOSSIBLE TO LOAD AGREEMENT");
            this.log.severe(e.getMessage());
            e.printStackTrace();
        }
        return response;
    }

    @Override
    public Map<URI, Map<URI, AgreementType>> getAgreementRegistry() {
        return this.agreementRegistry;
    }

    public EJaxbDeployResponse deploy(EJaxbDeploy parameters) throws ManagementException {
        return null;
    }

    public List<String> getSupportedResourcesExtensions() {
        return null;
    }

    public void start() throws ESBException {
    }

    public void stop() throws ESBException {
    }
}

