/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.sla.manager.impl;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.sla.manager.AgreementManagerComponentCreationFactory;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponent;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponentBehaviour;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.thread.FrequencyViolationThread;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.thread.LatencyViolationThread;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.Report;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.TimeStampType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.wsagreement10.api.element.GuaranteeTerm;
import com.ebmwebsourcing.wsagreement10.api.element.ServiceLevelObjective;
import com.ebmwebsourcing.wsagreement10.api.type.AgreementType;

import easybox.petalslink.com.esrawreport._1.EJaxbReportListType;


public class AgreementChecker  {

	private static Logger log = Logger
			.getLogger(AgreementChecker.class.getName());


	private Map<String, Runnable> threads = new HashMap<String, Runnable>();	

	private ProviderEndpoint ep;

	public AgreementChecker(final ProviderEndpoint ep) {

		this.ep = ep;

	}


	public synchronized void addNewReportList(EJaxbReportListType addNewReportListRequest) {
		try {
			log.finest("New report received ...");
			ReportList reports = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().wrap(addNewReportListRequest, ReportList.class);

			// ReportList MUST have 2 reports 
			if (reports.getReports().length == 2) {

				String exchangeId = reports.getReports()[0].getExchangeId();

				Report report0 = reports.getReports()[0];
				Report report1 = reports.getReports()[1];

				URI clientAddress = null;
				URI providerAddress = null;


				if(report0.getTimeStamp().equals(TimeStampType.t1)){

					clientAddress = ESBUtil.getURIWithoutQuery(URI.create(report0.getConsumerEndpointAddress()));
					providerAddress = ESBUtil.getURIWithoutQuery(URI.create(report1.getProviderEndpointAddress()));

				}
				//TODO Really manage the case T3/T4 arrives before T1/T2
				else if(report0.getTimeStamp().equals(TimeStampType.t3)){

					providerAddress = ESBUtil.getURIWithoutQuery(URI.create(report0.getProviderEndpointAddress()));
					clientAddress = ESBUtil.getURIWithoutQuery(URI.create(report1.getConsumerEndpointAddress()));
				}

				// find SLAManager
				URI slaEpr = ESBUtil.generateURI(new EndpointAddress(new QName(this.getEndpoint().getNode().getQName().getNamespaceURI(), AgreementManagerComponentCreationFactory.SLA_MANAGER_COMPONENT_NAME), null));
				AgreementManagerComponent slaManager = (AgreementManagerComponent) ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getComponent(slaEpr);


				// find agreement
				AgreementManagerComponentBehaviour slaBehaviour = (AgreementManagerComponentBehaviour) slaManager.findBehaviour(AgreementManagerComponentBehaviour.class);
				if(slaBehaviour == null) {
					throw new ESBException("this RawReport behaviour must be coupled with slaManager Behaviour");
				}
				Map<URI, Map<URI, AgreementType>> agreementRegistry = slaBehaviour.getAgreementRegistry();

				// match producer side of agreement
				
				Map<URI, AgreementType> clientAgreements = agreementRegistry.get(providerAddress);


				if(clientAgreements != null) {

					//match client side of agreement
					AgreementType ag = clientAgreements.get(clientAddress);

					if(ag != null) {

						GuaranteeTerm[] guaranteeTerms = ag.getTerms().getAll().getGuaranteeTerms();
						for(GuaranteeTerm g : guaranteeTerms){
							ServiceLevelObjective slo = g.getServiceLevelObjective();
							/* FREQUENCY CHECKING */
							if ("frequency".equals(slo.getKPITarget().getKPIName())){
								String freqElaId = providerAddress.toString() + clientAddress.toString() + report0.getOperationName();
								if(threads.get(freqElaId) == null){
									FrequencyViolationThread freqViolationThread = new FrequencyViolationThread(slaBehaviour, reports, slo, ag);
									threads.put(freqElaId, freqViolationThread);
									freqViolationThread.start();
								}else{
									((FrequencyViolationThread)threads.get(freqElaId)).addNotif(reports);
								}

							}
							/* LATENCY CHECKING */
							else
								if("latency".equals(slo.getKPITarget().getKPIName())){
									/**
									 * New thread created (a priori because we received T1/T2 reports
									 */
									if(threads.get(exchangeId) == null){
										// No thread running => start new one

										// start verification of SLOs                         
										LatencyViolationThread slaViolationT = new LatencyViolationThread(slaBehaviour, reports, slo, ag);
										threads.put(exchangeId, slaViolationT);
										slaViolationT.start();
									}
									else {
										/**
										 * T3/T4 report received ... trying to add them to existing thread if not too late 
										 */
										if(reports.getReports()[0].getTimeStamp().equals(TimeStampType.t3)){

											LatencyViolationThread thread = (LatencyViolationThread)threads.get(exchangeId);

											//If interrupted, we complete the reports and wake up the thread
											if(thread.isInterrupted()){

												synchronized (threads) {

													((LatencyViolationThread)threads.get(exchangeId)).addReport(reports.getReports()[0]);
													((LatencyViolationThread)threads.get(exchangeId)).addReport(reports.getReports()[1]);

													try{
														synchronized ( ((LatencyViolationThread)threads.get(exchangeId))) {
															((LatencyViolationThread)threads.get(exchangeId)).notify();
														}
													}catch (IllegalMonitorStateException e) {
														e.printStackTrace();
													}
												}

											} else {
												/**
												 * Potential alert has already been sent,
												 * We create a new thread in order to confirm alert (or not).
												 */
												ReportList reportst1t2 = thread.getReports();
												reportst1t2.addReport(reports.getReports()[0]);
												reportst1t2.addReport(reports.getReports()[1]);

												LatencyViolationThread slaViolationT = new LatencyViolationThread(slaBehaviour, reportst1t2, slo, ag);
												threads.put(exchangeId, slaViolationT);
												slaViolationT.start();

											}
										}
									}

								}
						}


					}

				}
			}
			else {
				throw new ESBException("Incorrect number of report");
			}
		} catch (ESBException e) {
			log.severe(e.getMessage());
		}
	}



	private ProviderEndpoint getEndpoint() {
		return this.ep;
	}


}
