/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.sla.manager.impl.thread;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponentBehaviour;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.Report;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.escad10.api.element.AlertDefinition;
import com.ebmwebsourcing.esqml10.api.type.ConstraintType;
import com.ebmwebsourcing.wsagreement10.api.element.ServiceLevelObjective;
import com.ebmwebsourcing.wsagreement10.api.type.AgreementType;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Alert;

import easybox.fr.upmc.ns.ws_qml.EJaxbConstraintType;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbAgreementContextType;
import easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory;

public class FrequencyViolationThread extends AbstractAlertManagerThread implements Runnable {

	private static final String NOTIF_MIN = "notification/minute";

	private static final String NOTIF_SEC = "notification/second";

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

	private final Logger log = Logger.getLogger(FrequencyViolationThread.class
			.getName());

	private DocumentBuilder db = DocumentBuilders.takeDocumentBuilder();

	private boolean stop;

	private List<Long> notifTimeStamps;

	private AlertDefinition alertDef;


	private ReportList reports;

	private AgreementType agreement;

	private ServiceLevelObjective slo;

	private double freq = 0;

	private Object initiator;

	private Object responder;

	private String unit;

	private static final long MINUTE_IN_SECONDS = 60;

	private static final long MINUTE_IN_MILLISECONDS = MINUTE_IN_SECONDS*1000;

	private static final long SECOND_INMILLISECONDS = 1000;

	private InegalityOperator inequalityOperator;


	public FrequencyViolationThread(AgreementManagerComponentBehaviour behaviour, ReportList reports, ServiceLevelObjective slo, AgreementType agreement) throws ESBException {
		super(new SOAPSender(), behaviour, agreement);
		try {
			System.out.println("zzzzzzzzzzddddddddddddddddddddd 0");
			this.reports = reports;
			this.agreement = agreement;
			this.slo = slo;
			this.stop = false;
			System.out.println("zzzzzzzzzzddddddddddddddddddddd 1");
			this.notifTimeStamps = new CopyOnWriteArrayList<Long>();

			System.out.println("zzzzzzzzzzddddddddddddddddddddd 2");
			initiator = this.agreement.getAgreementContext().getAgreementInitiator();

			System.out.println("zzzzzzzzzzddddddddddddddddddddd 3");
			responder = this.agreement.getAgreementContext().getAgreementResponder();


			System.out.println("zzzzzzzzzzddddddddddddddddddddd Extract frenquency in slo");
			log.finest("Extract frenquency in slo");
			extractFrequencyConstraint(slo);

			System.out.println("zzzzzzzzzzddddddddddddddddddddd initialize frequency controller");
			log.finest("initialize frequency controller");
			initAlertDefinition();

			// create first timestamp
			Long timeStamp = reports.getReports()[0].getDateInGMT().getTime();
			log.finest("TIMESTAMP : "+timeStamp);
			this.notifTimeStamps.add(timeStamp);
			log.finest("LIST : \n"+this.notifTimeStamps);
		} catch (Throwable e) {
			e.printStackTrace();
			throw new ESBException(e.getMessage(), e);
		}
	}

	private void initAlertDefinition() throws ParserConfigurationException, XmlObjectReadException {
		this.alertDef = this.globalAggreement.getAgreementContext().findExtendedElement(AlertDefinition.class);
		if(alertDef == null) {
			// FIXME: EASYBOX BUG
			Object obj = ((EJaxbAgreementContextType)this.globalAggreement.getAgreementContext().getModelObject()).getAny().iterator().next();
			if(obj != null && obj instanceof Element) {
				Element elmt = (Element)obj;
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild(doc.importNode(elmt, true));
				alertDef = SOAUtil.getInstance().getReader(EasierBSMFramework.getInstance()).get().readDocument(doc, AlertDefinition.class);
			}
		}


	}

	private void extractFrequencyConstraint(ServiceLevelObjective slo) throws ParserConfigurationException, XmlObjectReadException {
		double tmpfreq = -1;

		Object obj = slo.getKPITarget().getCustomServiceLevel();
		String tmpOperator = null;

		if(obj != null) {
			if(obj instanceof Element){
				Element elmt = (Element)obj;
				Document doc;

				doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild(doc.importNode(elmt, true));

				ConstraintType target = SOAUtil.getInstance().getReader(EasierBSMFramework.getInstance()).get().readFragment(doc, ConstraintType.class);

				tmpfreq = target.getValue().getValue();
				this.unit = target.getValue().getUnit().getName();

				tmpOperator = target.getOperator();

			}else if(obj instanceof EJaxbConstraintType){
				EJaxbConstraintType c = (EJaxbConstraintType) obj;

				tmpfreq = c.getValue().getFloatValue();
				this.unit = c.getValue().getUnit().getName();

				tmpOperator = c.getOperator();
			}

			if(NOTIF_MIN.equals(unit)){
				this.freq =  tmpfreq/60;
			}else if(NOTIF_SEC.equals(unit)){
				this.freq = tmpfreq;
			}

			if("&lt;".equals(tmpOperator)){
				inequalityOperator = InegalityOperator.LESS_THAN;
			}else if("&gt;".equals(tmpOperator)){
				inequalityOperator = InegalityOperator.GREATER_THAN;
			}else{
				throw new ParserConfigurationException("Inequality operation not recognized.");
			}

		}
	}

	public void addReport(Report report){
		this.reports.addReport(report);
	}

	public ReportList getReports(){
		return this.reports;
	}

	@Override
	public void run() {
		try {

			log.finest("number of notifTimeStamps: " + notifTimeStamps);

			/* there MUST be at least 2 notifs to compute a frequence */
			if(this.notifTimeStamps.size()>1){

				/* last timestamp of the list */
				long last = this.notifTimeStamps.get(this.notifTimeStamps.size()-1);
				int cpt = 0;

				log.finest("notifTimeStamps LIST SIZE : "+this.notifTimeStamps.size());

				/* we look for the first timestamp that is >= 1 minute from the last */
				for(int i=this.notifTimeStamps.size()-2 ; i>=0 ; i--){
					cpt++;
					long current = this.notifTimeStamps.get(i);
					long window = last - current;
					
					log.finest("ela last    = " + last);
					log.finest("ela current = " + current);
					log.finest("ela window  = " + window);

					double actFreq = computeFrequency(cpt, window);

					this.log.finest("ELA checking : actual frequency : "+ actFreq+" ; expected frequency : "+ this.freq + " ; operator : "+this.inequalityOperator);

					if(NOTIF_MIN.equals(this.unit) && (window < MINUTE_IN_MILLISECONDS) && InegalityOperator.LESS_THAN.equals(this.inequalityOperator)){
						continue;
					}
					if(NOTIF_SEC.equals(this.unit) && (window < SECOND_INMILLISECONDS) && InegalityOperator.LESS_THAN.equals(this.inequalityOperator)){
						continue;
					}

					if(InegalityOperator.LESS_THAN.equals(this.inequalityOperator)){
						if(actFreq>this.freq){
							String msg = null;
							if(NOTIF_MIN.equals(this.unit)) {
								msg = "!!! Too many notifications events, actual frequeny: "+actFreq*60+" notifications/minute !!!";
							} else {
								msg = "!!! Too many notifications events, actual frequeny: "+actFreq+" notifications/second !!!";
							}
							Alert a = createAlert(msg, reports, Level.SEVERE, initiator, responder, "Observed");
							log.finest("SEND ALERT !!!!!!!!!!!");
							sendAlert(a, alertDef);
						}
					}else if(InegalityOperator.GREATER_THAN.equals(this.inequalityOperator)){
						if(actFreq<this.freq){
							String msg = null;
							if(NOTIF_MIN.equals(this.unit)) {
								msg = "!!! Not enough notifications events, actual frequeny: "+actFreq*60+" notifications/minute !!!";
							} else {
								msg = "!!! Not enough notifications events, actual frequeny: "+actFreq+" notifications/second !!!";
							}
							Alert a = createAlert(msg, reports, Level.SEVERE, initiator, responder, "Observed");
							log.finest("SEND ALERT !!!!!!!!!!!");
							sendAlert(a, alertDef);
						}
					}
				}
			}


		}catch (Exception e) {
			e.printStackTrace();
		}
	}

	private double computeFrequency(int n, double window){
		double res = 0;
		if(window>0){
			double  windowInSeconds = window/1000;
			res = n/windowInSeconds;
		}
		return res;
	}


	public void launchNotify(){
		this.notify();
	}


	@Override
	protected void finalize() throws Throwable {
		super.finalize();
		DocumentBuilders.releaseDocumentBuilder(db);
	}

	public void addNotif(ReportList reports2) {
		Long timeStamp = reports2.getReports()[0].getDateInGMT().getTime();
		log.finest("TIMESTAMP : "+timeStamp);
		this.notifTimeStamps.add(timeStamp);
		log.finest("LIST : \n"+this.notifTimeStamps);
		run();

	}

	public boolean isStop() {
		return stop;
	}

	public void stopThread(){
		this.stop = true;
	}

}
