/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.sla.manager.impl.thread;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponentBehaviour;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.thread.AbstractAlertManagerThread;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.Report;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.escad10.api.element.AlertDefinition;
import com.ebmwebsourcing.esqml10.api.type.ConstraintType;
import com.ebmwebsourcing.wsagreement10.api.element.ServiceLevelObjective;
import com.ebmwebsourcing.wsagreement10.api.type.AgreementType;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Alert;
import easybox.fr.upmc.ns.ws_qml.EJaxbConstraintType;
import easybox.org.ggf.schemas.graap._2007._03.ws_agreement.EJaxbAgreementContextType;
import easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FrequencyViolationThread
extends AbstractAlertManagerThread
implements Runnable {
    private static final String NOTIF_MIN = "notification/minute";
    private static final String NOTIF_SEC = "notification/second";
    private final Logger log = Logger.getLogger(FrequencyViolationThread.class.getName());
    private DocumentBuilder db = DocumentBuilders.takeDocumentBuilder();
    private boolean stop;
    private List<Long> notifTimeStamps;
    private AlertDefinition alertDef;
    private ReportList reports;
    private AgreementType agreement;
    private ServiceLevelObjective slo;
    private double freq = 0.0;
    private Object initiator;
    private Object responder;
    private String unit;
    private static final long MINUTE_IN_SECONDS = 60L;
    private static final long MINUTE_IN_MILLISECONDS = 60000L;
    private static final long SECOND_INMILLISECONDS = 1000L;
    private AbstractAlertManagerThread.InegalityOperator inequalityOperator;

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }

    public FrequencyViolationThread(AgreementManagerComponentBehaviour behaviour, ReportList reports, ServiceLevelObjective slo, AgreementType agreement) throws ESBException {
        super(new SOAPSender(), behaviour, agreement);
        try {
            System.out.println("zzzzzzzzzzddddddddddddddddddddd 0");
            this.reports = reports;
            this.agreement = agreement;
            this.slo = slo;
            this.stop = false;
            System.out.println("zzzzzzzzzzddddddddddddddddddddd 1");
            this.notifTimeStamps = new CopyOnWriteArrayList<Long>();
            System.out.println("zzzzzzzzzzddddddddddddddddddddd 2");
            this.initiator = this.agreement.getAgreementContext().getAgreementInitiator();
            System.out.println("zzzzzzzzzzddddddddddddddddddddd 3");
            this.responder = this.agreement.getAgreementContext().getAgreementResponder();
            System.out.println("zzzzzzzzzzddddddddddddddddddddd Extract frenquency in slo");
            this.log.finest("Extract frenquency in slo");
            this.extractFrequencyConstraint(slo);
            System.out.println("zzzzzzzzzzddddddddddddddddddddd initialize frequency controller");
            this.log.finest("initialize frequency controller");
            this.initAlertDefinition();
            Long timeStamp = reports.getReports()[0].getDateInGMT().getTime();
            this.log.finest("TIMESTAMP : " + timeStamp);
            this.notifTimeStamps.add(timeStamp);
            this.log.finest("LIST : \n" + this.notifTimeStamps);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new ESBException(e.getMessage(), e);
        }
    }

    private void initAlertDefinition() throws ParserConfigurationException, XmlObjectReadException {
        Object obj;
        this.alertDef = (AlertDefinition)this.globalAggreement.getAgreementContext().findExtendedElement(AlertDefinition.class);
        if (this.alertDef == null && (obj = ((EJaxbAgreementContextType)this.globalAggreement.getAgreementContext().getModelObject()).getAny().iterator().next()) != null && obj instanceof Element) {
            Element elmt = (Element)obj;
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            doc.appendChild(doc.importNode(elmt, true));
            this.alertDef = (AlertDefinition)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(doc, AlertDefinition.class);
        }
    }

    private void extractFrequencyConstraint(ServiceLevelObjective slo) throws ParserConfigurationException, XmlObjectReadException {
        double tmpfreq = -1.0;
        Object obj = slo.getKPITarget().getCustomServiceLevel();
        String tmpOperator = null;
        if (obj != null) {
            if (obj instanceof Element) {
                Element elmt = (Element)obj;
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild(doc.importNode(elmt, true));
                ConstraintType target = (ConstraintType)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readFragment(doc, ConstraintType.class);
                tmpfreq = target.getValue().getValue().floatValue();
                this.unit = target.getValue().getUnit().getName();
                tmpOperator = target.getOperator();
            } else if (obj instanceof EJaxbConstraintType) {
                EJaxbConstraintType c = (EJaxbConstraintType)obj;
                tmpfreq = c.getValue().getFloatValue();
                this.unit = c.getValue().getUnit().getName();
                tmpOperator = c.getOperator();
            }
            if (NOTIF_MIN.equals(this.unit)) {
                this.freq = tmpfreq / 60.0;
            } else if (NOTIF_SEC.equals(this.unit)) {
                this.freq = tmpfreq;
            }
            if ("&lt;".equals(tmpOperator)) {
                this.inequalityOperator = AbstractAlertManagerThread.InegalityOperator.LESS_THAN;
            } else if ("&gt;".equals(tmpOperator)) {
                this.inequalityOperator = AbstractAlertManagerThread.InegalityOperator.GREATER_THAN;
            } else {
                throw new ParserConfigurationException("Inequality operation not recognized.");
            }
        }
    }

    public void addReport(Report report) {
        this.reports.addReport(report);
    }

    public ReportList getReports() {
        return this.reports;
    }

    @Override
    public void run() {
        try {
            this.log.finest("number of notifTimeStamps: " + this.notifTimeStamps);
            if (this.notifTimeStamps.size() > 1) {
                long last = this.notifTimeStamps.get(this.notifTimeStamps.size() - 1);
                int cpt = 0;
                this.log.finest("notifTimeStamps LIST SIZE : " + this.notifTimeStamps.size());
                int i = this.notifTimeStamps.size() - 2;
                while (i >= 0) {
                    ++cpt;
                    long current = this.notifTimeStamps.get(i);
                    long window = last - current;
                    this.log.finest("ela last    = " + last);
                    this.log.finest("ela current = " + current);
                    this.log.finest("ela window  = " + window);
                    double actFreq = this.computeFrequency(cpt, window);
                    this.log.finest("ELA checking : actual frequency : " + actFreq + " ; expected frequency : " + this.freq + " ; operator : " + (Object)((Object)this.inequalityOperator));
                    if (!(NOTIF_MIN.equals(this.unit) && window < 60000L && AbstractAlertManagerThread.InegalityOperator.LESS_THAN.equals((Object)this.inequalityOperator) || NOTIF_SEC.equals(this.unit) && window < 1000L && AbstractAlertManagerThread.InegalityOperator.LESS_THAN.equals((Object)this.inequalityOperator))) {
                        Alert a;
                        String msg;
                        if (AbstractAlertManagerThread.InegalityOperator.LESS_THAN.equals((Object)this.inequalityOperator)) {
                            if (actFreq > this.freq) {
                                msg = null;
                                msg = NOTIF_MIN.equals(this.unit) ? "!!! Too many notifications events, actual frequeny: " + actFreq * 60.0 + " notifications/minute !!!" : "!!! Too many notifications events, actual frequeny: " + actFreq + " notifications/second !!!";
                                a = this.createAlert(msg, this.reports, AbstractAlertManagerThread.Level.SEVERE, this.initiator, this.responder, "Observed");
                                this.log.finest("SEND ALERT !!!!!!!!!!!");
                                this.sendAlert(a, this.alertDef);
                            }
                        } else if (AbstractAlertManagerThread.InegalityOperator.GREATER_THAN.equals((Object)this.inequalityOperator) && actFreq < this.freq) {
                            msg = null;
                            msg = NOTIF_MIN.equals(this.unit) ? "!!! Not enough notifications events, actual frequeny: " + actFreq * 60.0 + " notifications/minute !!!" : "!!! Not enough notifications events, actual frequeny: " + actFreq + " notifications/second !!!";
                            a = this.createAlert(msg, this.reports, AbstractAlertManagerThread.Level.SEVERE, this.initiator, this.responder, "Observed");
                            this.log.finest("SEND ALERT !!!!!!!!!!!");
                            this.sendAlert(a, this.alertDef);
                        }
                    }
                    --i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private double computeFrequency(int n, double window) {
        double res = 0.0;
        if (window > 0.0) {
            double windowInSeconds = window / 1000.0;
            res = (double)n / windowInSeconds;
        }
        return res;
    }

    @Override
    public void launchNotify() {
        this.notify();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)this.db);
    }

    public void addNotif(ReportList reports2) {
        Long timeStamp = reports2.getReports()[0].getDateInGMT().getTime();
        this.log.finest("TIMESTAMP : " + timeStamp);
        this.notifTimeStamps.add(timeStamp);
        this.log.finest("LIST : \n" + this.notifTimeStamps);
        this.run();
    }

    public boolean isStop() {
        return this.stop;
    }

    public void stopThread() {
        this.stop = true;
    }
}

