package com.ebmwebsourcing.easierbsm.sla.manager.impl.thread;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;

import org.jdom.JDOMException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponentBehaviour;
import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.thread.NotificationProducerThreadImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.escad10.api.element.AlertDefinition;
import com.ebmwebsourcing.escad10.api.element.Protocol;
import com.ebmwebsourcing.escad10.api.element.To;
import com.ebmwebsourcing.escad10.protocol.soapnotif.api.element.Binding;
import com.ebmwebsourcing.escapnote10.api.element.AlertNoteDefinition;
import com.ebmwebsourcing.escapnote10.api.element.InitiatorIdentifier;
import com.ebmwebsourcing.escapnote10.api.element.ResponderIdentifier;
import com.ebmwebsourcing.wsagreement10.api.element.ServiceLevelObjective;
import com.ebmwebsourcing.wsagreement10.api.type.AgreementType;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Alert;
import com.ebmwebsourcing.wscap12.api.anonymoustype.Info;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;

import easybox.org.oasis_open.docs.wsn.b_2.ObjectFactory;
import easybox.org.w3._2005._08.addressing.EJaxbEndpointReferenceType;

public abstract class AbstractAlertManagerThread extends Thread{

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(ObjectFactory.class,
					easybox.fr.upmc.ns.ws_qml.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

	protected ReportList reports;

	protected ServiceLevelObjective slo;

	protected AgreementType globalAggreement;

	protected final SOAPSender soapSender;

	protected final AgreementManagerComponentBehaviour behaviour;

	protected DocumentBuilder db = DocumentBuilders.takeDocumentBuilder();

	protected enum InegalityOperator {
		GREATER_THAN("&gt;"),
		LESS_THAN("&lt;"),
		GREATER_THAN_OR_EQUALS("&gt;="),
		LESS_THAN_OR_EQUALS("&lt;=");

		private String value = null;

		InegalityOperator(String val) {
			this.value = val;
		}

		boolean equals(String val) {
			if(value.equals(val)) {
				return true;
			}
			return false;
		}


	}


	protected enum Level {
		WARNING("Warning"),
		SEVERE("Severe");

		private String value = null;

		Level(String val) {
			this.value = val;
		}

		public boolean equals(String val) {
			if(value.equals(val)) {
				return true;
			}
			return false;
		}

		public String toString() {
			return value;
		}
	}

	private Logger log = Logger.getLogger(this.getClass().getCanonicalName());


	public AbstractAlertManagerThread(SOAPSender soapSender, AgreementManagerComponentBehaviour behaviour, AgreementType ag) {
		this.soapSender = soapSender;
		this.behaviour = behaviour;
		this.globalAggreement = ag;
	}


	protected Alert createAlert(String msg,
			ReportList reports, Level level, Object initiator, Object responder, String certainty) {

		Alert alert = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(Alert.class);

		alert.setIdentifier(reports.getReports()[0].getExchangeId());
		alert.setMsgType("Alert");
		alert.setSent(Calendar.getInstance().getTime());

		/* Set Alert note with internal capnote spec. */

		XmlObjectFactory factory = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory();
		AlertNoteDefinition note = factory.create(AlertNoteDefinition.class);
		note.setMessage(msg);

		if(initiator instanceof EJaxbEndpointReferenceType){
			try{
				EJaxbEndpointReferenceType initiatorEPR = (EJaxbEndpointReferenceType)initiator; 

				InitiatorIdentifier initiatorEndpoint = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(InitiatorIdentifier.class);

				if(initiatorEPR.getAddress().getValue().startsWith("http://")) {
					initiatorEndpoint.setEndpointName(initiatorEPR.getAddress().getValue());
				} else {
					EndpointAddress ea = ESBUtil.analyzeURI(new URI(initiatorEPR.getAddress().getValue()));
					initiatorEndpoint.setEndpointName(ea.getEndpointname());
					initiatorEndpoint.setNamespaceURI(ea.getNamespace());
					if(ea.getServicename() != null){
						initiatorEndpoint.setServiceName(ea.getServicename());
					}
				}
				note.setInitiatorIdentifier(initiatorEndpoint);


			}catch(Exception e){
				log.severe("Failed to parse initiator URI ...");
			}
		}
		if(responder instanceof EJaxbEndpointReferenceType){
			try{
				ResponderIdentifier responderEndpoint = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(ResponderIdentifier.class);

				EJaxbEndpointReferenceType responderEPR = (EJaxbEndpointReferenceType)responder; 


				if(responderEPR.getAddress().getValue().startsWith("http://")) {
					responderEndpoint.setEndpointName(responderEPR.getAddress().getValue());
				} else {
					EndpointAddress ea = ESBUtil.analyzeURI(new URI(responderEPR.getAddress().getValue()));

					responderEndpoint.setEndpointName(ea.getEndpointname());
					responderEndpoint.setNamespaceURI(ea.getNamespace());
					responderEndpoint.setServiceName(ea.getServicename());
				}
				note.setResponderIdentifier(responderEndpoint);

			}catch(Exception e){
				log.severe("Failed to parse responder URI ...");
			}
		}

		String noteAsString = "";//"<![CDATA[";
		Document noteAsDOM = db.newDocument();
		try {
			SOAUtil.getInstance().getWriter(EasierBSMFramework.getInstance()).get().writeDocument(note, noteAsDOM);
		} catch (XmlObjectWriteException e) {
			log.severe("Failed to write note as dom in alert.");
		}

		noteAsString += XMLPrettyPrinter.prettyPrint(noteAsDOM);
		//noteAsString += "]]>";
		alert.setNote(noteAsString);

		Info info = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(Info.class);
		info.addCategory("Infra");
		info.setEvent(msg);
		info.setUrgency("Unknown");
		info.setSeverity(level.toString());
		info.setCertainty(certainty);
		alert.addInfo(info);

		return alert;
	}

	public void launchNotify(){
		this.notify();
	}


	protected void sendAlerts(List<Alert> alerts, AlertDefinition alertDef) throws ESBException {
		for(To to: alertDef.getTos()) {
			for(Protocol protocol: to.getProtocols()) {
				Binding soapNotifBinding = protocol.findBinding(Binding.class);
				if(soapNotifBinding != null) {
					sendAlerts(alerts, to, soapNotifBinding);
				} else{
					log.severe("Only soap-notification binding is supported to send alert for the moment!!!");
				}

			}
		}
	}

	protected void sendAlert(Alert alert, AlertDefinition alertDef) throws ESBException {
		for(To to: alertDef.getTos()) {
			for(Protocol protocol: to.getProtocols()) {
				Binding soapNotifBinding = protocol.findBinding(Binding.class);
				if(soapNotifBinding != null) {
					sendAlert(alert, to, soapNotifBinding);
				} else {
					log.severe("Only soap-notification binding is supported to send alert for the moment!!!");
				}

			}
		}
	}

	protected void sendAlerts(List<Alert> alerts, To to, Binding soapNotifBinding) throws ESBException {
		for(Alert alert: alerts) {
			sendAlert(alert, to, soapNotifBinding);
		}
	}

	protected void sendAlert(Alert alert, To to, Binding soapNotifBinding) throws ESBException {
		try {
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			SOAUtil.getInstance().getWriter(EasierBSMFramework.getInstance()).get().writeDocument(alert, baos);
			ByteArrayInputStream writtenStream = new ByteArrayInputStream(baos.toByteArray());
			Document notifPayload = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(writtenStream);

			String producerAddress = ((ProviderEndpoint) this.behaviour.getEndpoint()).getReference().toString();

			final Notify notify = NotificationProducerThreadImpl.createNotification(producerAddress.trim(), soapNotifBinding.getSoapAddress().trim(), UUID.randomUUID().toString(), null, "http://www.w3.org/TR/1999/REC-xpath-19991116", notifPayload);


			if(!soapNotifBinding.getSoapAddress().startsWith("http://")) {
				final EndpointType ep = ((RegistryEndpointBehaviour)this.behaviour.getEndpoint().getNode()
						.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getEndpoint(
								URI.create(soapNotifBinding.getSoapAddress()));


				final Exchange ex = NotificationProducerThreadImpl.createMessageExchange(this.behaviour, soapNotifBinding.getSoapAddress(), notify);
				this.log.info("send internal notification to: "	+ ex.getDestinationReference());

				this.behaviour.getEndpoint().getNode()
				.getTransportersManager().push(ex,
						ep.getNode());
			} else {
				Document request = RefinedWsnbFactory.getInstance().getWsnbWriter().writeNotifyAsDOM(notify);
				//				final Document request = WSNotificationWriter
				//				.getInstance().writeNotify(notify);

				this.soapSender.sendSoapRequest(SOAPSender.createSOAPMessageRequest(request), soapNotifBinding.getSoapAddress(), null);
				this.log.info("Alert sended to " + soapNotifBinding.getSoapAddress());
			}
		} catch (TransportException e) {
			throw new ESBException(e);
		} catch (SOAPException e) {
			throw new ESBException(e);
		} catch (JDOMException e) {
			throw new ESBException(e);
		} catch (XmlObjectWriteException e) {
			throw new ESBException(e);
		} catch (SAXException e) {
			throw new ESBException(e);
		} catch (IOException e) {
			throw new ESBException(e);
		} catch (ParserConfigurationException e) {
			throw new ESBException(e);
		} catch (WsnbException e) {
			throw new ESBException(e);
		} 
	}


	@Override
	protected void finalize() throws Throwable {
		super.finalize();
		DocumentBuilders.releaseDocumentBuilder(db);
	}

}
