/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.admin.client.impl;

import java.util.List;

import com.ebmwebsourcing.easierbsm.admin.client.api.BSMAdminClient;
import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;

import easierbsm.petalslink.com.data.bsmadmin._1.ActivateBusinessMonitoringType;
import easierbsm.petalslink.com.data.bsmadmin._1.GetNodeInformations;
import easierbsm.petalslink.com.data.bsmadmin._1.GetNodeInformationsResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.LoadAgreementFromUrlRequest;
import easierbsm.petalslink.com.data.bsmadmin._1.LoadAgreementRequest;
import easierbsm.petalslink.com.data.bsmadmin._1.LoadAgreementResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.MonitoringEndpointType;
import easierbsm.petalslink.com.data.bsmadmin._1.UnActivateBusinessMonitoringType;
import easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg;
import easierbsm.petalslink.com.service.bsmadmin._1_0.BSMAdminItf;

public class BSMAdminClientImpl extends AdminClientImpl implements BSMAdminClient {


	private BSMAdminItf wsdmClientProxy;
	
    public BSMAdminClientImpl(String address) throws ESBException {
        super(address);
    }
    
    /**
     * @return the clientProxy
     */
    private synchronized BSMAdminItf getBSMClientProxy() {
        if (wsdmClientProxy != null) {
            return wsdmClientProxy;
        }
        this.wsdmClientProxy = CXFHelper.getClient(address, BSMAdminItf.class);
        return wsdmClientProxy;
    }

	@Override
	public boolean activateBusinessMonitoring(
			ActivateBusinessMonitoringType activateBusinessMonitoring)
			throws AdminExceptionMsg {
		return this.getBSMClientProxy().activateBusinessMonitoring(activateBusinessMonitoring);
	}

	@Override
	public List<MonitoringEndpointType> getAllMonitoringEndpoints()
			throws AdminExceptionMsg {
		return this.getBSMClientProxy().getAllMonitoringEndpoints();
	}

	@Override
	public boolean unActivateBusinessMonitoring(
			UnActivateBusinessMonitoringType unActivateBusinessMonitoring)
			throws AdminExceptionMsg {
		return this.getBSMClientProxy().unActivateBusinessMonitoring(unActivateBusinessMonitoring);
	}

	@Override
	public void connectToEsb(String address, Boolean synchronize) throws AdminExceptionMsg {
		this.getBSMClientProxy().connectToEsb(address, synchronize);
	}

	@Override
	public void unconnectToEsb(String address) throws AdminExceptionMsg {
		this.getBSMClientProxy().unconnectToEsb(address);
	}

	@Override
	public LoadAgreementResponse loadAgreementFromDocument(
			LoadAgreementRequest parameters) throws AdminExceptionMsg {
		return this.getBSMClientProxy().loadAgreementFromDocument(parameters);
	}

	@Override
	public LoadAgreementResponse loadAgreementFromUrl(
			LoadAgreementFromUrlRequest parameters) throws AdminExceptionMsg {
		return this.getBSMClientProxy().loadAgreementFromUrl(parameters);
	}

	@Override
	public GetNodeInformationsResponse getNodeInformations(
			GetNodeInformations parameters) throws AdminExceptionMsg {
		return this.getBSMClientProxy().getNodeInformations(parameters);
	}

	@Override
	public List<String> getConnectedEsbs() throws AdminExceptionMsg {
		return this.getBSMClientProxy().getConnectedEsbs();
	}

	@Override
	public void monitorEndpoints(String notificationAddress,
			List<MonitoringEndpointType> endpoint) throws AdminExceptionMsg {
		this.getBSMClientProxy().monitorEndpoints(notificationAddress, endpoint);
	}

	@Override
	public String ping() {
		try {
			return this.getBSMClientProxy().ping();
		} catch (AdminExceptionMsg e) {
			// do nothing
			e.printStackTrace();
		}
		return null;
	}



  

}
