/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * MonitoringEngine-Core - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.petalslink.abslayer.service.api.Description;

import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderEndpointImpl;
import com.ebmwebsourcing.wsdm10.api.element.OperationMetrics;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value=WSDMProviderEndpoint.class, names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class WSDMProviderEndpointImpl extends
		ProviderEndpointImpl<com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType> implements WSDMProviderEndpoint {

	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	
	private final Map<QName, OperationMetrics> qosmetrics = Collections
	.synchronizedMap(new HashMap<QName, OperationMetrics>());

	private Description functionalDescription;
	
	private EJaxbBasicNodeInformationsType env;
	
	private static Logger log = Logger
			.getLogger(WSDMProviderEndpointImpl.class.getName());

	private WSDMMonitoringEngine wSDMMonitoringEngine = null;

	
	public WSDMMonitoringEngine getMonitoringEngine() {
		return this.wSDMMonitoringEngine;
	}

	public void setMonitoringEngine(WSDMMonitoringEngine me) {
		this.wSDMMonitoringEngine = me;
	}

	@Override
	public Map<QName, OperationMetrics> getOperationMetricsMap() {
		return qosmetrics;
	}

    @Override
    public void setFunctionalDescription(Description desc) {
        this.functionalDescription = desc;
        
    }

    @Override
    public Description getFunctionalDescription() {
        return this.functionalDescription;
    }

	@Override
	public void setFunctionalNodeInfo(EJaxbBasicNodeInformationsType env) {
		this.env = env;
		
	}

	@Override
	public EJaxbBasicNodeInformationsType getFunctionalNodeInfo() {
		return this.env;
	}

   
}
