/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;

import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.datacollector.DataCollectorComponentCreationFactory;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngine;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngineBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.Constants;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.MonitoringException;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngineBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMProviderEndpoint;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMService;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.component.ComponentBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.component.AbstractComponentBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.ServiceBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.behaviour.BaseAdminEndpointBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.behaviour.BaseAdminEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.esstar.management.AdminManagementClientSOAP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import com.petalslink.esstar.essynchronizer.impl.ResourceException;

import easierbsm.petalslink.com.data.wsdmmanager._1.ActivateBusinessMonitoring;
import easierbsm.petalslink.com.data.wsdmmanager._1.ActivateBusinessMonitoringResponse;
import easierbsm.petalslink.com.data.wsdmmanager._1.ActivateBusinessMonitoringType;
import easierbsm.petalslink.com.data.wsdmmanager._1.ConnectToDataCollector;
import easierbsm.petalslink.com.data.wsdmmanager._1.ConnectToDataCollectorResponse;
import easierbsm.petalslink.com.data.wsdmmanager._1.CreateMonitoringEndpoint;
import easierbsm.petalslink.com.data.wsdmmanager._1.CreateMonitoringEndpointResponse;
import easierbsm.petalslink.com.data.wsdmmanager._1.GetAllMonitoringEndpoints;
import easierbsm.petalslink.com.data.wsdmmanager._1.GetAllMonitoringEndpointsResponse;
import easierbsm.petalslink.com.data.wsdmmanager._1.MonitorEndpoints;
import easierbsm.petalslink.com.data.wsdmmanager._1.MonitorEndpointsResponse;
import easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType;
import easierbsm.petalslink.com.data.wsdmmanager._1.ObjectFactory;
import easierbsm.petalslink.com.data.wsdmmanager._1.OperationListType;
import easierbsm.petalslink.com.data.wsdmmanager._1.UnActivateBusinessMonitoring;
import easierbsm.petalslink.com.data.wsdmmanager._1.UnActivateBusinessMonitoringResponse;
import easierbsm.petalslink.com.data.wsdmmanager._1.UnActivateBusinessMonitoringType;
import easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbUndeployResponse;
import easybox.petalslink.com.esrawreport._1.EJaxbReportListType;
import easybox.petalslink.com.esrawreport._1.EJaxbReportType;
import esstar.petalslink.com.data.management.admin._1.GetResourceIdentifiers;
import esstar.petalslink.com.data.management.admin._1.GetResourceIdentifiersResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;

public class WSDMMonitoringEngineBehaviourImpl extends AbstractComponentBehaviourImpl implements
WSDMMonitoringEngineBehaviour {

	private final Logger log = Logger.getLogger(WSDMMonitoringEngineBehaviourImpl.class
			.getName());

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(easierbsm.petalslink.com.data.wsdmmanager._1.ObjectFactory.class,
					com.petalslink.esstar.execution_environment_synchronizer_impl._1.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
		}
	}

	private ObjectFactory factory = new ObjectFactory();

	private WSDMMonitoringEngine wsdmMonitoringEngine;

	private WSDMCreationEndpointManager wsdmCreationEndpointManager;


	public WSDMMonitoringEngineBehaviourImpl(Component<? extends ComponentType> ep) throws ESBException {
		super(ep);
		try {
			URL url = Thread.currentThread().getContextClassLoader().getResource(WSDM_DESCRIPTION_URL);
			Description desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasierBSMFramework.getInstance()).get().readDocument(url, Definitions.class));
			this.setBinding(desc.getBindings().iterator().next());

			wsdmMonitoringEngine = (WSDMMonitoringEngine) ep;
			wsdmCreationEndpointManager = new WSDMCreationEndpointManager(this);

		} catch (XmlObjectReadException e) {
			throw new ESBException(e);
		}
	}


	@Override
	public void execute(final Exchange exchange) throws TransportException {
		log.finest("WSDM MONITORING BEHAVIOUR FOUND: " + exchange.getOperation());

		try {
			if (QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("createMonitoringEndpoint")
					&& (QName.valueOf(exchange.getOperation()).getNamespaceURI().equals(Constants.WS_BINDING_WSDM_ADMIN_SERVICE))) {
				this.log.finest("CREATE MONITORING ENDPOINT METHOD");


				CreateMonitoringEndpoint createMonitoringEndpoint = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), CreateMonitoringEndpoint.class);


				String res = this.createMonitoringEndpoint(createMonitoringEndpoint.getWsdmServiceName(), createMonitoringEndpoint.getWsdmProviderEndpointName(), createMonitoringEndpoint.isExposeInSoap());

				CreateMonitoringEndpointResponse createMonitoringEndpointResponse = factory.createCreateMonitoringEndpointResponse();
				createMonitoringEndpointResponse.setWsdmEndpointName(res);


				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(createMonitoringEndpointResponse);


				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);


			} else if (QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("getAllMonitoringEndpoints")
					&& (QName.valueOf(exchange.getOperation()).getNamespaceURI().equals(Constants.WS_BINDING_WSDM_ADMIN_SERVICE))) { 
				this.log.finest("GET ALL MONITORING ENDPOINTS");

				GetAllMonitoringEndpoints getAllMonitoringEndpoints = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetAllMonitoringEndpoints.class);


				List<easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType> res = this.getAllMonitoringEndpoints();

				GetAllMonitoringEndpointsResponse getAllMonitoringEndpointsResponse = factory.createGetAllMonitoringEndpointsResponse();

				for(easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType mep: res) {
					getAllMonitoringEndpointsResponse.getEndpoint().add(mep);
				}


				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(getAllMonitoringEndpointsResponse);


				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("activateBusinessMonitoring") && (QName.valueOf(exchange.getOperation()).getNamespaceURI().equals(Constants.WS_BINDING_WSDM_ADMIN_SERVICE))) { 


				this.log.finest("Activate Business Monitoring");

				ActivateBusinessMonitoring activateIn = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), ActivateBusinessMonitoring.class);


				boolean res = this.activateBusinessMonitoring(activateIn.getActivateBusinessMonitoring());
				ActivateBusinessMonitoringResponse response = new ActivateBusinessMonitoringResponse();
				response.setActivateBunsinessMonitoringResponseModel(res);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);


				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("unActivateBusinessMonitoring") && (QName.valueOf(exchange.getOperation()).getNamespaceURI().equals(Constants.WS_BINDING_WSDM_ADMIN_SERVICE))){
				this.log.finest("Activate Business Monitoring");

				UnActivateBusinessMonitoring activateIn = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), UnActivateBusinessMonitoring.class);


				boolean res = this.unActivateBusinessMonitoring(activateIn.getUnActivateBusinessMonitoring());
				UnActivateBusinessMonitoringResponse response = new UnActivateBusinessMonitoringResponse();
				response.setUnActivateBusinessMonitoringResponse(res);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);


				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("connectToDataCollector") && (QName.valueOf(exchange.getOperation()).getNamespaceURI().equals(Constants.WS_BINDING_WSDM_ADMIN_SERVICE))){
				this.log.finest("connectToDataCollector");

				ConnectToDataCollector connect = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), ConnectToDataCollector.class);

				this.connectToDataCollector();
				ConnectToDataCollectorResponse response = new ConnectToDataCollectorResponse();

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);


				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("monitorEndpoints") && (QName.valueOf(exchange.getOperation()).getNamespaceURI().equals(Constants.WS_BINDING_WSDM_ADMIN_SERVICE))){
				this.log.finest("monitorEndpoints");

				MonitorEndpoints monitor = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), MonitorEndpoints.class);

				this.monitorEndpoints(monitor.getNotificationAddress(), monitor.getEndpoint());
				MonitorEndpointsResponse response = new MonitorEndpointsResponse();

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);


				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if (QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("Notify")) {

				log.info("NOTIFY");

				System.out.println("NOTIFY IN BASE ADMIN:" + XMLPrettyPrinter.prettyPrint(exchange.getMessageIn().getBody().getPayload()));
				Notify notify =  Wsnb4ServUtils.getWsnbReader().readNotify(exchange.getMessageIn().getBody().getPayload());
				this.notify(notify);
			} else {
				super.execute(exchange);
			}
		} catch (AdminExceptionMsg e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				log.severe("ERROR EX: " + ex.getMessage());
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				log.severe("ERROR EX: " + ex.getMessage());
				throw new TransportException(ex);
			}
		} catch (SOAException e) {
			log.severe("ERROR EX: " + e.getMessage());
			throw new TransportException(e);
		} catch (WsnbException e) {
			log.severe("ERROR EX: " + e.getMessage());
		} 
	}


	public String createMonitoringEndpoint(
			QName wsdmServiceName,
			String wsdmProviderEndpointName,
			boolean exposeInSoap
			) throws AdminExceptionMsg {
		String res = null;
		try {
			final WSDMService wsdmService = this.wsdmMonitoringEngine
					.createMonitoringService(wsdmServiceName);
			final WSDMProviderEndpoint wsdmEndpoint = wsdmService
					.createMonitoringEndpoint(
							wsdmProviderEndpointName);

			if (exposeInSoap) {

				com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint<?>[] eps = this.wsdmMonitoringEngine.getNode().findBehaviour(NodeBehaviour.class).findEndpointsByBehaviour(BaseAdminEndpointBehaviourImpl.class);
				if(eps.length == 0) {
					throw new ESBException("Internal error wsdm admin behaviour must be coupled with admin behaviour");
				}
				com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint<?> admin = eps[0];
				BaseAdminEndpointBehaviour adminBehaviour = admin.findBehaviour(BaseAdminEndpointBehaviourImpl.class);


				res = adminBehaviour.exposeServiceEndpointInSoap(wsdmServiceName,
						wsdmProviderEndpointName);
			} else {
				res = wsdmEndpoint.getReference().toString();
			}
		} catch (final ESBException e) {
			this.log.severe(e.getMessage());
			e.printStackTrace();
		} catch (final MonitoringException e) {
			this.log.severe(e.getMessage());
			e.printStackTrace();
		} catch (ManagementException e) {
			this.log.severe(e.getMessage());
			e.printStackTrace();
		} 
		return res;
	}

	public List<easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType> getAllMonitoringEndpoints() throws AdminExceptionMsg {
		List<easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType> res = new ArrayList<easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType>();
		List<Service<? extends com.ebmwebsourcing.easyesb.soa10.api.type.ServiceType>> services = null;
		ComponentBehaviour cb = ((ComponentBehaviour)this.getMonitoringEngine().findBehaviour(ComponentBehaviour.class));
		services = cb.getServices();
		try {
			for(Service<? extends com.ebmwebsourcing.easyesb.soa10.api.type.ServiceType> s: services) {
				System.out.println("s = " + s.getName());
				System.out.println("s behave = " + ((ServiceBehaviour)s.findBehaviour(ServiceBehaviour.class)));
				if(((ServiceBehaviour)s.findBehaviour(ServiceBehaviour.class)) != null && ((ServiceBehaviour)s.findBehaviour(ServiceBehaviour.class)).getProviderEndpoints() != null) {
					for(ProviderEndpoint ep: ((ServiceBehaviour)s.findBehaviour(ServiceBehaviourImpl.class)).getProviderEndpoints()) {

						SoapServer soapServer = (SoapServer) ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getExternalServer("soap-server");
						int soapPort = 8085;
						if(soapServer != null){
							soapPort = soapServer.getConfig().getPort();
						}
						EndpointAddress addr = ESBUtil.analyzeURI(ep.getReference());

						String address = "http://" + this.getEndpoint().getNode().getModel().getBasicNodeInformations().getHost() + ":" + soapPort + "/services/" + addr.getEndpointname() + "ClientProxyEndpoint";
						WSDMProviderEndpoint mep = (WSDMProviderEndpoint) ep;

						easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType wsdmEndpoint = new easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType();
						wsdmEndpoint.setAddress(address);
						wsdmEndpoint.setName(new QName(addr.getEndpointname()));
						if(wsdmEndpoint.getOperations() == null) {
							wsdmEndpoint.setOperations(new OperationListType());
						}
						for(QName opName: mep.getOperationMetricsMap().keySet()) {
							wsdmEndpoint.getOperations().getOperationName().add(opName.getLocalPart());
						}

						res.add(wsdmEndpoint);
					}
				}
			}
		} catch (SOAException e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		}
		return res;
	}


	public WSDMMonitoringEngine getMonitoringEngine() {
		return this.wsdmMonitoringEngine;
	}


	public void setMonitoringEngine(WSDMMonitoringEngine me) {
		this.wsdmMonitoringEngine = me;
	}


	@Override
	public boolean activateBusinessMonitoring (
			ActivateBusinessMonitoringType activateBusinessMonitoring) throws AdminExceptionMsg {

		return this.wsdmMonitoringEngine.activateBusinessMonitoring(activateBusinessMonitoring.getServiceName(), activateBusinessMonitoring.getEndpointName(),activateBusinessMonitoring.getOperation());
	}


	@Override
	public boolean unActivateBusinessMonitoring(
			UnActivateBusinessMonitoringType unActivateBusinessMonitoring) throws AdminExceptionMsg {

		return this.wsdmMonitoringEngine.unActivateBusinessMonitoring(unActivateBusinessMonitoring.getServiceName(), unActivateBusinessMonitoring.getEndpointName(), unActivateBusinessMonitoring.getOperation());
	}


	@Override
	public void connectToDataCollector() throws AdminExceptionMsg {
		try {
			// find dispatcher endpoint
			URI dataEpr = ESBUtil.generateURI(new EndpointAddress(new QName(this.getEndpoint().getNode().getQName().getNamespaceURI(), DataCollectorComponentCreationFactory.DATA_COLLECTOR_COMPONENT_NAME), null));
			DataCollectorEngine dataCollectorEngine = (DataCollectorEngine) ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getComponent(dataEpr);
			if(dataCollectorEngine == null) {
				throw new AdminExceptionMsg("dataCollectorEngine cannot be nul!!!");
			}

			URI address = this.getEndpoint().getReference();

			QName topicUsedCreationRsc = new QName("http://www.petalslink.org/resources/event/1.0", "CreationResourcesTopic", "bsm");
			Subscribe subscribeCreationRsc = WSNHelper.createSubscription(address.toString(), topicUsedCreationRsc);
			SubscribeResponse responseCreationRsc = ((DataCollectorEngineBehaviour)dataCollectorEngine.findBehaviour(DataCollectorEngineBehaviour.class)).subscribe(WSNHelper.convert2JaxbElement(subscribeCreationRsc));

			QName topicUsedRawReport = new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic", "bsm"); 
			Subscribe subscribeRawReport = WSNHelper.createSubscription(address.toString(), topicUsedRawReport);
			SubscribeResponse responseRawReport = ((DataCollectorEngineBehaviour)dataCollectorEngine.findBehaviour(DataCollectorEngineBehaviour.class)).subscribe(WSNHelper.convert2JaxbElement(subscribeRawReport));
		} catch (WsnbException e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (TopicNotSupportedFault e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (ResourceUnknownFault e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (UnsupportedPolicyRequestFault e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (UnrecognizedPolicyRequestFault e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (SubscribeCreationFailedFault e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (UnacceptableInitialTerminationTimeFault e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (InvalidFilterFault e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (InvalidProducerPropertiesExpressionFault e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (InvalidTopicExpressionFault e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (NotifyMessageNotSupportedFault e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (InvalidMessageContentExpressionFault e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (TopicExpressionDialectUnknownFault e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (ESBException e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		}
	}


	@Override
	public void notify(Notify notify) throws WsnbException {
		try {
			System.out.println("WSDM Monitoring Engine Notify: \n" + XMLPrettyPrinter.prettyPrint(Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify)));
			for(NotificationMessageHolderType nmht: notify.getNotificationMessage()) {
				Element msg = nmht.getMessage().getAny();
				Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
				doc.appendChild(doc.adoptNode(msg));
				System.out.println("msg = " + msg.getLocalName());
				if(msg.getLocalName().equals("resourceIdentifier")) {
					EJaxbResourceIdentifier rsc = SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbResourceIdentifier.class);
					wsdmCreationEndpointManager.analyzeResource(rsc);
				} else if(msg.getLocalName().equals("reportList")) {
					ReportList request = (ReportList) SOAUtil.getInstance().getReader(EasierBSMFramework.getInstance()).get().readDocument(doc, ReportList.class);
					EJaxbReportListType requestModel = (EJaxbReportListType) request.getModelObject();
					if(requestModel.getReport().size() > 0) {
						EJaxbReportType report = requestModel.getReport().get(0);
						URI endpointName = null;

						EndpointAddress addr = ESBUtil.analyzeURI(URI.create(report.getProviderEndpointAddress()));
						
						if(report.getServiceQName() != null) {
							endpointName = ESBUtil.generateURI(new EndpointAddress(new QName(addr.getNamespace(), addr.getServicename()), addr.getEndpointname() + WSDMProviderEndpoint.WSDM_MONITORING_SUFFIXE)); //"{"+report.getServiceQName().getNamespaceURI()+"}"+report.getEndpointName() + WSDMProviderEndpoint.WSDM_MONITORING_SUFFIXE;
						}
						// find wsdm endpoint
						if(endpointName != null) {
							ProviderEndpoint<?> wsdmEp = (ProviderEndpoint<?>) ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(endpointName);
							if(wsdmEp != null) {
								Exchange ex = ((ClientEndpoint<?>)this.endpoint).createExchange();
								ex.setDestinationReference(wsdmEp.getReference());
								ex.setInterfaceName(new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumer"));
								ex.setOperation("Notify");
								ex.setServiceName(wsdmEp.getServiceProvider().getQName());
								ex.setPattern(PatternType.IN_ONLY);
								MessageUtil.getInstance().createInMessageStructure(ex);
								ex.getMessageIn().getBody().setPayload(Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify));
								((ClientEndpoint)this.getEndpoint()).send(ex);
								log.finest("WSDM Endpoint service found: " + wsdmEp.getName());
							} else {
								log.warning("WSDM Endpoint not found: " + endpointName);
							}
						}
					}
				}
			}
		} catch (ParserConfigurationException e) {
			throw new WsnbException(e);
		} catch (SOAException e) {
			throw new WsnbException(e);
		} catch (ResourceException e) {
			throw new WsnbException(e);
		} catch (XmlObjectReadException e) {
			throw new WsnbException(e);
		} catch (TransportException e) {
			throw new WsnbException(e);
		} catch (ExchangeException e) {
			throw new WsnbException(e);
		} catch (ESBException e) {
			throw new WsnbException(e);
		}
	}


	@Override
	public void synchronize(String esbAddress) throws AdminExceptionMsg {
		AdminManagementClientSOAP client = new AdminManagementClientSOAP(esbAddress);
		try {
			GetResourceIdentifiersResponse response = client.getResourceIdentifiers(new GetResourceIdentifiers());
			for(EJaxbResourceIdentifier rsc: response.getResourceIdentifier()) {
				wsdmCreationEndpointManager.analyzeResource(rsc);
			}
		} catch (ManagementException e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (ResourceException e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		}
	}


	@Override
	public void monitorEndpoints(String notificationAddress,
			List<MonitoringEndpointType> endpoint) throws AdminExceptionMsg {
		try {
			List<Service<? extends com.ebmwebsourcing.easyesb.soa10.api.type.ServiceType>> services = null;
			ComponentBehaviour cb = ((ComponentBehaviour)this.getMonitoringEngine().findBehaviour(ComponentBehaviour.class));
			services = cb.getServices();
			for(Service<? extends com.ebmwebsourcing.easyesb.soa10.api.type.ServiceType> s: services) {
				if(((ServiceBehaviour)s.findBehaviour(ServiceBehaviourImpl.class)).getProviderEndpoints() != null) {
					for(ProviderEndpoint ep: ((ServiceBehaviour)s.findBehaviour(ServiceBehaviourImpl.class)).getProviderEndpoints()) {
						if(ep instanceof WSDMProviderEndpoint) {
							NotificationProducerEndpointBehaviour behaviour = ((WSDMProviderEndpoint)ep).findBehaviour(NotificationProducerEndpointBehaviour.class);
							QName topicUsed = new QName("http://docs.oasis-open.org/wsdm/2004/12/mows/wsdm-mows-events.xml", "MetricsCapability", "res");
							com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe payload;
							payload = WSNHelper.createSubscription(notificationAddress, topicUsed);
							behaviour.subscribe(payload);
						}
					}
				}
			}
		} catch (WsnbException e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (SOAException e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		} catch (AbsWSStarFault e) {
			throw new AdminExceptionMsg(e.getMessage(), e);
		}
	}


	@Override
	public EJaxbDeployResponse deploy(EJaxbDeploy arg0)
			throws ManagementException {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public List<String> getSupportedResourcesExtensions() {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public void start() throws ESBException {
		// TODO Auto-generated method stub

	}


	@Override
	public void stop() throws ESBException {
		// TODO Auto-generated method stub

	}


	@Override
	public EJaxbUndeployResponse undeploy(EJaxbUndeploy arg0)
			throws ManagementException {
		// TODO Auto-generated method stub
		return null;
	}



}
