/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.api.matcher;


import java.util.Set;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Description;

import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface Matcher {
	
	public MatcherProperties getMatcherProperties();
	
	public void setMatcherProperties(MatcherProperties props);
	
	public SemanticRegistryManager getSemanticRegistryManager();
	
	public MatchingResult findServices(SearchProfile profile);
	
	public MatchingResult findServices(SearchProfile profile, Partner partner);
	
	/**
	 * Find all services close to from registry 
	 * 
	 * @param operationQName QName of target operation in (SA)WSDL file
	 * @param sawsdlDesc annotated description
	 * @return matching result (list of matched services with similarity rate)
	 */
	public MatchingResult findServices(QName operationQName, Description sawsdlDesc);
	
	public MatchingResult findServices(QName operationQName, Description sawsdlDesc, Partner partner);
	
	public MatchingResult findServices(SearchProfile profile, Set<SemanticProfile> serviceList);
	
}