/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.api.profile;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.inferred.InferredElement;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.registry.service.api.model.generic.GenericElement;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface SearchElement extends GenericElement<SearchElement> {
	
	/**
	 * Find all equivalent of involved concepts and return an infered profile.
	 * Each concept is rated according to semantic distance from the initial concept.
	 * 
	 * @param reasoner to use
	 * @param matcher properties
	 * @return infered semantic element
	 */
	public InferredElement infer(Reasoner reasoner, MatcherProperties props);
	
}