/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.api.profile.rated;

import com.petalslink.easiersbs.matching.service.api.matcher.DegreeOfMatch;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public interface RatedSemanticProfile extends Comparable<RatedSemanticProfile> {

	// Profile
	SemanticProfile getProfile();
	
	double getProfileRate();
	
	void setProfileRate(double rate);
	
	
	// Operation
	double getOperationRate();
	
	void setOperationRate(double rate);
	
	
	// Input
	DegreeOfMatch getInputCoverage();
	
	void setInputCoverage(DegreeOfMatch coverage);
	
	double getInputRate();
	
	void setInputRate(double rate);
	
	
	// Output
	DegreeOfMatch getOutputCoverage();
	
	void setOutputCoverage(DegreeOfMatch coverage);
	
	double getOutputRate();
	
	void setOutputRate(double rate);
	
	
}
