/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasySWS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasySWS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.profile;

import java.util.HashSet;
import java.util.Set;

import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.profile.Element;
import com.petalslink.easiersbs.matching.service.api.profile.Part;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedSearchProfile;
import com.petalslink.easiersbs.matching.service.profile.infered.InferedSearchProfileImpl;
import com.petalslink.easiersbs.reasoner.api.engine.Reasoner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticElement;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;


/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class SearchProfileImpl implements SearchProfile {

	private Set<Element> semanticInputs = new HashSet<Element>();
	private Set<Element> semanticOutputs = new HashSet<Element>();
	private Part semanticOperation = null;
	private Part semanticInterface = null;
	
	public SearchProfileImpl(){
		
	}
	
	public SearchProfileImpl(SemanticProfile profile){
		this.semanticInterface = new PartImpl(profile.getSemanticInterface());
		this.semanticOperation = new PartImpl(profile.getSemanticOperation());
		for(SemanticElement input : profile.getInputSemanticElements()){
			this.semanticInputs.add(new ElementImpl(input));
		}
		for(SemanticElement output : profile.getOutputSemanticElements()){
			this.semanticOutputs.add(new ElementImpl(output));
		}
	}
	
	public SearchProfileImpl(Part semanticInterface, Part semanticOperation, 
				Set<Element> semanticInputs, Set<Element> semanticOutputs){
		this.semanticInterface = semanticInterface;
		this.semanticOperation = semanticOperation;
		if(semanticInputs != null) this.semanticInputs = semanticInputs;
		if(semanticOutputs != null) this.semanticOutputs = semanticOutputs;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.SimpleProfile#addInputSemanticElement(com.petalslink.easiersbs.matching.service.api.profile.SemanticElement)
	 */
	@Override
	public void addInputSemanticElement(Element semanticInput) {
		semanticInputs.add(semanticInput);
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.SimpleProfile#addOutputSemanticElement(com.petalslink.easiersbs.matching.service.api.profile.SemanticElement)
	 */
	@Override
	public void addOutputSemanticElement(Element semanticOutput) {
		semanticOutputs.add(semanticOutput);
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.SimpleProfile#getInputSemanticElements()
	 */
	@Override
	public Set<Element> getInputSemanticElements() {
		return semanticInputs;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.SimpleProfile#getOutputSemanticElements()
	 */
	@Override
	public Set<Element> getOutputSemanticElements() {
		return semanticOutputs;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.SimpleProfile#getSemanticInterface()
	 */
	@Override
	public Part getSemanticInterface() {
		return semanticInterface;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.SimpleProfile#getSemanticOperation()
	 */
	@Override
	public Part getSemanticOperation() {
		return semanticOperation;
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.SimpleProfile#removeInputSemanticElement(com.petalslink.easiersbs.matching.service.api.profile.SemanticElement)
	 */
	@Override
	public void removeInputSemanticElement(Element semanticInput) {
		semanticInputs.remove(semanticInput);
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.SimpleProfile#removeOutputSemanticElement(com.petalslink.easiersbs.matching.service.api.profile.SemanticElement)
	 */
	@Override
	public void removeOutputSemanticElement(Element semanticOutput) {
		semanticOutputs.remove(semanticOutput);
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.SimpleProfile#setSemanticInterface(com.petalslink.easiersbs.matching.service.api.profile.SemanticPart)
	 */
	@Override
	public void setSemanticInterface(Part semanticInterface) {
		this.semanticInterface = semanticInterface;		
	}

	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.SimpleProfile#setSemanticOperation(com.petalslink.easiersbs.matching.service.api.profile.SemanticPart)
	 */
	@Override
	public void setSemanticOperation(Part semanticOperation) {
		this.semanticOperation = semanticOperation;
	}


	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.SimpleProfile#infer()
	 */
	@Override
	public InferedSearchProfile infer(Reasoner reasoner, MatcherProperties props) {
		InferedSearchProfile result = new InferedSearchProfileImpl();
		result.setSemanticInterface(semanticInterface.infer(reasoner, props));
		result.setSemanticOperation(semanticOperation.infer(reasoner, props));
		for(Element semanticInput : semanticInputs){
			result.addInputSemanticElement(semanticInput.infer(reasoner, props));
		}
		for(Element semanticOutput : semanticOutputs){
			result.addOutputSemanticElement(semanticOutput.infer(reasoner, props));
		}
		return result;
	}

	@Override
	public String toString(){
		StringBuilder str = new StringBuilder();
		str.append("++++++++++++++++++++++");
		str.append("\nSearchProfile:");
		str.append("\n\tOperation: " + semanticOperation.toString());
		str.append("\n\tInterface: " + semanticOperation.toString());
		str.append("\n\tInput(s): ");
		for(Element in : semanticInputs){
			str.append("\n\t\t" + in.toString());
		}
		str.append("\n\tOutput(s): ");
		for(Element out : semanticOutputs){
			str.append("\n\t\t" + out.toString());
		}
		str.append("\n++++++++++++++++++++++");
		return str.toString();
	}
	
	/* (non-Javadoc)
	 * @see com.petalslink.easiersbs.matching.service.api.profile.SimpleProfile#equals(com.petalslink.easiersbs.matching.service.api.profile.SimpleProfile)
	 */
	@Override
	public boolean equals(Object other) {
		if(other instanceof SearchProfile){
			if((this.semanticInterface != null && !this.semanticInterface.equals(((SearchProfile)other).getSemanticInterface()))
					|| (this.semanticOperation != null && !this.semanticOperation.equals(((SearchProfile)other).getSemanticOperation()))
					|| (!this.semanticInputs.equals(((SearchProfile)other).getInputSemanticElements()))
					|| (!this.semanticOutputs.equals(((SearchProfile)other).getOutputSemanticElements()))){
				return false;
			} else {
				return true;
			}
		}else{
			return false;
		}
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return this.toString().hashCode();
	}
	
}