/**
 * EasierSBS project - Java file
 * Copyright (C) 2011 EBM WebSourcing - Petals Link
 * 
 * EasierSBS is free project: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * EasierSBS is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this program.
 * If not, see <http://www.gnu.org/licenses/lgpl-3.0.txt>.	
 * 
 */ 
package com.petalslink.easiersbs.matching.service.util;

import java.util.HashSet;
import java.util.Set;

import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedElement;
import com.petalslink.easiersbs.matching.service.api.profile.infered.InferedSemanticConcept;
import com.petalslink.easiersbs.matching.service.api.profile.infered.RatedURI;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class ProfileUtil {

	public static Set<RatedURI> getFlattenRatedUris(InferedElement element){
		Set<RatedURI> res = new HashSet<RatedURI>();
		for(InferedSemanticConcept concept : element.getInferedSemanticConcepts()){
			res.addAll(concept.getRatedSemanticConcepts());
		}	
		return res;
	}
	
	public static Set<RatedURI> getFlattenRatedUris(Set<InferedElement> elements){
		Set<RatedURI> res = new HashSet<RatedURI>();
		for(InferedElement element : elements){
			res.addAll(getFlattenRatedUris(element));
		}	
		return res;
	}
	
}
