/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service.matcher;

import com.petalslink.easiersbs.matching.service.api.matcher.Matcher;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.MatchingResult;
import com.petalslink.easiersbs.matching.service.api.profile.SearchProfile;
import com.petalslink.easiersbs.matching.service.profile.SearchProfileImpl;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;
import com.petalslink.easiersbs.registry.service.api.model.Partner;
import com.petalslink.easiersbs.registry.service.api.model.SemanticProfile;
import com.petalslink.easiersbs.registry.service.impl.util.ServiceUtil;
import java.util.Set;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.service.api.Description;

public abstract class AbstractMatcherImpl
implements Matcher {
    protected SemanticRegistryManager registry;
    protected MatcherProperties props;

    public MatcherProperties getMatcherProperties() {
        return this.props;
    }

    public SemanticRegistryManager getSemanticRegistryManager() {
        return this.registry;
    }

    public MatchingResult findServices(SearchProfile searchProfile) {
        return this.findServices(searchProfile, this.registry.getAllSemanticProfiles());
    }

    public MatchingResult findServices(SearchProfile searchProfile, Partner partner) {
        return this.findServices(searchProfile, this.registry.findSemanticProfilesByPartner(partner));
    }

    public MatchingResult findServices(QName qName, Description description) {
        SemanticProfile semanticProfile = ServiceUtil.extractSemanticProfile((QName)qName, (Description)description);
        return this.findServices(new SearchProfileImpl(semanticProfile));
    }

    public MatchingResult findServices(QName qName, Description description, Partner partner) {
        SemanticProfile semanticProfile = ServiceUtil.extractSemanticProfile((QName)qName, (Description)description);
        return this.findServices((SearchProfile)new SearchProfileImpl(semanticProfile), partner);
    }

    public abstract MatchingResult findServices(SearchProfile var1, Set<SemanticProfile> var2);
}

