/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiersbs.matching.service;

import com.petalslink.easiersbs.matching.service.api.EasierSBSException;
import com.petalslink.easiersbs.matching.service.api.SBSFactory;
import com.petalslink.easiersbs.matching.service.api.matcher.HybridMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.MatcherProperties;
import com.petalslink.easiersbs.matching.service.api.matcher.SemanticMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.SyntacticMatcher;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityMeasure;
import com.petalslink.easiersbs.matching.service.api.matcher.similarity.SimilarityType;
import com.petalslink.easiersbs.matching.service.matcher.HybridMatcherImpl;
import com.petalslink.easiersbs.matching.service.matcher.SemanticMatcherImpl;
import com.petalslink.easiersbs.matching.service.matcher.SyntacticMatcherImpl;
import com.petalslink.easiersbs.matching.service.matcher.similarity.CosineSimilarityImpl;
import com.petalslink.easiersbs.matching.service.matcher.similarity.DiceSimilarityImpl;
import com.petalslink.easiersbs.matching.service.matcher.similarity.JaccardSimilarityImpl;
import com.petalslink.easiersbs.matching.service.matcher.similarity.JensenShannonSimilarityImpl;
import com.petalslink.easiersbs.reasoner.api.ReasonerException;
import com.petalslink.easiersbs.reasoner.api.ReasonerFactory;
import com.petalslink.easiersbs.registry.service.api.SemanticRegistryManager;

public class SBSFactoryImpl
implements SBSFactory {
    private static SBSFactory instance = new SBSFactoryImpl();

    private SBSFactoryImpl() {
    }

    public static SBSFactory getInstance() {
        return instance;
    }

    public HybridMatcher newHybridMatcher(ReasonerFactory reasonerFactory, SemanticRegistryManager semanticRegistryManager) throws ReasonerException, EasierSBSException {
        return new HybridMatcherImpl(reasonerFactory, semanticRegistryManager);
    }

    public HybridMatcher newHybridMatcher(ReasonerFactory reasonerFactory, SemanticRegistryManager semanticRegistryManager, MatcherProperties matcherProperties) throws ReasonerException, EasierSBSException {
        return new HybridMatcherImpl(reasonerFactory, semanticRegistryManager, matcherProperties);
    }

    public SyntacticMatcher newSyntacticMatcher(SemanticRegistryManager semanticRegistryManager) throws EasierSBSException {
        return new SyntacticMatcherImpl(semanticRegistryManager);
    }

    public SyntacticMatcher newSyntacticMatcher(SemanticRegistryManager semanticRegistryManager, MatcherProperties matcherProperties) throws EasierSBSException {
        return new SyntacticMatcherImpl(semanticRegistryManager, matcherProperties);
    }

    public SemanticMatcher newSemanticMatcher(ReasonerFactory reasonerFactory, SemanticRegistryManager semanticRegistryManager) throws ReasonerException {
        return new SemanticMatcherImpl(reasonerFactory, semanticRegistryManager);
    }

    public SemanticMatcher newSemanticMatcher(ReasonerFactory reasonerFactory, SemanticRegistryManager semanticRegistryManager, MatcherProperties matcherProperties) throws ReasonerException {
        return new SemanticMatcherImpl(reasonerFactory, semanticRegistryManager, matcherProperties);
    }

    public SimilarityMeasure newSimilarityMeasure(SimilarityType similarityType) throws EasierSBSException {
        if (similarityType == null) {
            throw new EasierSBSException("Type cannot be null!!!");
        }
        switch (similarityType) {
            case COSINE: {
                return new CosineSimilarityImpl();
            }
            case DICE: {
                return new DiceSimilarityImpl();
            }
            case JACCARD: {
                return new JaccardSimilarityImpl();
            }
            case JENSEN_SHANNON: {
                return new JensenShannonSimilarityImpl();
            }
        }
        throw new EasierSBSException("Unknown similarity type.");
    }

    public SimilarityMeasure newSimilarityMeasure(SimilarityType similarityType, int n) throws EasierSBSException {
        SimilarityMeasure similarityMeasure = this.newSimilarityMeasure(similarityType);
        similarityMeasure.setLevenshteinLimit(n);
        return similarityMeasure;
    }
}

