package org.petalslink.easiestdemo.client.topology;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.easiestdemo.client.gui.Property;

/**
 * The Ball class creates 5 balls.  Each ball increasingly blends
 * the color white with the specified color.
 */
public abstract class EndpointG {

	private double lastx = 0;
	private double lasty = 0;
	private boolean move = false;

	protected int size;
	protected Color color;
	protected Ellipse2D circle = null;
	protected TopologyView topology;
	protected List<Property> properties = new ArrayList<Property>();

	public EndpointG(TopologyView topology) {
		this.topology = topology;
	}

	protected void init() {
		this.circle = new Ellipse2D.Double(0, 0,
				size,
				size);
	}

	public void update(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;

		// Clears the rectangle that was previously drawn.
		if (move) {
			g2.setPaint(Color.white);
			g2.draw(new Ellipse2D.Double(lastx, lasty, size, size));
			lastx = this.circle.getCenterX();
			lasty = this.circle.getCenterY();
		}


		g2.setColor(this.color);
		g2.draw(this.circle);
		g2.fill(this.circle);
	}

	public boolean contains(int x, int y) {
		return this.circle.contains(x, y);
	}

	public void setLocation(int x, int y) {
		Point p = checkLocation(x, y);
		this.circle.setFrame(new Point2D.Double(p.x,p.y), new Dimension2D() {

			@Override
			public double getWidth() {
				return size;
			}

			@Override
			public double getHeight() {
				return size;
			}

			@Override
			public void setSize(double width, double height) {
				// do nothing
			}
		});
	}
	
	private Point checkLocation(int x, int y) {
		Point p = new Point(x, y);
		if(x < this.topology.getX()) {
			p.x = this.topology.getX();
		} else if(x > this.topology.getX() + this.topology.getWidth() - this.size) {
			p.x = this.topology.getX() + this.topology.getWidth() - this.size;
		}
		if(y < this.topology.getY()) {
			p.y = this.topology.getY();
		} else if(y > this.topology.getY() + this.topology.getHeight() - this.size) {
			p.y = this.topology.getY() + this.topology.getHeight() - this.size;
		}
		
		return p;
	}

	public double getCenterX() {
		return this.circle.getCenterX();
	}
	
	public double getCenterY() {
		return this.circle.getCenterY();
	}
	
	public boolean isMove() {
		return move;
	}

	public void setMove(boolean move) {
		this.move = move;
	}
	
	public int getSize() {
		return size;
	}
	
	public abstract QName getQName();
	
	public List<Property> getProperties() {
		return this.properties;
	}
}  

