/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.model.impl.esb;

import com.ebmwebsourcing.easierbsm.admin.client.api.BSMAdminClient;
import com.ebmwebsourcing.easierbsm.admin.client.impl.BSMAdminClientImpl;
import com.ebmwebsourcing.easiestdemo.contant.EasiestDEMOFramework;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easyesb.admin.client.api.AdminClient;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImpl;
import com.ebmwebsourcing.easyesb.component.bpel.impl.BPELProviderEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.behaviour.proxy.SoapProviderProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import easierbsm.petalslink.com.data.bsmadmin._1.GetNodeInformations;
import easierbsm.petalslink.com.data.bsmadmin._1.GetNodeInformationsResponse;
import easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbClientProxyEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbNodeType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbProviderEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbProviderProxyEndpointType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Service;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.ClientEndpointProxy;
import org.petalslink.easiestdemo.client.model.api.esb.ProviderEndpoint;
import org.petalslink.easiestdemo.client.model.api.esb.ProviderEndpointProxy;
import org.petalslink.easiestdemo.client.model.impl.esb.ClientEndpointProxyImpl;
import org.petalslink.easiestdemo.client.model.impl.esb.ProviderEndpointImpl;
import org.petalslink.easiestdemo.client.model.impl.esb.ProviderEndpointProxyImpl;
import org.w3c.dom.Document;

public class NodeImpl
implements org.petalslink.easiestdemo.client.model.api.esb.Node {
    private Description adminServiceDescription;
    private QName name = null;
    private List<QName> neighbourNodeNames = new ArrayList<QName>();
    private List<ProviderEndpoint> providerEndpoints = new ArrayList<ProviderEndpoint>();
    private List<ProviderEndpointProxy> providerEndpointProxies = new ArrayList<ProviderEndpointProxy>();
    private List<ClientEndpointProxy> clientEndpointProxies = new ArrayList<ClientEndpointProxy>();
    private Node model = null;
    private EJaxbBasicNodeInformationsType basicInfos = null;
    private boolean isMonitoringNode = false;
    private List<org.petalslink.easiestdemo.client.model.api.esb.Node> monitoredNodes = new ArrayList<org.petalslink.easiestdemo.client.model.api.esb.Node>();
    private AdminClient adminClient = null;
    private BSMAdminClient bsmadminClient = null;
    private Registry registry;

    public NodeImpl(Description desc, Registry registry) throws SOAPException {
        try {
            this.registry = registry;
            this.adminServiceDescription = desc;
            if (!this.adminServiceDescription.getDocumentBaseURI().toString().contains("bsmadminExternalEndpoint")) {
                this.adminClient = new AdminClientImpl(this.adminServiceDescription.getDocumentBaseURI().toString());
            } else {
                this.bsmadminClient = new BSMAdminClientImpl(this.adminServiceDescription.getDocumentBaseURI().toString());
            }
            EJaxbNodeType response = this.getState();
            this.analyzeState(response);
        }
        catch (WSOUIClientException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (ESBException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    @Override
    public AdminClient getAdminClient() {
        return this.adminClient;
    }

    @Override
    public BSMAdminClient getBSMAdminClient() {
        return this.bsmadminClient;
    }

    @Override
    public Node getModel() {
        return this.model;
    }

    @Override
    public void setModel(Node model) {
        this.model = model;
    }

    @Override
    public QName getQName() {
        return this.name;
    }

    @Override
    public Description getAdministrationServiceDescription() {
        return this.adminServiceDescription;
    }

    @Override
    public List<QName> getNeighbourNodeNames() {
        return this.neighbourNodeNames;
    }

    private EJaxbNodeType getState() throws SOAPException {
        try {
            EJaxbNodeType node = null;
            if (this.adminClient != null) {
                easyesb.petalslink.com.data.admin._1.GetNodeInformations request = new easyesb.petalslink.com.data.admin._1.GetNodeInformations();
                easyesb.petalslink.com.data.admin._1.GetNodeInformationsResponse response = this.adminClient.getNodeInformations(request);
                node = response.getNode();
            } else {
                GetNodeInformations request = new GetNodeInformations();
                GetNodeInformationsResponse response = this.bsmadminClient.getNodeInformations(request);
                node = response.getNode();
            }
            return node;
        }
        catch (easyesb.petalslink.com.service.admin._1_0.AdminExceptionMsg e) {
            throw new SOAPException((Throwable)e);
        }
        catch (AdminExceptionMsg e) {
            throw new SOAPException((Throwable)e);
        }
    }

    @Override
    public Document getStateOfNode() throws SOAPException {
        try {
            EJaxbNodeType response = this.getState();
            Document responseDoc = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response);
            return responseDoc;
        }
        catch (SOAException e) {
            throw new SOAPException((Throwable)e);
        }
    }

    @Override
    public void analyzeState(EJaxbNodeType node) throws WSOUIClientException {
        try {
            this.neighbourNodeNames.clear();
            this.providerEndpointProxies.clear();
            this.providerEndpoints.clear();
            this.clientEndpointProxies.clear();
            this.basicInfos = node.getBasicNodeInformations();
            this.name = this.basicInfos.getNodeName();
            for (EJaxbBasicNodeInformationsType nodeI : node.getRegistry().getNeighbourNode()) {
                this.neighbourNodeNames.add(nodeI.getNodeName());
            }
            for (EJaxbEndpointType ep : node.getRegistry().getLocalEndpointsGroupList().getEndpointGroup()) {
                for (String behaviour : ep.getBehavioursList().getBehaviour()) {
                    EJaxbProviderProxyEndpointType pep;
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(behaviour);
                    if (clazz == SoapProviderProxyBehaviourImpl.class) {
                        pep = (EJaxbProviderProxyEndpointType)ep;
                        this.analyzeProviderProxyEndpoint(pep);
                        continue;
                    }
                    if (clazz == BPELProviderEndpointBehaviourImpl.class) {
                        EJaxbProviderEndpointType pe = (EJaxbProviderEndpointType)ep;
                        this.analyzeProviderEndpoint(pe);
                        continue;
                    }
                    if (clazz != ClientProxyBehaviourImpl.class) continue;
                    pep = (EJaxbClientProxyEndpointType)ep;
                    this.analyzeClientProxyEndpoint((EJaxbClientProxyEndpointType)pep);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new WSOUIClientException(e);
        }
    }

    @Override
    public List<ProviderEndpoint> getProviderEndpoints() {
        return this.providerEndpoints;
    }

    @Override
    public List<ProviderEndpointProxy> getProviderEndpointProxies() {
        return this.providerEndpointProxies;
    }

    @Override
    public List<ClientEndpointProxy> getClientEndpointProxies() {
        return this.clientEndpointProxies;
    }

    private void analyzeClientProxyEndpoint(EJaxbClientProxyEndpointType cep) throws WSOUIClientException {
        try {
            URL wsdl = new URL(cep.getExternalAddress() + "?wsdl");
            Description description = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasiestDEMOFramework.getInstance()).get()).readDocument(wsdl, Definitions.class));
            Service sDesc = description.findService(cep.getProviderServiceName());
            if (sDesc == null) {
                throw new WSOUIClientException("Impossible to find service " + cep.getProviderServiceName() + " in description");
            }
            Endpoint epDesc = sDesc.getEndpoint(cep.getProviderEndpointName().getLocalPart());
            if (epDesc == null) {
                throw new WSOUIClientException("Impossible to find endpoint " + cep.getProviderEndpointName() + " in description");
            }
            this.clientEndpointProxies.add(new ClientEndpointProxyImpl(this, cep.getName(), epDesc, sDesc));
        }
        catch (MalformedURLException e) {
            throw new WSOUIClientException(e);
        }
        catch (XmlObjectReadException e) {
            throw new WSOUIClientException(e);
        }
        catch (SOAPException e) {
            throw new WSOUIClientException(e);
        }
    }

    private void analyzeProviderEndpoint(EJaxbProviderEndpointType pe) throws WSOUIClientException {
        try {
            URL wsdl = new URL(pe.getWsdlDescription());
            Description description = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasiestDEMOFramework.getInstance()).get()).readDocument(wsdl, Definitions.class));
            Service sDesc = description.findService(pe.getServiceName());
            if (sDesc == null) {
                throw new WSOUIClientException("Impossible to find service " + pe.getServiceName() + " in description");
            }
            Endpoint epDesc = sDesc.getEndpoint(pe.getName().getLocalPart());
            if (epDesc == null) {
                throw new WSOUIClientException("Impossible to find endpoint " + pe.getName() + " in description");
            }
            this.providerEndpoints.add(new ProviderEndpointImpl(this, epDesc, sDesc));
        }
        catch (MalformedURLException e) {
            throw new WSOUIClientException(e);
        }
        catch (XmlObjectReadException e) {
            throw new WSOUIClientException(e);
        }
    }

    private void analyzeProviderProxyEndpoint(EJaxbProviderProxyEndpointType pep) throws WSOUIClientException {
        try {
            URL wsdl = new URL(pep.getWsdlDescription());
            Description description = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasiestDEMOFramework.getInstance()).get()).readDocument(wsdl, Definitions.class));
            Service sDesc = description.findService(pep.getServiceName());
            if (sDesc == null) {
                throw new WSOUIClientException("Impossible to find service " + pep.getServiceName() + " in description");
            }
            Endpoint epDesc = sDesc.getEndpoint(pep.getName().getLocalPart());
            if (epDesc == null) {
                throw new WSOUIClientException("Impossible to find endpoint " + pep.getName() + " in description");
            }
            this.providerEndpointProxies.add(new ProviderEndpointProxyImpl(this, epDesc, sDesc));
        }
        catch (MalformedURLException e) {
            throw new WSOUIClientException(e);
        }
        catch (XmlObjectReadException e) {
            throw new WSOUIClientException(e);
        }
    }

    @Override
    public EJaxbBasicNodeInformationsType getBasicInfos() {
        return this.basicInfos;
    }

    @Override
    public void setBasicInfos(EJaxbBasicNodeInformationsType basicInfos) {
        this.basicInfos = basicInfos;
    }

    public String toString() {
        return this.name.getLocalPart();
    }

    @Override
    public boolean isMonitoringNode() {
        return this.isMonitoringNode;
    }

    @Override
    public void setMonitoringNode(boolean monitoring) {
        this.isMonitoringNode = monitoring;
    }

    @Override
    public List<org.petalslink.easiestdemo.client.model.api.esb.Node> getMonitoredNodes() throws WSOUIClientException {
        return this.monitoredNodes;
    }

    @Override
    public void refreshMonitoredNodes() throws WSOUIClientException {
        if (this.isMonitoringNode) {
            this.monitoredNodes.clear();
            try {
                for (String address : this.bsmadminClient.getConnectedEsbs()) {
                    System.out.println("address = " + address);
                    for (org.petalslink.easiestdemo.client.model.api.esb.Node n : this.registry.getAllNodes()) {
                        System.out.println("n.getAdministrationServiceDescription().getDocumentBaseURI().toString() = " + n.getAdministrationServiceDescription().getDocumentBaseURI().toString());
                        if (!n.getAdministrationServiceDescription().getDocumentBaseURI().toString().contains(address)) continue;
                        this.monitoredNodes.add(n);
                    }
                }
            }
            catch (AdminExceptionMsg e) {
                throw new WSOUIClientException(e);
            }
        }
    }
}

