/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.gui.edit;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import java.awt.Color;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.xml.parsers.DocumentBuilder;

public class XMLDocument
extends DefaultStyledDocument {
    public static String TAG_ELEMENT = "tag_element";
    public static String TAG_ROW_START_ELEMENT = "tag_row_start_element";
    public static String TAG_ROW_END_ELEMENT = "tag_row_end_element";
    private MutableAttributeSet element = null;
    private MutableAttributeSet elementValue = null;
    private MutableAttributeSet attribute = null;
    private MutableAttributeSet attributeValue = null;
    private DocumentBuilder db = DocumentBuilders.takeDocumentBuilder();

    protected void finalize() throws Throwable {
        super.finalize();
        DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)this.db);
    }

    public XMLDocument() {
        this.element = new SimpleAttributeSet();
        StyleConstants.setForeground(this.element, new Color(51, 102, 102));
        this.elementValue = new SimpleAttributeSet();
        StyleConstants.setForeground(this.elementValue, Color.black);
        this.attribute = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attribute, new Color(153, 51, 153));
        this.attributeValue = new SimpleAttributeSet();
        StyleConstants.setForeground(this.attributeValue, Color.blue);
    }

    @Override
    public void insertString(int arg0, String arg1, AttributeSet arg2) throws BadLocationException {
        super.insertString(arg0, arg1, arg2);
        this.colorize();
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
        this.colorize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void colorize() throws BadLocationException {
        String text = this.getText(0, this.getLength());
        int startIndex = 0;
        int endIndex = text.length() + 1;
        int openIndex = 0;
        int closeIndex = 0;
        boolean outOfTag = true;
        boolean attribute = false;
        boolean attributeValue = false;
        boolean egalValue = false;
        boolean print = true;
        int lastOpenIndex = -1;
        boolean testIfXmlDocument = false;
        testIfXmlDocument = text.endsWith(">");
        try {
            if (!testIfXmlDocument) return;
            while (startIndex <= endIndex) {
                openIndex = text.indexOf(60, startIndex);
                closeIndex = text.indexOf(62, startIndex);
                if (lastOpenIndex > openIndex) {
                    return;
                }
                if (openIndex != -1 && closeIndex == -1) {
                    return;
                }
                if (outOfTag) {
                    if (openIndex < 0) {
                        this.setCharacterAttributes(startIndex, endIndex + 1, this.elementValue, false);
                        return;
                    }
                    this.setCharacterAttributes(startIndex, openIndex - startIndex, this.elementValue, false);
                    startIndex = openIndex;
                    outOfTag = false;
                    attribute = false;
                } else if (closeIndex < 0) {
                    this.setCharacterAttributes(startIndex, endIndex + 1, this.element, false);
                } else {
                    for (int i = startIndex; i < closeIndex + 1; ++i) {
                        String character = text.substring(i, i + 1);
                        if (character.equals(" ")) {
                            attribute = !attribute;
                        }
                        if (character.equals("\"")) {
                            if (attributeValue) {
                                attributeValue = false;
                                print = false;
                                this.setCharacterAttributes(i, i + 1, this.attributeValue, false);
                            } else {
                                attributeValue = true;
                                attribute = false;
                            }
                        }
                        if (character.equals(">")) {
                            attribute = false;
                            attributeValue = false;
                        }
                        if (character.equals("=")) {
                            egalValue = true;
                            attribute = false;
                            attributeValue = false;
                        }
                        if (print) {
                            if (attribute) {
                                this.setCharacterAttributes(i, i + 1, this.attribute, false);
                            } else if (attributeValue) {
                                this.setCharacterAttributes(i, i + 1, this.attributeValue, false);
                            } else if (egalValue) {
                                this.setCharacterAttributes(i, i + 1, this.elementValue, false);
                                egalValue = false;
                            } else {
                                this.setCharacterAttributes(i, i + 1, this.element, false);
                            }
                        }
                        if (!character.equals("\"")) continue;
                        print = true;
                    }
                    startIndex = closeIndex + 1;
                    outOfTag = true;
                    attribute = false;
                    attributeValue = false;
                    egalValue = false;
                }
                lastOpenIndex = openIndex;
            }
            return;
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

