/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.gui;

import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.gui.WSDLFrame;
import org.petalslink.easiestdemo.client.model.api.ws.MockBinding;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockOperation;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;
import org.w3c.dom.Document;

public class MenuMouseRegistryTree
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = Logger.getLogger(MenuMouseRegistryTree.class.getName());
    private JMenuItem jMenuItemGetWSDL;
    private WSOUIClient scw;
    private MockService service;
    private MockEndpoint endpoint;
    private MockBinding binding;
    private MockOperation operation;

    public MenuMouseRegistryTree(WSOUIClient scw) {
        this.scw = scw;
        this.initComponents();
    }

    private void cleanGUIComponent() {
        this.scw.getjTextFieldEndpointName().setText("");
        this.scw.getjTextFieldInterfaceQName().setText("");
        this.scw.getjTextFieldOperationName().setText("");
        this.scw.getjTextFieldServiceQName().setText("");
        this.scw.getjTextFieldSendTo().setText("");
    }

    public Object getSelectedItem() {
        Object res = null;
        if (this.service != null) {
            res = this.service;
        } else if (this.endpoint != null) {
            res = this.endpoint;
        } else if (this.binding != null) {
            res = this.binding;
        } else if (this.operation != null) {
            res = this.operation;
        }
        return res;
    }

    public void setService(MockService service) {
        this.service = service;
        this.endpoint = null;
        this.operation = null;
        this.binding = null;
        this.jMenuItemGetWSDL.setEnabled(true);
    }

    public void setEndpoint(MockEndpoint endpoint) {
        this.endpoint = endpoint;
        this.service = null;
        this.operation = null;
        this.binding = null;
        this.jMenuItemGetWSDL.setEnabled(true);
    }

    public void setBinding(MockBinding b) {
        this.binding = b;
        this.endpoint = null;
        this.service = null;
        this.operation = null;
        this.jMenuItemGetWSDL.setEnabled(true);
    }

    public void setOperation(MockOperation op) {
        this.operation = op;
        this.endpoint = null;
        this.binding = null;
        this.service = null;
        this.jMenuItemGetWSDL.setEnabled(true);
    }

    private void initComponents() {
        this.jMenuItemGetWSDL = new JMenuItem();
        this.setComponentPopupMenu(this);
        this.jMenuItemGetWSDL.setText("Get service contract (WSDL)");
        this.jMenuItemGetWSDL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuMouseRegistryTree.this.jMenuItemGetWSDLActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemGetWSDL);
    }

    private void jMenuItemGetWSDLActionPerformed(ActionEvent evt) {
        try {
            Description def = null;
            if (this.getSelectedItem() instanceof MockService) {
                def = ((MockService)this.getSelectedItem()).getDescription();
            } else if (this.getSelectedItem() instanceof MockEndpoint) {
                def = ((MockEndpoint)this.getSelectedItem()).getService().getDescription();
            } else if (this.getSelectedItem() instanceof MockBinding) {
                def = ((MockBinding)this.getSelectedItem()).getEndpoint().getService().getDescription();
            } else if (this.getSelectedItem() instanceof MockOperation) {
                def = ((MockOperation)this.getSelectedItem()).getBinding().getEndpoint().getService().getDescription();
            }
            WSDLFrame wsdl = new WSDLFrame(XMLPrettyPrinter.prettyPrint((Document)def.write()));
            wsdl.setVisible(true);
            LOG.finest(this.getSelectedItem() + " has been selected");
            this.setVisible(false);
        }
        catch (XmlObjectWriteException e) {
            LOG.finest("Error to get WSDL Description: " + e.getMessage());
            this.setVisible(false);
        }
    }

    public void jMenuItemSetAllActionPerformed(ActionEvent evt) {
        this.cleanGUIComponent();
        if (this.getSelectedItem() instanceof MockService) {
            this.scw.getjTextFieldServiceQName().setText(((MockService)this.getSelectedItem()).getQName().toString());
        } else if (this.getSelectedItem() instanceof MockEndpoint) {
            this.scw.getjTextFieldServiceQName().setText(((MockEndpoint)this.getSelectedItem()).getService().getQName().toString());
            this.scw.getjTextFieldEndpointName().setText(((MockEndpoint)this.getSelectedItem()).getName());
        } else if (this.getSelectedItem() instanceof MockBinding) {
            MockBinding b = (MockBinding)this.getSelectedItem();
            this.scw.getjTextFieldServiceQName().setText(b.getEndpoint().getService().getQName().toString());
            this.scw.getjTextFieldEndpointName().setText(b.getEndpoint().getName());
            this.scw.getjTextFieldInterfaceQName().setText(b.getInterfaceQName().toString());
        } else if (this.getSelectedItem() instanceof MockOperation) {
            MockOperation bop = (MockOperation)this.getSelectedItem();
            this.scw.getjTextFieldServiceQName().setText(bop.getBinding().getEndpoint().getService().getQName().toString());
            this.scw.getjTextFieldEndpointName().setText(bop.getBinding().getEndpoint().getName());
            this.scw.getjTextFieldInterfaceQName().setText(bop.getBinding().getInterfaceQName().toString());
            this.scw.getjTextFieldOperationName().setText(bop.getName());
            this.scw.getjTextFieldSendTo().setText(bop.getBinding().getEndpoint().getAddress());
        }
        LOG.finest(this.getSelectedItem() + " has been selected");
        this.setVisible(false);
    }
}

