/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * TopologyView.java
 *
 * Created on 17 mars 2011, 22:32:08
 */
package org.petalslink.easiestdemo.client.topology;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.JPanel;
import javax.xml.namespace.QName;

import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.gui.PropertiesTableModel;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.ClientEndpointProxy;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.gov.ProvidedService;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;
import org.petalslink.easiestdemo.client.model.impl.gov.ProvidedServiceImpl;
import org.petalslink.easiestdemo.client.topology.menu.MenuMouseTopology;
import org.petalslink.easiestdemo.client.topology.menu.action.CallWebServiceFrame;

import com.ebmwebsourcing.easierbsm.datacollector.ESBDataCollectorFactoryImpl;
import com.petalslink.easycommons.explorer.TextG;

/**
 *
 * @author Nico
 */
public class TopologyView extends JPanel {

	private List<ExternalClientEndpointG> externalClientEndpoints = new ArrayList<ExternalClientEndpointG>();
	private List<ExternalProviderEndpointG> externalProviderEndpoints = new ArrayList<ExternalProviderEndpointG>();
	private List<LineEsbToEsbG> esblines = new ArrayList<LineEsbToEsbG>();
	private List<LineMonitoringToEsbG> monitoringlines = new ArrayList<LineMonitoringToEsbG>();
	private List<LineEsbToGovG> govlines = new ArrayList<LineEsbToGovG>();
	private List<LineEsbOrGovToEndpointG> lines = new ArrayList<LineEsbOrGovToEndpointG>();
	private List<EsbG> esbs = new ArrayList<EsbG>();
	private GovG govg = null;
	private TextG internalEndpointToPrint = null;

	private WSOUIClient client = null;
	private Registry registry = null;
	private Object draggedItem = null;

	boolean pressOut = false;

	private MenuMouseTopology mmt = null;;

	/** Creates new form TopologyView */
	public TopologyView(Dimension dim, WSOUIClient client) {
		initComponents();
		setBackground(Color.white);
		this.setSize(dim);
		this.client = client;
		if(client != null) {
			this.registry = client.getRegistry();

			this.mmt = new MenuMouseTopology(this.client);


			this.draggedItem = null;
			this.refresh();
		}

	}


	public void refresh() {


		int init_x = (int)this.getSize().getWidth() / 2 - EsbG.DEFAULT_WIDTH/2;
		int spacey = this.getSize().height/ (this.registry.getAllNodes().size()+1);
		int init_y = spacey;

		int init_client_x = 0 ;
		int spacey_client = 0;
		int init_client_y = spacey_client;
		for(Node node: this.registry.getAllNodes()) {
			if(findEsbGCorrespondingToThisNode(node) == null) {
				this.esbs.add(new EsbG(this, node, init_x, init_y - EsbG.DEFAULT_HEIGHT/2));
				init_y = init_y + spacey;
			}
			init_client_x = (int) (this.getSize().width * 1/5)/2 ;
			spacey_client = this.getSize().height/ (this.registry.getAllClientEndpointProxy().size()+1);
			init_client_y = spacey_client;
			for(ClientEndpointProxy client: node.getClientEndpointProxies()) {
				if(findExternalClientEndpointGCorrespondingToThisEndpoint(client) == null) {
					this.externalClientEndpoints.add(new ExternalClientEndpointG(this, client, init_client_x, init_client_y));
					init_client_y = init_client_y + spacey_client;
				}
			}
		}
		if(this.registry.getGovNode() != null) {
			this.govg = new GovG(this, this.registry.getGovNode(), (int) (this.getSize().width - (EsbG.DEFAULT_WIDTH + 10)), 10);
			init_client_x = (int) (this.getSize().width - (EsbG.DEFAULT_WIDTH + EsbG.DEFAULT_WIDTH/2)) ;
			spacey_client = this.getSize().height / (this.registry.getGovNode().getProvidedServices().size()+1);
			init_client_y = spacey_client;
			for(ProvidedService providedService: this.registry.getGovNode().getProvidedServices()) {
				if(findExternalClientEndpointGCorrespondingToThisEndpoint(providedService) == null) {
					this.externalClientEndpoints.add(new ExternalClientEndpointG(this, providedService, init_client_x, init_client_y));
					init_client_y = init_client_y + spacey_client;
				}
			}
		}

		init_x = (int) (this.getSize().width * 4/5 + (this.getSize().width * 1/5)/2) ;
		spacey = this.getSize().height/ (this.registry.getAllWebServicesPartnerEndpoint().size()+1);
		init_y = spacey;
		for(MockService service: this.registry.getWebServices()) {
			for(MockEndpoint endpoint: service.getEndpoints()) { 
				if(findExternalProviderEndpointGCorrespondingToThisEndpoint(endpoint) == null) {
					this.externalProviderEndpoints.add(new ExternalProviderEndpointG(this, endpoint, init_x, init_y));
					init_y = init_y + spacey;
				}
			}
		}


		this.repaint();

	}

	private ExternalProviderEndpointG findExternalProviderEndpointGCorrespondingToThisEndpoint(
			MockEndpoint endpoint) {
		ExternalProviderEndpointG res = null;
		for(ExternalProviderEndpointG provider: this.externalProviderEndpoints) {
			if(provider.getQName().getLocalPart().equals(endpoint.getName())) {
				res = provider;
				break;
			}
		}
		return res;
	}


	private ExternalClientEndpointG findExternalClientEndpointGCorrespondingToThisEndpoint(
			ClientEndpointProxy ep) {
		ExternalClientEndpointG res = null;
		for(ExternalClientEndpointG client: this.externalClientEndpoints) {
			if(!(client.getModel() instanceof ProvidedServiceImpl)) {
				if(client.getModel().getName().getLocalPart().equals(ep.getName().getLocalPart())
						&& client.getModel().getNode().getQName().equals(ep.getNode().getQName())) {
					res = client;
					break;
				}
			}
		}
		return res;
	}


	private EsbG findEsbGCorrespondingToThisNode(Node node) {
		EsbG res = null;
		for(EsbG esb: this.esbs) {
			if(esb.getModel() == node) {
				res = esb;
				break;
			}
		}
		return res;
	}


	public Object getObjectContainedIn(java.awt.event.MouseEvent evt) {
		Object res = null;

		for(EsbG esb: esbs) {
			for(InternalClientProxyEndpointG icpe: esb.getProxyClients()) {
				if (res == null && icpe.contains(evt.getX(), evt.getY())) {
					res = icpe;
					break;
				} 
			}

			if(res == null) {
				for(InternalProviderProxyEndpointG ippe: esb.getProxyProviders()) {
					if (res == null && ippe.contains(evt.getX(), evt.getY())) {
						res = ippe;
						break;
					} 
				}
			}

			if(res == null) {
				for(InternalProviderEndpointG ipe: esb.getProviders()) {
					if (res == null && ipe.contains(evt.getX(), evt.getY())) {
						res = ipe;
						break;
					} 
				}
			}

			if (res == null && esb.contains(evt.getX(), evt.getY())) {
				res = esb;
				break;
			} 


		}

		if(res == null) {
			for(ExternalProviderEndpointG pe: this.externalProviderEndpoints) {
				if (pe.contains(evt.getX(), evt.getY())) {
					res = pe;
					break;
				} 
			}
		}

		if(res == null) { 
			for(ExternalClientEndpointG ce: this.externalClientEndpoints) {
				if (ce.contains(evt.getX(), evt.getY())) {
					res = ce;
					break;
				} 
			}
		}

		if(res == null) {
			if(this.govg != null) {
				for(ProvidedServiceG providedService: this.govg.getProvidedServices()) {
					if (res == null && providedService.contains(evt.getX(), evt.getY())) {
						res = providedService;
						break;
					} 
				}
			}
		}
		return res;
	}


	public void clear() {
		this.esbs.clear();
		this.externalClientEndpoints.clear();
		this.externalProviderEndpoints.clear();
		this.draggedItem = null;
	}

	public EsbG findEsbG(QName name) {
		EsbG res = null;
		for(EsbG esb: this.esbs) {
			if(esb.getQName().equals(name)) {
				res = esb;
				break;
			}
		}
		return res;
	}

	@Override
	public void paint(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;
		g2.setPaint(Color.white);
		g2.drawRect(0, 0, (int) this.getWidth(), (int) this.getHeight());
		g2.fillRect(0, 0, (int) this.getWidth(), (int) this.getHeight());

		// create lines between esbs
		esblines.clear();
		monitoringlines.clear();
		govlines.clear();
		for(EsbG esb1: esbs) {
			for(QName neighbourName: esb1.getNeighbourNodeNames()) {
				EsbG esb2 = this.findEsbG(neighbourName);
				esblines.add(new LineEsbToEsbG(esb1, esb2));
			}

			// create lines between monitoring and esb
			if(esb1.getModel().isMonitoringNode()) {
				// get dispatcher external endpoint
				ExternalClientEndpointG dispatcherEp = null;
				for(InternalClientProxyEndpointG ic: esb1.getProxyClients()) {
					if(ic.getQName().getLocalPart().equals(ESBDataCollectorFactoryImpl.DISPATCHER_PROVIDER_ENDPOINT_NAME )) {
						dispatcherEp = this.findExternalClientEndpointGCorrespondingToThisEndpoint((ClientEndpointProxy) ic.getModel());
						break;
					}
				}

				if(dispatcherEp != null) {
					// connect to esb
					try {
						for(Node n: esb1.getModel().getMonitoredNodes()) {
							EsbG esb2 = this.findEsbG(n.getQName());
							if(esb2 != null) {
								monitoringlines.add(new LineMonitoringToEsbG(dispatcherEp, esb2));
							}
						}
					} catch (WSOUIClientException e) {
						// do nothing
						e.printStackTrace();
					}
				}
			}
		}

		if(govg != null) {
			try {
				for(Node n: this.registry.getGovNode().getConnectedNodes()) {
					EsbG esb = this.findEsbGCorrespondingToThisNode(n);
					// get resources external endpoint
					ExternalClientEndpointG resourceEp = null;
					for(InternalClientProxyEndpointG ic: esb.getProxyClients()) {
						if(ic.getQName().getLocalPart().equals("resourcesEndpoint_" + esb.getQName().getLocalPart())) {
							resourceEp = this.findExternalClientEndpointGCorrespondingToThisEndpoint((ClientEndpointProxy) ic.getModel());
							break;
						}
					}
					if(resourceEp != null) {
						// connect to gov
						govlines.add(new LineEsbToGovG(resourceEp, govg));
					}
				}
			} catch (WSOUIClientException e) {
				// do nothing
				e.printStackTrace();
			}
		}

		for (LineEsbToEsbG line : this.esblines) {
			line.update(g);
		}

		for (LineMonitoringToEsbG line : this.monitoringlines) {
			line.update(g);
		}

		for (LineEsbToGovG line : this.govlines) {
			line.update(g);
		}

		for(EsbG esb: esbs) {
			esb.update(g);
		}

		lines.clear();
		if(govg != null) {
			// lines between clientProxyEndpoint and providedService of gov
			for(ProvidedServiceG icpe: this.govg.getProvidedServices()) {
				for(ExternalClientEndpointG ece: this.externalClientEndpoints) {
					if(icpe.getQName().equals(ece.getQName())) {
						lines.add(new LineEsbOrGovToEndpointG(icpe, ece));
					}
				}
			}
		}

		// create all others lines
		for(EsbG esb: this.esbs) {
			// lines between providerProxyEndpoint and externalProviderEndpoint
			for(InternalProviderProxyEndpointG ippe: esb.getProxyProviders()) {
				for(ExternalProviderEndpointG epe: this.externalProviderEndpoints) {
					if(ippe.getQName().equals(epe.getQName())) {
						lines.add(new LineEsbOrGovToEndpointG(ippe, epe));
					}
				}
			}

			// lines between clientProxyEndpoint and externalClientEndpoint
			for(InternalClientProxyEndpointG icpe: esb.getProxyClients()) {
				for(ExternalClientEndpointG ece: this.externalClientEndpoints) {
					if(icpe.getQName().equals(ece.getQName())) {
						lines.add(new LineEsbOrGovToEndpointG(icpe, ece));
					}
				}
			}
		}

		for (LineEsbOrGovToEndpointG line : this.lines) {
			line.update(g);
		}

		if(this.govg != null) {
			govg.update(g);
		}

		for (EndpointG ce : externalClientEndpoints) {
			ce.update(g);
		}

		for (EndpointG pe : externalProviderEndpoints) {
			pe.update(g);
		}

		if(this.internalEndpointToPrint != null) {
			g.setColor(this.internalEndpointToPrint.getColor());
			g.drawString(this.internalEndpointToPrint.getText(), (int)this.internalEndpointToPrint.getX(), (int)this.internalEndpointToPrint.getY());
		}

		g.dispose();
	}

	public static void main(String argv[]) {
		final TopologyView topology = new TopologyView(new Dimension(1100, 600), null);

		Frame f = new Frame("Topology View");
		f.addWindowListener(new WindowAdapter() {

			@Override
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		f.add(topology);
		f.pack();


		f.setVisible(true);
		f.repaint();
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		addMouseListener(new java.awt.event.MouseAdapter() {
			public void mouseClicked(java.awt.event.MouseEvent evt) {
				formMouseClicked(evt);
			}
			public void mouseEntered(java.awt.event.MouseEvent evt) {
				formMouseEntered(evt);
			}
			public void mousePressed(java.awt.event.MouseEvent evt) {
				formMousePressed(evt);
			}
			public void mouseReleased(java.awt.event.MouseEvent evt) {
				formMouseReleased(evt);
			}
		});
		addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
			public void mouseDragged(java.awt.event.MouseEvent evt) {
				formMouseDragged(evt);
			}
			public void mouseMoved(java.awt.event.MouseEvent evt) {
				formMouseMoved(evt);
			}
		});

		javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
		this.setLayout(layout);
		layout.setHorizontalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGap(0, 887, Short.MAX_VALUE)
				);
		layout.setVerticalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGap(0, 557, Short.MAX_VALUE)
				);
	}// </editor-fold>//GEN-END:initComponents

	private void formMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseClicked
		this.repaint();
		mmt.setVisible(false);
		Object selectedItem = this.getObjectContainedIn(evt);
		if(evt.getButton() == MouseEvent.BUTTON3) {
			mmt.setSelectedItem(selectedItem);
			mmt.setLocation(evt.getX() + this.client.getX(), evt.getY() + this.client.getY() + 70);
			mmt.setVisible(true);

		} else if(evt.getButton() == MouseEvent.BUTTON1 && evt.getClickCount() == 2 && selectedItem instanceof ExternalEndpointG) {
			CallWebServiceFrame callWebService = new CallWebServiceFrame(this.client, (ExternalEndpointG) selectedItem);
			callWebService.setVisible(true);
		}
	}//GEN-LAST:event_formMouseClicked

	private void formMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseDragged
		if(draggedItem != null) {
			if(draggedItem instanceof EsbG) {
				((EsbG)draggedItem).setLocation(evt.getX(), evt.getY());
			} else if(draggedItem instanceof EndpointG) {
				((EndpointG)draggedItem).setLocation(evt.getX(), evt.getY());
			} else if(draggedItem instanceof GovG) {
				((GovG)draggedItem).setLocation(evt.getX(), evt.getY());
			} 
			this.repaint();
		}		
	}//GEN-LAST:event_formMouseDragged

	private void formMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMousePressed
		draggedItem = null;
		for(EsbG esb: esbs) {
			if (esb.contains(evt.getX(), evt.getY())) {
				draggedItem = esb;
				esb.setMove(true);
				break;
			} 
		}
		if(draggedItem == null) {
			for(ExternalProviderEndpointG pe: this.externalProviderEndpoints) {
				if (pe.contains(evt.getX(), evt.getY())) {
					draggedItem = pe;
					pe.setMove(true);
					break;
				} 
			}
		}
		if(draggedItem == null){
			for(ExternalClientEndpointG ce: this.externalClientEndpoints) {
				if (ce.contains(evt.getX(), evt.getY())) {
					draggedItem = ce;
					ce.setMove(true);
					break;
				} 
			}
		}
		if(draggedItem == null){
			if(this.govg != null) {
				if (this.govg.contains(evt.getX(), evt.getY())) {
					draggedItem = this.govg;
					this.govg.setMove(true);
				} 
			}
		}
	}//GEN-LAST:event_formMousePressed

	private void formMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseReleased
		if(draggedItem instanceof EsbG) {
			((EsbG)draggedItem).setMove(false);
		}
		if(draggedItem instanceof EndpointG) {
			((EndpointG)draggedItem).setMove(false);
		}
		if(draggedItem instanceof GovG) {
			((GovG)draggedItem).setMove(false);
		}
		draggedItem = null;
	}//GEN-LAST:event_formMouseReleased

	private void formMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseMoved
		Object selectedItem = this.getObjectContainedIn(evt);
		if(selectedItem instanceof EsbG) {
			this.client.getjTableProperties().setModel(new PropertiesTableModel(((EsbG)selectedItem).getProperties()));
		} else if(selectedItem instanceof EndpointG) {
			this.client.getjTableProperties().setModel(new PropertiesTableModel(((EndpointG)selectedItem).getProperties()));
			if(selectedItem instanceof InternalProviderEndpointG) {
				InternalProviderEndpointG ipe = (InternalProviderEndpointG) selectedItem;
				this.internalEndpointToPrint = new TextG(ipe.getQName().getLocalPart(), Color.black, (int)ipe.getCenterX() - (ipe.getSize()/2), (int)ipe.getCenterY() + ipe.getSize());
			} else {
				this.internalEndpointToPrint = null;
			}
		} else if(selectedItem instanceof GovG) {
			this.client.getjTableProperties().setModel(new PropertiesTableModel(((GovG)selectedItem).getProperties()));
		} else if(selectedItem instanceof ProvidedServiceG) {
			ProvidedServiceG ipe = (ProvidedServiceG) selectedItem;
			this.internalEndpointToPrint = new TextG(ipe.getQName().getLocalPart(), Color.black, (int)ipe.getCenterX() - (ipe.getSize()/2), (int)ipe.getCenterY() + ipe.getSize());
		}

		this.repaint();
	}//GEN-LAST:event_formMouseMoved

	private void formMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseEntered

	}//GEN-LAST:event_formMouseEntered

	// Variables declaration - do not modify//GEN-BEGIN:variables
	// End of variables declaration//GEN-END:variables
}
