package org.petalslink.easiestdemo.client.topology;

import java.awt.Color;

import javax.xml.namespace.QName;

import org.petalslink.easiestdemo.client.gui.Property;
import org.petalslink.easiestdemo.client.model.api.esb.Endpoint;
import org.petalslink.easiestdemo.client.model.api.esb.ProviderEndpointProxy;

/**
 * The Ball class creates 5 balls.  Each ball increasingly blends
 * the color white with the specified color.
 */
public class InternalProviderProxyEndpointG extends InternalEndpointG {

	public static int DEFAULT_SIZE = 10; 
	
	private ProviderEndpointProxy model;
	
    public InternalProviderProxyEndpointG(TopologyView topology, ProviderEndpointProxy pep) {
    	super(topology);
    	this.model = pep;
        this.color = Color.green;
        this.size = DEFAULT_SIZE;
        this.init();
        
        this.properties.add(new Property("name", this.getQName().getLocalPart()));
		this.properties.add(new Property("namespace", this.getQName().getNamespaceURI()));
        this.properties.add(new Property("wsdl url", this.model.getEndpoint().getService().getDescription().getDocumentBaseURI()));
		this.properties.add(new Property("node", this.getModel().getNode().getQName().toString()));
    }

	@Override
    public QName getQName() {
    	return new QName(this.model.getService().getQName().getNamespaceURI(), this.model.getEndpoint().getName());
    }

	@Override
	public Endpoint getModel() {
		return this.model;
	}
}  

