package org.petalslink.easiestdemo.client.topology;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;

/**
 * The Ball class creates 5 balls.  Each ball increasingly blends
 * the color white with the specified color.
 */
public class LineEsbOrGovToEndpointG {

	private Line2D line = null;

	protected int size;
	protected Color color;
 
	private EndpointG internal;
	private EndpointG external;

	public LineEsbOrGovToEndpointG(InternalProviderProxyEndpointG internalp, ExternalProviderEndpointG externalp) {
		this.internal = internalp;
		this.external = externalp;
		this.color = Color.green;
		this.line = new Line2D.Double(this.internal.getCenterX(), this.internal.getCenterY(), this.external.getCenterX(), this.external.getCenterY());
	}

	
	public LineEsbOrGovToEndpointG(InternalClientProxyEndpointG internalc, ExternalClientEndpointG externalc) {
		this.internal = internalc;
		this.external = externalc;
		this.color = Color.magenta;
		this.line = new Line2D.Double(this.internal.getCenterX(), this.internal.getCenterY(), this.external.getCenterX(), this.external.getCenterY());
	}

	public LineEsbOrGovToEndpointG(ProvidedServiceG icpe, ExternalClientEndpointG ece) {
        this.internal = icpe;
        this.external = ece;
        this.color = Color.darkGray;
        this.line = new Line2D.Double(this.internal.getCenterX(), this.internal.getCenterY(), this.external.getCenterX(), this.external.getCenterY());
    }


    public void update(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;


		g2.setColor(this.color);
		g2.draw(this.line);
		g2.fill(this.line);
	}

	public boolean contains(int x, int y) {
		return this.line.contains(x, y);
	}

	public void setLocation(int x1, int y1, int x2, int y2) {
		this.line.setLine(x1, y1, x2, y2);
	}
}  

