/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.petalslink.easiestdemo.client.WSDLFilter;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;

public class AddWsdlFrame
extends JFrame {
    private WSOUIClient client;
    private JButton jButtonBrowse;
    private JButton jButtonOK;
    private JLabel jLabelAddWsdl;
    private JPanel jPanelMain;
    private JTextField jTextFieldAddWsdl;

    public AddWsdlFrame(WSOUIClient client) {
        this.initComponents();
        this.setTitle("Add new Web Service");
        if (client != null) {
            this.jPanelMain.setBackground(client.getColor());
        }
        this.client = client;
        this.setLocation();
    }

    private void setLocation() {
        double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setLocation((int)witdhScreen / 2 - this.getWidth() / 2, (int)heightScreen / 2 - this.getHeight() / 2);
    }

    private void initComponents() {
        this.jPanelMain = new JPanel();
        this.jLabelAddWsdl = new JLabel();
        this.jTextFieldAddWsdl = new JTextField();
        this.jButtonBrowse = new JButton();
        this.jButtonOK = new JButton();
        this.jLabelAddWsdl.setText("Add wsdl url:");
        this.jTextFieldAddWsdl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddWsdlFrame.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonBrowse.setText("Browse");
        this.jButtonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddWsdlFrame.this.jButtonBrowseActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddWsdlFrame.this.jButtonOKActionPerformed(evt);
            }
        });
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addComponent(this.jLabelAddWsdl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldAddWsdl, -2, 453, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonBrowse, -1, 105, Short.MAX_VALUE)).addComponent(this.jButtonOK, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelAddWsdl).addComponent(this.jTextFieldAddWsdl, -2, -1, -2).addComponent(this.jButtonBrowse)).addGap(18, 18, 18).addComponent(this.jButtonOK).addContainerGap(25, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelMain, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelMain, -2, -1, -2));
        this.pack();
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        JFileChooser c = new JFileChooser();
        c.addChoosableFileFilter(new WSDLFilter());
        c.setAcceptAllFileFilterUsed(false);
        int rVal = c.showOpenDialog(this);
        if (rVal == 0) {
            this.jTextFieldAddWsdl.setText(c.getSelectedFile().getAbsolutePath());
        }
        if (rVal == 1) {
            this.jTextFieldAddWsdl.setText("");
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.addNewWsdl(this.jTextFieldAddWsdl.getText());
    }

    public void addNewWsdl(String wsdl) {
        try {
            if (wsdl != null && wsdl.trim().length() > 0) {
                URL wsdlURL = null;
                wsdlURL = new File(wsdl).exists() ? new File(wsdl).toURI().toURL() : new URL(wsdl);
                if (this.client != null) {
                    this.client.addNewWsdlofWebServices(wsdlURL);
                    this.client.refreshAll();
                    this.setVisible(false);
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
        }
        catch (WSOUIClientException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new AddWsdlFrame(null).setVisible(true);
            }
        });
    }
}

