/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.model.impl.gov;

import com.ebmwebsourcing.easiergov.client.impl.AdminManagerClientImpl;
import com.ebmwebsourcing.easiergov.client.impl.ConnexionManagerClientImpl;
import com.ebmwebsourcing.easiestdemo.contant.EasiestDEMOFramework;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.resolver.URIMemoryMultipleResolvers;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easycommons.xml.resolver.ClasspathURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.DefaultURIResolver;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.petalslink.admin_api._1.GetServices;
import com.petalslink.admin_api._1_0.GetInformationFault;
import com.petalslink.admin_api._1_0.GetServicesFault;
import com.petalslink.easiergov.core.container.Container;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.GetAllEnvironments;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1_0.GetAllEnvironmentsFault;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbExecutionEnvironmentInformation;
import easybox.org.w3._2005._08.addressing.EJaxbEndpointReferenceType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.URIResolver;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Service;
import org.petalslink.abslayer.service.impl.wsdl11.DescriptionImpl;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.gov.GovNode;
import org.petalslink.easiestdemo.client.model.api.gov.ProvidedService;
import org.petalslink.easiestdemo.client.model.impl.gov.ProvidedServiceImpl;
import org.petalslink.easiestdemo.client.util.SpecificClasspathURIResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GovNodeImpl
implements GovNode {
    private AdminManagerClientImpl adminClient = null;
    private ConnexionManagerClientImpl connexionClient = null;
    private List<Node> connectedNodes = new ArrayList<Node>();
    private List<ProvidedService> providedServices = new ArrayList<ProvidedService>();
    private Container model = null;
    private Registry registry = null;
    private String govAddress = null;
    private QName name = null;

    public GovNodeImpl(String address, Registry registry) throws SOAPException {
        this.govAddress = address;
        this.registry = registry;
        this.init(this.govAddress);
    }

    private void init(String address) throws SOAPException {
        try {
            this.adminClient = new AdminManagerClientImpl(address);
            this.name = this.adminClient.getInformation();
            for (EJaxbEndpointReferenceType epr : this.adminClient.getServices(new GetServices()).getEndpointReference()) {
                if (epr.getMetadata() == null || epr.getMetadata().getAny().size() <= 0) continue;
                System.out.println("--------------- Read wsdl");
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild(doc.adoptNode((Element)epr.getMetadata().getAny().get(0)));
                System.out.println("WSDL to read: \n" + XMLPrettyPrinter.prettyPrint((Document)doc));
                try {
                    Definitions def = (Definitions)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasiestDEMOFramework.getInstance()).get()).readDocument(doc, Definitions.class);
                    Description desc = (Description)Factory.getInstance().wrap((XmlObject)def);
                    this.providedServices.add(new ProvidedServiceImpl(new QName(def.getServices()[0].inferQName().getNamespaceURI(), def.getServices()[0].getPorts()[0].getName()), ((Service)desc.getServices().iterator().next()).getEndpoints()[0], (Service)desc.getServices().iterator().next()));
                }
                catch (Throwable e) {
                    System.err.println("Error to read wsdl of: " + epr.getAddress().getValue());
                }
            }
            ProvidedService connexionServ = this.findProvidedService("ConnexionManagerPort");
            this.connexionClient = new ConnexionManagerClientImpl(connexionServ.getAddress());
        }
        catch (GetServicesFault e) {
            throw new SOAPException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new SOAPException((Throwable)e);
        }
        catch (GetInformationFault e) {
            throw new SOAPException((Throwable)e);
        }
    }

    @Override
    public void setModel(Container model) throws SOAPException {
        this.model = model;
    }

    @Override
    public QName getQName() {
        return this.name;
    }

    @Override
    public List<ProvidedService> getProvidedServices() {
        return this.providedServices;
    }

    public String toString() {
        return this.getQName().getLocalPart();
    }

    @Override
    public List<Node> getConnectedNodes() throws WSOUIClientException {
        return this.connectedNodes;
    }

    @Override
    public void refreshConnectedNodes() throws WSOUIClientException {
        try {
            GetAllEnvironments request = new GetAllEnvironments();
            for (EJaxbExecutionEnvironmentInformation env : this.connexionClient.getAllEnvironments(request).getExecutionEnvironmentInformation()) {
                for (Node n : this.registry.getAllNodes()) {
                    QName envName = QName.valueOf(env.getName());
                    if (!n.getQName().equals(envName)) continue;
                    this.connectedNodes.add(n);
                }
            }
        }
        catch (GetAllEnvironmentsFault e) {
            throw new WSOUIClientException(e);
        }
    }

    public ProvidedService findProvidedService(String name) {
        ProvidedService res = null;
        for (ProvidedService ps : this.providedServices) {
            if (!ps.getName().getLocalPart().equals(name)) continue;
            res = ps;
            break;
        }
        return res;
    }

    static {
        SOAUtil.getInstance().getXmlContext((Framework)EasiestDEMOFramework.getInstance()).setURIResolver((URIResolver)new URIMemoryMultipleResolvers(new URIResolver[]{new DefaultURIResolver(), new ClasspathURIResolver(), new SpecificClasspathURIResolver()}));
        DescriptionImpl.setXmlContext((XmlContext)SOAUtil.getInstance().getXmlContext((Framework)EasiestDEMOFramework.getInstance()));
    }
}

