package org.petalslink.easiestdemo.client.model.impl.esb;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.petalslink.abslayer.service.api.Service;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.model.api.esb.ClientEndpointProxy;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.esb.ProviderEndpoint;
import org.petalslink.easiestdemo.client.model.api.esb.ProviderEndpointProxy;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easierbsm.admin.client.api.BSMAdminClient;
import com.ebmwebsourcing.easierbsm.admin.client.impl.BSMAdminClientImpl;
import com.ebmwebsourcing.easiestdemo.contant.EasiestDEMOFramework;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easyesb.admin.client.api.AdminClient;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ProviderProxyBehaviourImpl;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;

import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbClientProxyEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbNodeType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbProviderEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbProviderProxyEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbTransporterListType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbTransporterType;
import easyesb.petalslink.com.data.admin._1.GetNodeInformations;
import easyesb.petalslink.com.data.admin._1.GetNodeInformationsResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;

public class NodeImpl implements Node {

	private Description adminServiceDescription;

	private QName name = null;
	private List<QName> neighbourNodeNames = new ArrayList<QName>();

	private List<ProviderEndpoint> providerEndpoints = new ArrayList<ProviderEndpoint>();
	private List<ProviderEndpointProxy> providerEndpointProxies = new ArrayList<ProviderEndpointProxy>();
	private List<ClientEndpointProxy> clientEndpointProxies = new ArrayList<ClientEndpointProxy>();

	private com.ebmwebsourcing.easyesb.soa.api.node.Node model = null;

	private EJaxbBasicNodeInformationsType basicInfos = null;

	private boolean isMonitoringNode = false;

	private List<Node> monitoredNodes = new ArrayList<Node>();

	private AdminClient adminClient = null;
	private BSMAdminClient bsmadminClient = null;
	
	private easybox.easyesb.petalslink.com.soa.model.datatype._1.ObjectFactory factory = new easybox.easyesb.petalslink.com.soa.model.datatype._1.ObjectFactory();

	private Registry registry;

	public NodeImpl(Description desc, Registry registry) throws SOAPException {
		try {
			this.registry = registry;
			adminServiceDescription = desc;
			if(!this.adminServiceDescription.getDocumentBaseURI().toString().contains("bsmadminExternalEndpoint")) {
				this.adminClient = new AdminClientImpl(this.adminServiceDescription.getDocumentBaseURI().toString());
			} else {
				this.bsmadminClient = new BSMAdminClientImpl(this.adminServiceDescription.getDocumentBaseURI().toString());
			}
			EJaxbNodeType response = this.getState();
			this.analyzeState(response);
		} catch(WSOUIClientException e) {
			throw new SOAPException(e);
		} catch (ESBException e) {
			throw new SOAPException(e);
		} 
	}

	@Override
	public AdminClient getAdminClient() {
		return adminClient;
	}

	@Override
	public BSMAdminClient getBSMAdminClient() {
		return bsmadminClient;
	}


	@Override
	public com.ebmwebsourcing.easyesb.soa.api.node.Node getModel() {
		return model;
	}

	@Override
	public void setModel(com.ebmwebsourcing.easyesb.soa.api.node.Node model) {
		this.model = model;
	}

	@Override
	public QName getQName() {
		return name;
	}

	@Override
	public Description getAdministrationServiceDescription() {
		return this.adminServiceDescription;
	}

	@Override
	public List<QName> getNeighbourNodeNames() {
		return neighbourNodeNames;
	}

	private EJaxbNodeType getState() throws SOAPException {
		try {
			EJaxbNodeType node = null;

			if(this.adminClient != null) {
				GetNodeInformations request = new GetNodeInformations();
				GetNodeInformationsResponse response = this.adminClient.getNodeInformations(request);
				node = response.getNode();
			} else {
				easierbsm.petalslink.com.data.bsmadmin._1.GetNodeInformations request = new easierbsm.petalslink.com.data.bsmadmin._1.GetNodeInformations();
				easierbsm.petalslink.com.data.bsmadmin._1.GetNodeInformationsResponse response = this.bsmadminClient.getNodeInformations(request);
				node = response.getNode();
			}
			return node;
		} catch (ManagementException e) {
			throw new SOAPException(e);
		} catch (easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg e) {
			throw new SOAPException(e);
		} 
	}

	@Override
	public Document getStateOfNode() throws SOAPException {
		try {
			EJaxbNodeType response = this.getState();
			Document responseDoc = SOAJAXBContext.getInstance().unmarshallAnyElement(factory.createNode(response));
			return responseDoc;
		} catch(SOAException e) {
			throw new SOAPException(e);
		} 
	}

	@Override
	public void analyzeState(EJaxbNodeType node) throws WSOUIClientException  {
		try {
			// clean
			this.neighbourNodeNames.clear();
			this.providerEndpointProxies.clear();
			this.providerEndpoints.clear();
			this.clientEndpointProxies.clear();

			this.basicInfos = node.getBasicNodeInformations();
			this.name = basicInfos.getNodeName();

			// get neighbour node names
			for(EJaxbBasicNodeInformationsType nodeI: node.getRegistry().getNeighbourNode()) {
				neighbourNodeNames.add(nodeI.getNodeName());
			}

			Iterator<?> it = node.getRegistry().getLocalEndpointsGroupList().getEndpointGroup().iterator();
			while(it.hasNext()) {
				EJaxbEndpointType ep = (EJaxbEndpointType) it.next();
				for(String behaviour: ep.getBehavioursList().getBehaviour()) {
					Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(behaviour);
					if (clazz == ProviderProxyBehaviourImpl.class) {
						EJaxbProviderProxyEndpointType pep = (EJaxbProviderProxyEndpointType)ep;
						analyzeProviderProxyEndpoint(pep);
					} else if (clazz == com.ebmwebsourcing.easyesb.component.bpel.impl.BPELProviderEndpointBehaviourImpl.class) {
						EJaxbProviderEndpointType pe = (EJaxbProviderEndpointType)ep;
						analyzeProviderEndpoint(pe);
					} else if (clazz == com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl.class) {
						EJaxbClientProxyEndpointType pep = (EJaxbClientProxyEndpointType)ep;
						analyzeClientProxyEndpoint(pep, node);
					}
				}
			}
		} catch(ClassNotFoundException e) {
			throw new WSOUIClientException(e);
		}
	}

	@Override
	public List<ProviderEndpoint> getProviderEndpoints() {
		return providerEndpoints;
	}

	@Override
	public List<ProviderEndpointProxy> getProviderEndpointProxies() {
		return providerEndpointProxies;
	}

	@Override
	public List<ClientEndpointProxy> getClientEndpointProxies() {
		return clientEndpointProxies;
	}

	private void analyzeClientProxyEndpoint(EJaxbClientProxyEndpointType cep, EJaxbNodeType node) throws WSOUIClientException {
		try {
			EJaxbTransporterType transporter = node.getBasicNodeInformations().getTransporterList().getTransporter().get(0);
			
			URL wsdl = new URL(cep.getListenerInitialisation().get(0).getExposableAddress().getValue() + "?wsdl");
			Description description = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasiestDEMOFramework.getInstance()).get().readDocument(wsdl, Definitions.class));

			Service sDesc = description.findService(cep.getProviderServiceName());
			if(sDesc == null) {
				throw new WSOUIClientException("Impossible to find service " + cep.getProviderServiceName() + " in description");
			}
			
			String endpointToFind = "";
			if(cep.getProviderEndpointName() == null){
				//It's a component and its endpoint name is the name of the component (?)
				endpointToFind = cep.getProviderServiceName().getLocalPart();
			}else{
				endpointToFind = cep.getProviderEndpointName();
			}
			Endpoint epDesc = sDesc.getEndpoint(endpointToFind);
			
			if(epDesc == null) {
				throw new WSOUIClientException("Impossible to find endpoint " + cep.getProviderEndpointName() + " in description");
			}

			//		if(cep.getProviderServiceName().getLocalPart().endsWith("admin") == false) {
			this.clientEndpointProxies.add(new ClientEndpointProxyImpl(this, new QName(sDesc.getQName().getNamespaceURI(),cep.getName()), epDesc, sDesc));
			//		}
		} catch (MalformedURLException e) {
			throw new WSOUIClientException(e);
		} catch (XmlObjectReadException e) {
			throw new WSOUIClientException(e);
		} catch (SOAPException e) {
			throw new WSOUIClientException(e);
		} 
	}

	private void analyzeProviderEndpoint(EJaxbProviderEndpointType pe) throws WSOUIClientException {
		try {
			URL wsdl = new URL(pe.getWsdlDescription());

			Description description = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasiestDEMOFramework.getInstance()).get().readDocument(wsdl, Definitions.class));

			Service sDesc = description.findService(pe.getServiceName());
			if(sDesc == null) {
				throw new WSOUIClientException("Impossible to find service " + pe.getServiceName() + " in description");
			}

			Endpoint epDesc = sDesc.getEndpoint(pe.getName());
			if(epDesc == null) {
				throw new WSOUIClientException("Impossible to find endpoint " + pe.getName() + " in description");
			}

			this.providerEndpoints.add(new ProviderEndpointImpl(this, epDesc, sDesc));
		} catch (MalformedURLException e) {
			throw new WSOUIClientException(e);
		} catch (XmlObjectReadException e) {
			throw new WSOUIClientException(e);
		}
	}

	private void analyzeProviderProxyEndpoint(EJaxbProviderProxyEndpointType pep) throws WSOUIClientException {
		try {
			URL wsdl = new URL(pep.getWsdlDescription());

			Description description = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasiestDEMOFramework.getInstance()).get().readDocument(wsdl, Definitions.class));

			Service sDesc = description.findService(pep.getServiceName());
			if(sDesc == null) {
				throw new WSOUIClientException("Impossible to find service " + pep.getServiceName() + " in description");
			}

			Endpoint epDesc = sDesc.getEndpoint(pep.getName());
			if(epDesc == null) {
				throw new WSOUIClientException("Impossible to find endpoint " + pep.getName() + " in description");
			}

			this.providerEndpointProxies.add(new ProviderEndpointProxyImpl(this, epDesc, sDesc));
		} catch (MalformedURLException e) {
			throw new WSOUIClientException(e);
		} catch (XmlObjectReadException e) {
			throw new WSOUIClientException(e);
		}
	}

	@Override
	public EJaxbBasicNodeInformationsType getBasicInfos() {
		return basicInfos;
	}

	@Override
	public void setBasicInfos(EJaxbBasicNodeInformationsType basicInfos) {
		this.basicInfos = basicInfos;
	}

	@Override
	public String toString() {
		return this.name.getLocalPart();
	}

	@Override
	public boolean isMonitoringNode() {
		return this.isMonitoringNode;
	}

	@Override
	public void setMonitoringNode(boolean monitoring) {
		this.isMonitoringNode = monitoring;
	}

	@Override
	public List<Node> getMonitoredNodes() throws WSOUIClientException {
		return this.monitoredNodes;
	}

	@Override
	public void refreshMonitoredNodes() throws WSOUIClientException {
		if(this.isMonitoringNode) {
			this.monitoredNodes.clear();
			try {
				for(String address: this.bsmadminClient.getConnectedEsbs()) {
					for(Node n: this.registry.getAllNodes()) {
						if(n.getAdministrationServiceDescription().getDocumentBaseURI().toString().contains(address)) {
							this.monitoredNodes.add(n);
						}
					}
				}
			} catch (easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg e) {
				throw new WSOUIClientException(e);
			} 
		}
	}
}
