/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.petalslink.easiestdemo.client.topology;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.easiestdemo.client.gui.Property;
import org.petalslink.easiestdemo.client.model.api.esb.ClientEndpointProxy;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.esb.ProviderEndpoint;
import org.petalslink.easiestdemo.client.model.api.esb.ProviderEndpointProxy;

/**
 *
 * @author Nico
 */
public class EsbG extends RectangleG {

	private List<InternalClientProxyEndpointG> proxyClients = new ArrayList<InternalClientProxyEndpointG>();
	private List<InternalProviderEndpointG> providers = new ArrayList<InternalProviderEndpointG>();
	private List<InternalProviderProxyEndpointG> proxyProviders = new ArrayList<InternalProviderProxyEndpointG>();

	private Node model = null;

	public EsbG(TopologyView topology, Node node, int init_x, int init_y) {
		super(topology, node.getQName().getLocalPart(), init_x, init_y);
		this.model = node;
		if(this.model.isMonitoringNode()) {
			this.setBackgroundColor(new Color(84,255,159));
		}

		this.properties.add(new Property("name", this.model.getQName().getLocalPart()));
		this.properties.add(new Property("namespace", this.model.getQName().getNamespaceURI()));
		this.properties.add(new Property("administration service url", this.model.getAdministrationServiceDescription().getServices().iterator().next().getEndpoints()[0].getAddress()));
		this.properties.add(new Property("neighbour nodes", this.model.getNeighbourNodeNames()));
		this.properties.add(new Property("number of client proxy endpoints", this.model.getClientEndpointProxies().size()));
		this.properties.add(new Property("number of provider endpoints", this.model.getProviderEndpoints().size()));
		this.properties.add(new Property("number of provider proxy endpoints", this.model.getProviderEndpointProxies().size()));
	}

	public void update(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;
		g2.setStroke(new BasicStroke(8.0f));

		this.proxyClients.clear();
		for(ClientEndpointProxy cep: model.getClientEndpointProxies()) {
			this.proxyClients.add(new InternalClientProxyEndpointG(this.topology, cep));
		}

		this.providers.clear();
		for(ProviderEndpoint pe: model.getProviderEndpoints()) {
			this.providers.add(new InternalProviderEndpointG(this.topology, pe));
		}

		this.proxyProviders.clear();
		for(ProviderEndpointProxy pep: model.getProviderEndpointProxies()) {
			this.proxyProviders.add(new InternalProviderProxyEndpointG(this.topology, pep));
		}

		this.draw(g2);

		int init_x = (int)(this.rect.x - InternalClientProxyEndpointG.DEFAULT_SIZE/2) ;
		int spacey = this.rect.height / (this.proxyClients.size()+1);
		int init_y = this.rect.y + spacey;
		for(InternalClientProxyEndpointG p: this.proxyClients) {
			p.setLocation(init_x, init_y);
			p.update(g2);
			init_y = init_y + spacey;
		}

		init_x = (int)(this.rect.x + (this.rect.getWidth()/2) - InternalProviderEndpointG.DEFAULT_SIZE/2) ;
		spacey = this.rect.height / (this.providers.size()+1);
		init_y = this.rect.y + spacey;
		for(InternalProviderEndpointG p: this.providers) {
			p.setLocation(init_x, init_y);
			p.update(g2);
			init_y = init_y + spacey;
		}

		init_x = (int)(this.rect.x + this.rect.getWidth() - InternalProviderProxyEndpointG.DEFAULT_SIZE/2) ;
		spacey = this.rect.height / (this.proxyProviders.size()+1);
		init_y = this.rect.y + spacey;
		for(InternalProviderProxyEndpointG proxyp: this.proxyProviders) {
			proxyp.setLocation(init_x, init_y);
			proxyp.update(g2);
			init_y = init_y + spacey;
		} 
	}

	public List<InternalProviderProxyEndpointG> getProxyProviders() {
		return proxyProviders;
	}

	public List<InternalClientProxyEndpointG> getProxyClients() {
		return proxyClients;
	}

	public List<InternalProviderEndpointG> getProviders() {
		return providers;
	}

	public QName getQName() {
		return this.model.getQName();
	}

	public List<QName> getNeighbourNodeNames() {
		return this.model.getNeighbourNodeNames();
	}

	public Node getModel() {
		return model;
	}

}
