/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.petalslink.easiestdemo.client.topology;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.easiestdemo.client.gui.Property;
import org.petalslink.easiestdemo.client.model.api.gov.GovNode;
import org.petalslink.easiestdemo.client.model.api.gov.ProvidedService;

/**
 *
 * @author Nico
 */
public class GovG extends RectangleG {

    private List<ProvidedServiceG> providedService = new ArrayList<ProvidedServiceG>();

    private List<Property> properties = new ArrayList<Property>();

    private GovNode model = null;

    public GovG(TopologyView topology, GovNode node, int init_x, int init_y) {
    	super(topology, node.getQName().getLocalPart(), init_x, init_y);
    	this.setBorderColor(new Color(132,112,255));
    	this.setBackgroundColor(new Color(255,20,147));
        this.model = node;
        this.properties.add(new Property("name", ""));
        this.properties.add(new Property("namespace", ""));
        this.properties.add(new Property("port", ""));
        this.properties.add(new Property("number of provided service", this.model.getProvidedServices().size()));
    }

    public void update(Graphics g) {
        Graphics2D g2 = (Graphics2D) g;
        g2.setStroke(new BasicStroke(8.0f));

        this.providedService.clear();
        for(ProvidedService cep: model.getProvidedServices()) {
            this.providedService.add(new ProvidedServiceG(this.topology, cep));
        }

        this.draw(g2);

        int init_x = (int)(this.rect.x - InternalClientProxyEndpointG.DEFAULT_SIZE/2) ;
        int spacey = this.rect.height / (this.providedService.size()+1);
        int init_y = this.rect.y + spacey;
        for(ProvidedServiceG p: this.providedService) {
            p.setLocation(init_x, init_y);
            p.update(g2);
            init_y = init_y + spacey;
        }

       
    }

 
    public List<ProvidedServiceG> getProvidedServices() {
        return providedService;
    }

    public QName getQName() {
        return this.model.getQName();
    }

    public GovNode getModel() {
        return model;
    }
    
}
