/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * CreateNodeFrame.java
 *
 * Created on 20 mars 2011, 01:03:23
 */

package org.petalslink.easiestdemo.client.topology.menu.action;

import java.awt.Toolkit;

import javax.swing.JOptionPane;

import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;

/**
 *
 * @author nsalatge
 */
public class CreateNodeFrame extends javax.swing.JFrame {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static int indicePort = 0;

	private WSOUIClient client;
	private Registry registry;
	private boolean monitoring;

	/** Creates new form CreateNodeFrame */
	public CreateNodeFrame(WSOUIClient client, boolean monitoring) {
		initComponents();
		if(client != null) {
			this.jPanelMain.setBackground(client.getColor());
		}
		this.monitoring = monitoring;

		this.jTextFieldNodeName.setText("esb-node" + indicePort);
		this.jTextFieldNodeNamespace.setText("http://www.petalslink.com/easyesb");
		
		if(this.monitoring) {
			this.setTitle("Create Monitoring");
			this.jTextFieldNodeName.setText("monitoring-node" + indicePort);
			this.jTextFieldNodeNamespace.setText("http://www.petalslink.com/easierbsm");
		} else {
			this.setTitle("Create Node");
		}
		this.setIconImage(Toolkit.getDefaultToolkit().getImage(WSOUIClient.ICON_IMAGE));

		this.client = client;
		this.registry = client.getRegistry();
		
		
		this.jTextFieldHost.setText("localhost");
		this.jTextFieldPort.setText("930" + indicePort);
		this.jTextFieldSoapPort.setText("828" + indicePort);
		this.setLocation();
	}


	private void setLocation() {
		double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
		double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
		this.setLocation((int)witdhScreen/2 - this.getWidth()/2, (int)heightScreen/2 - this.getHeight()/2);
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanelMain = new javax.swing.JPanel();
        jLabelNodeName = new javax.swing.JLabel();
        jTextFieldNodeName = new javax.swing.JTextField();
        jLabelNodeNamespace = new javax.swing.JLabel();
        jTextFieldNodeNamespace = new javax.swing.JTextField();
        jLabelHost = new javax.swing.JLabel();
        jTextFieldHost = new javax.swing.JTextField();
        jLabelPort = new javax.swing.JLabel();
        jTextFieldPort = new javax.swing.JTextField();
        jLabelSoapPort = new javax.swing.JLabel();
        jTextFieldSoapPort = new javax.swing.JTextField();
        jButtonOk = new javax.swing.JButton();

        jLabelNodeName.setText("Node name:");

        jLabelNodeNamespace.setText("Node namespace:");

        jLabelHost.setText("Host:");

        jLabelPort.setText("Port:");

        jLabelSoapPort.setText("Soap port:");

        jButtonOk.setText("OK");
        jButtonOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOkActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanelMainLayout = new javax.swing.GroupLayout(jPanelMain);
        jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(
            jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanelMainLayout.createSequentialGroup()
                .addContainerGap(635, Short.MAX_VALUE)
                .addComponent(jButtonOk)
                .addContainerGap())
            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jPanelMainLayout.createSequentialGroup()
                    .addContainerGap()
                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addComponent(jLabelNodeNamespace)
                        .addComponent(jLabelHost)
                        .addComponent(jLabelNodeName)
                        .addComponent(jLabelPort)
                        .addComponent(jLabelSoapPort))
                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addComponent(jTextFieldNodeName, javax.swing.GroupLayout.DEFAULT_SIZE, 582, Short.MAX_VALUE)
                        .addComponent(jTextFieldHost, javax.swing.GroupLayout.DEFAULT_SIZE, 582, Short.MAX_VALUE)
                        .addComponent(jTextFieldNodeNamespace, javax.swing.GroupLayout.DEFAULT_SIZE, 582, Short.MAX_VALUE)
                        .addComponent(jTextFieldPort, javax.swing.GroupLayout.DEFAULT_SIZE, 582, Short.MAX_VALUE)
                        .addComponent(jTextFieldSoapPort, javax.swing.GroupLayout.DEFAULT_SIZE, 582, Short.MAX_VALUE))
                    .addContainerGap()))
        );
        jPanelMainLayout.setVerticalGroup(
            jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanelMainLayout.createSequentialGroup()
                .addContainerGap(152, Short.MAX_VALUE)
                .addComponent(jButtonOk)
                .addContainerGap())
            .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                .addGroup(jPanelMainLayout.createSequentialGroup()
                    .addContainerGap()
                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabelNodeName)
                        .addComponent(jTextFieldNodeName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabelNodeNamespace)
                        .addComponent(jTextFieldNodeNamespace, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabelHost)
                        .addComponent(jTextFieldHost, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabelPort)
                        .addComponent(jTextFieldPort, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                    .addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabelSoapPort)
                        .addComponent(jTextFieldSoapPort, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addContainerGap(51, Short.MAX_VALUE)))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanelMain, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPanelMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

	private void jButtonOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOkActionPerformed
		try {
			this.registry.createNode(this.jTextFieldNodeName.getText(), this.jTextFieldNodeNamespace.getText(), this.jTextFieldHost.getText(), this.jTextFieldPort.getText(), this.jTextFieldSoapPort.getText(), this.monitoring);
			this.client.refreshAll();
			indicePort++;
			this.setVisible(false);
		} catch (WSOUIClientException e) {
			e.printStackTrace();
			JOptionPane.showMessageDialog(this,
					e.getMessage(), 
					"Creation Interrupted", JOptionPane.ERROR_MESSAGE);
		}
	}//GEN-LAST:event_jButtonOkActionPerformed

	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		java.awt.EventQueue.invokeLater(new Runnable() {
			public void run() {
				new CreateNodeFrame(null, false).setVisible(true);
			}
		});
	}

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonOk;
    private javax.swing.JLabel jLabelHost;
    private javax.swing.JLabel jLabelNodeName;
    private javax.swing.JLabel jLabelNodeNamespace;
    private javax.swing.JLabel jLabelPort;
    private javax.swing.JLabel jLabelSoapPort;
    private javax.swing.JPanel jPanelMain;
    private javax.swing.JTextField jTextFieldHost;
    private javax.swing.JTextField jTextFieldNodeName;
    private javax.swing.JTextField jTextFieldNodeNamespace;
    private javax.swing.JTextField jTextFieldPort;
    private javax.swing.JTextField jTextFieldSoapPort;
    // End of variables declaration//GEN-END:variables

}
