/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2006 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package org.petalslink.easiestdemo.client.gui;

import java.util.logging.Logger;

import javax.swing.JPopupMenu;

import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.model.api.ws.MockBinding;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockOperation;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;

import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;

/**
 *
 *
 * @author Nicolas SALATGE - eBM WebSourcing
 */
public class MenuMouseRegistryTree extends JPopupMenu {

	/**
	 * serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;


	private static Logger LOG = Logger.getLogger(MenuMouseRegistryTree.class.getName());


	private javax.swing.JMenuItem jMenuItemGetWSDL;



	private WSOUIClient scw;

	private MockService service;
	private MockEndpoint endpoint;
	private MockBinding binding;
	private MockOperation operation;



	/** Creates a new instance of MenuMouse */
	public MenuMouseRegistryTree(WSOUIClient scw) {
		this.scw = scw;

		this.initComponents();
	}

	private void cleanGUIComponent() {
		this.scw.getjTextFieldEndpointName().setText("");
		this.scw.getjTextFieldInterfaceQName().setText("");
		this.scw.getjTextFieldOperationName().setText("");
		this.scw.getjTextFieldServiceQName().setText("");
		this.scw.getjTextFieldSendTo().setText("");
	}

	public Object getSelectedItem() {
		Object res = null;
		if(service != null) {
			res = service;
		} else if(endpoint != null ) {
			res = endpoint;
		} else if(binding != null ) {
			res = binding;
		} else if(operation != null) {
			res = operation;
		}
		return res;
	}

	public void setService(final MockService service) {
		this.service = service;
		this.endpoint = null;
		this.operation = null;
		this.binding = null;

		this.jMenuItemGetWSDL.setEnabled(true);
	}

	public void setEndpoint(final MockEndpoint endpoint) {
		this.endpoint = endpoint;
		this.service = null;
		this.operation = null;
		this.binding = null;

		this.jMenuItemGetWSDL.setEnabled(true);
	}

	public void setBinding(final MockBinding b) {
		this.binding = b;
		this.endpoint = null;
		this.service = null;
		this.operation = null;

		this.jMenuItemGetWSDL.setEnabled(true);
	}

	public void setOperation(final MockOperation op) {
		this.operation = op;
		this.endpoint = null;
		this.binding = null;
		this.service = null;

		this.jMenuItemGetWSDL.setEnabled(true);

	}

	private void initComponents() {
		this.jMenuItemGetWSDL = new javax.swing.JMenuItem();

		this.setComponentPopupMenu(this);

		this.jMenuItemGetWSDL.setText("Get service contract (WSDL)");
		this.jMenuItemGetWSDL
		.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(
					final java.awt.event.ActionEvent evt) {
				MenuMouseRegistryTree.this
				.jMenuItemGetWSDLActionPerformed(evt);
			}
		});
		this.add(this.jMenuItemGetWSDL);

	}


	private void jMenuItemGetWSDLActionPerformed(
			final java.awt.event.ActionEvent evt) {
		try {
			Description def = null;
			if(this.getSelectedItem() instanceof MockService) {
				def = ((MockService)this.getSelectedItem()).getDescription();
			} else if(this.getSelectedItem() instanceof MockEndpoint) {
				def = ((MockEndpoint)this.getSelectedItem()).getService().getDescription();
			} else if(this.getSelectedItem() instanceof MockBinding) {
				def = ((MockBinding)this.getSelectedItem()).getEndpoint().getService().getDescription();
			} else if(this.getSelectedItem() instanceof MockOperation) {
				def = ((MockOperation)this.getSelectedItem()).getBinding().getEndpoint().getService().getDescription();
			}

			WSDLFrame wsdl = new WSDLFrame(XMLPrettyPrinter.prettyPrint(def.write()));
			wsdl.setVisible(true);

			LOG.finest(this.getSelectedItem() + " has been selected");
			this.setVisible(false);
		} catch (XmlObjectWriteException e) {
			LOG.finest("Error to get WSDL Description: " + e.getMessage());
			this.setVisible(false);
		}
	}

	public void jMenuItemSetAllActionPerformed(
			final java.awt.event.ActionEvent evt) {
		this.cleanGUIComponent();
		if(this.getSelectedItem() instanceof MockService) {
			this.scw.getjTextFieldServiceQName().setText(((MockService)this.getSelectedItem()).getQName().toString());
		} else if(this.getSelectedItem() instanceof MockEndpoint) {
			this.scw.getjTextFieldServiceQName().setText(((MockEndpoint)this.getSelectedItem()).getService().getQName().toString());
			this.scw.getjTextFieldEndpointName().setText(((MockEndpoint)this.getSelectedItem()).getName());
		} else if(this.getSelectedItem() instanceof MockBinding) {
			MockBinding b = (MockBinding)this.getSelectedItem();
			this.scw.getjTextFieldServiceQName().setText(b.getEndpoint().getService().getQName().toString());
			this.scw.getjTextFieldEndpointName().setText(b.getEndpoint().getName());
			this.scw.getjTextFieldInterfaceQName().setText(b.getInterfaceQName().toString());
		} else if(this.getSelectedItem() instanceof MockOperation) {
			MockOperation bop = (MockOperation)this.getSelectedItem();
			this.scw.getjTextFieldServiceQName().setText(bop.getBinding().getEndpoint().getService().getQName().toString());
			this.scw.getjTextFieldEndpointName().setText(bop.getBinding().getEndpoint().getName());
			this.scw.getjTextFieldInterfaceQName().setText(bop.getBinding().getInterfaceQName().toString());
			this.scw.getjTextFieldOperationName().setText(bop.getName());
			this.scw.getjTextFieldSendTo().setText(bop.getBinding().getEndpoint().getAddress());
		}

		LOG.finest(this.getSelectedItem() + " has been selected");
		this.setVisible(false);
	}


}
